/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.specifications.domain.legal.raides;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.District;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.ulisboa.specifications.domain.exceptions.ULisboaSpecificationsDomainException;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.ILegalMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.IntegratedMasterFirstCycleGraduatedReportOption;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.Raides;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.RaidesInstance$callable$delete;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.RaidesInstance$callable$edit;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.RaidesInstance$callable$edit$1;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.RaidesInstance_Base;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.mapping.BranchMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.mapping.LegalMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReportRequest;
import org.fenixedu.ulisboa.specifications.util.ULisboaSpecificationsUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class RaidesInstance
extends RaidesInstance_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public Set<ILegalMappingType> getMappingTypes() {
        return Sets.newHashSet((Object[])LegalMappingType.values());
    }

    public Set<?> getPossibleKeys(String type) {
        return LegalMappingType.valueOf(type).getValues();
    }

    public LocalizedString getMappingTypeNameI18N(String type) {
        if (BranchMappingType.isTypeForMapping(type)) {
            return BranchMappingType.getInstance().getName();
        }
        return LegalMappingType.valueOf(type).getName();
    }

    public LocalizedString getLocalizedNameMappingKey(String type, String key) {
        if (BranchMappingType.isTypeForMapping(type)) {
            return BranchMappingType.getInstance().getLocalizedNameKey(key);
        }
        return LegalMappingType.valueOf(type).getLocalizedNameKey(key);
    }

    public LocalizedString getNameI18N() {
        return ULisboaSpecificationsUtil.bundleI18N((String)("title." + RaidesInstance.class.getName()), (String[])new String[0]);
    }

    public static synchronized RaidesInstance getInstance() {
        RaidesInstance instance = RaidesInstance.find(RaidesInstance.class);
        if (instance != null) {
            return instance;
        }
        return null;
    }

    protected static <T extends LegalReport> T find(Class<T> reportClass) {
        for (LegalReport report : Bennu.getInstance().getLegalReportsSet()) {
            if (reportClass != ((Object)((Object)report)).getClass()) continue;
            return (T)((Object)report);
        }
        return null;
    }

    public void executeProcessing(LegalReportRequest reportRequest) {
        new Raides().process(this, reportRequest);
    }

    public void edit(LocalizedString localizedString, PersistentGroup persistentGroup, Boolean bl, Boolean bl2) {
        Object object = advice$edit.perform((Callable)new RaidesInstance$callable$edit(this, localizedString, persistentGroup, bl, bl2));
    }

    static /* synthetic */ void advised$edit(RaidesInstance this_, LocalizedString name, PersistentGroup group, Boolean synchronous, Boolean hasMappings) {
        this_.setName(name);
        this_.setGroup(group);
        this_.setSynchronous(synchronous);
        this_.setHasMappings(hasMappings);
    }

    public void edit(LocalizedString localizedString, PersistentGroup persistentGroup, Boolean bl, Boolean bl2, String string, Set<RegistrationProtocol> set, Set<RegistrationProtocol> set2, Set<IngressionType> set3, Set<IngressionType> set4, Set<IngressionType> set5, String string2, String string3, IntegratedMasterFirstCycleGraduatedReportOption integratedMasterFirstCycleGraduatedReportOption, District district, boolean bl3, Set<StatuteType> set6) {
        Object object = advice$edit$1.perform((Callable)new RaidesInstance$callable$edit$1(this, localizedString, persistentGroup, bl, bl2, string, set, set2, set3, set4, set5, string2, string3, integratedMasterFirstCycleGraduatedReportOption, district, bl3, set6));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$edit(RaidesInstance this_, LocalizedString name, PersistentGroup group, Boolean synchronous, Boolean hasMappings, String passwordToZip, Set enrolledAgreements, Set mobilityAgreements, Set degreeTransferIngressions, Set degreeChangeIngressions, Set generalAccessRegimeIngressions, String institutionCode, String interlocutorPhone, IntegratedMasterFirstCycleGraduatedReportOption integratedMasterFirstCycleGraduatedReportOption, District defaultDistrictOfResidence, boolean reportGraduatedWithoutConclusionProcess, Set grantOwnerStatuteTypes) {
        this_.edit(name, group, synchronous, hasMappings);
        this_.setPasswordToZip(passwordToZip);
        this_.getEnrolledAgreementsSet().clear();
        this_.getEnrolledAgreementsSet().addAll(enrolledAgreements);
        this_.getMobilityAgreementsSet().clear();
        this_.getMobilityAgreementsSet().addAll(mobilityAgreements);
        this_.getDegreeTransferIngressionsSet().clear();
        this_.getDegreeTransferIngressionsSet().addAll(degreeTransferIngressions);
        this_.getDegreeChangeIngressionsSet().clear();
        this_.getDegreeChangeIngressionsSet().addAll(degreeChangeIngressions);
        this_.getGeneralAccessRegimeIngressionsSet().clear();
        this_.getGeneralAccessRegimeIngressionsSet().addAll(generalAccessRegimeIngressions);
        this_.setInstitutionCode(institutionCode);
        this_.setInterlocutorPhone(interlocutorPhone);
        this_.setIntegratedMasterFirstCycleGraduatedReportOption(integratedMasterFirstCycleGraduatedReportOption);
        this_.setDefaultDistrictOfResidence(defaultDistrictOfResidence);
        this_.setReportGraduatedWithoutConclusionProcess(reportGraduatedWithoutConclusionProcess);
        this_.getGrantOwnerStatuteTypesSet().clear();
        this_.getGrantOwnerStatuteTypesSet().addAll(grantOwnerStatuteTypes);
    }

    public boolean isToReportAllIntegratedMasterFirstCycleGraduatedStudents() {
        return this.getIntegratedMasterFirstCycleGraduatedReportOption() == IntegratedMasterFirstCycleGraduatedReportOption.ALL;
    }

    public boolean isToReportIntegratedMasterFirstCycleGraduatedStudentsOnlyWithConclusionProcess() {
        return this.getIntegratedMasterFirstCycleGraduatedReportOption() == IntegratedMasterFirstCycleGraduatedReportOption.WITH_CONCLUSION_PROCESS;
    }

    public boolean isToNotReportIntegratedMasterFirstCycleGraduatedStudents() {
        return this.getIntegratedMasterFirstCycleGraduatedReportOption() == null || this.getIntegratedMasterFirstCycleGraduatedReportOption() == IntegratedMasterFirstCycleGraduatedReportOption.NONE;
    }

    public boolean isSumEctsCreditsBetweenPlans() {
        return this.getSumEctsCreditsBetweenPlans();
    }

    public boolean isReportGraduatedWithoutConclusionProcess() {
        return this.getReportGraduatedWithoutConclusionProcess();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new RaidesInstance$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(RaidesInstance this_) {
        if (this_.getLegalMappingsSet().size() > 0) {
            throw new ULisboaSpecificationsDomainException("error.report.delete.not.empty.mappings", new String[0]);
        }
        if (this_.getLegalRequestsSet().size() > 0) {
            throw new ULisboaSpecificationsDomainException("error.report.delete.not.empty.requests", new String[0]);
        }
        super.setGroup(null);
        super.setBennu(null);
        super.deleteDomainObject();
    }
}

