/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.specifications.domain.legal.mapping;

import com.google.common.base.Strings;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.ulisboa.specifications.domain.exceptions.ULisboaSpecificationsDomainException;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMappingEntry_Base;

public class LegalMappingEntry
extends LegalMappingEntry_Base {
    protected LegalMappingEntry() {
        this.setBennu(Bennu.getInstance());
    }

    LegalMappingEntry(LegalMapping mapping, String key, String value) {
        this();
        this.setLegalMapping(mapping);
        this.setMappingKey(key);
        this.setMappingValue(value);
        this.checkRules();
    }

    public LocalizedString getLocalizedNameKeyI18N() {
        return this.getLegalMapping().getLocalizedNameEntryKeyI18N(this.getMappingKey());
    }

    protected void checkRules() {
        if (Strings.isNullOrEmpty((String)this.getMappingKey())) {
            throw new ULisboaSpecificationsDomainException("error.MappingEntry.key.must.not.be.blank.or.null", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getMappingValue())) {
            throw new ULisboaSpecificationsDomainException("error.MappingEntry.value.must.not.be.blank.or.null", new String[0]);
        }
    }

    void delete() {
        this.setBennu(null);
        this.setLegalMapping(null);
        this.deleteDomainObject();
    }
}

