/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.legalpt.services.raides.process;

import com.google.common.base.Strings;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.legalpt.domain.LegalReportContext;
import org.fenixedu.legalpt.services.raides.process.RaidesService;
import org.fenixedu.ulisboa.specifications.domain.legal.mapping.LegalMapping;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.Raides;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.TblIdentificacao;
import org.fenixedu.ulisboa.specifications.domain.legal.raides.mapping.LegalMappingType;
import org.fenixedu.ulisboa.specifications.domain.legal.report.LegalReport;
import org.fenixedu.ulisboa.specifications.util.IdentityCardUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.Years;

public class IdentificacaoService
extends RaidesService {
    public IdentificacaoService(LegalReport report) {
        super(report);
    }

    public TblIdentificacao create(Unit institution, Student student, Registration registration, ExecutionYear executionYear) {
        TblIdentificacao bean = new TblIdentificacao();
        bean.setIdAluno(registration.getStudent().getNumber());
        bean.setNome(student.getName());
        bean.setNumId(student.getPerson().getDocumentIdNumber());
        if (student.getPerson().getIdDocumentType() != null) {
            bean.setTipoId(LegalMapping.find(this.report, LegalMappingType.ID_DOCUMENT_TYPE).translate((Enum<?>)student.getPerson().getIdDocumentType()));
        }
        if ("7".equals(bean.getTipoId())) {
            bean.setTipoIdDescr(student.getPerson().getIdDocumentType().getLocalizedName());
        }
        if (student.getPerson().getIdDocumentType() == IDDocumentType.IDENTITY_CARD) {
            String digitControlPerson = IdentityCardUtils.getDigitControlFromPerson((Person)student.getPerson());
            bean.setCheckDigitId(digitControlPerson);
            if (Strings.isNullOrEmpty((String)bean.getCheckDigitId()) && student.getPerson().getIdDocumentType() == IDDocumentType.IDENTITY_CARD) {
                try {
                    int digitControl = IdentityCardUtils.generateBilheteIdentidadeDigitControl((String)student.getPerson().getDocumentIdNumber());
                    bean.setCheckDigitId(String.valueOf(digitControl));
                    LegalReportContext.addWarn("", this.i18n("warn.Raides.identity.card.digit.control.generated", Raides.formatArgs(registration, executionYear)), new String[0]);
                }
                catch (NumberFormatException e) {
                    LegalReportContext.addError("", this.i18n("error.Raides.validation.cannot.generate.digit.control", Raides.formatArgs(registration, executionYear)), new String[0]);
                    bean.markAsInvalid();
                }
            }
        }
        if (student.getPerson().getDateOfBirthYearMonthDay() != null) {
            bean.setDataNasc(student.getPerson().getDateOfBirthYearMonthDay().toLocalDate());
        }
        if (student.getPerson().getGender() != null) {
            bean.setSexo(LegalMapping.find(this.report, LegalMappingType.GENDER).translate((Enum<?>)student.getPerson().getGender()));
        }
        this.preencheNacionalidade(student, bean);
        Country countryOfResidence = Raides.countryOfResidence(registration, executionYear);
        if (countryOfResidence != null) {
            bean.setResidePais(countryOfResidence.getCode());
        }
        bean.setPaisEnsinoSecundario(this.countryHighSchool(registration));
        this.validaPais(bean, institution, student, registration, executionYear);
        this.validaDocumentoIdentificacao(bean, institution, student, registration, executionYear);
        this.validaDataNascimento(bean, institution, student, registration, executionYear);
        return bean;
    }

    private void preencheNacionalidade(Student student, TblIdentificacao bean) {
        Country firstNationality = student.getPerson().getCountry();
        Country secondNationality = null;
        if (student.getPerson().getPersonUlisboaSpecifications() != null) {
            secondNationality = student.getPerson().getPersonUlisboaSpecifications().getSecondNationality();
        }
        if (firstNationality == null && secondNationality == null) {
            return;
        }
        if (firstNationality != null && secondNationality == null) {
            bean.setNacionalidade(firstNationality.getCode());
            bean.setOutroPaisDeNacionalidade(null);
            return;
        }
        if (firstNationality == null && secondNationality != null) {
            bean.setNacionalidade(secondNationality.getCode());
            bean.setOutroPaisDeNacionalidade(null);
            return;
        }
        if (firstNationality != null && firstNationality == secondNationality) {
            bean.setNacionalidade(firstNationality.getCode());
            bean.setOutroPaisDeNacionalidade(null);
            return;
        }
        if (secondNationality.isDefaultCountry()) {
            bean.setNacionalidade(secondNationality.getCode());
            bean.setOutroPaisDeNacionalidade(firstNationality.getCode());
        } else {
            bean.setNacionalidade(firstNationality.getCode());
            bean.setOutroPaisDeNacionalidade(secondNationality.getCode());
        }
    }

    protected String countryHighSchool(Registration registration) {
        PrecedentDegreeInformation pid = registration.getStudentCandidacy().getPrecedentDegreeInformation();
        if (pid != null && pid.getSchoolLevel() == SchoolLevelType.HIGH_SCHOOL_OR_EQUIVALENT && pid.getCountry() != null) {
            return pid.getCountry().getCode();
        }
        if (registration.getPerson().getCountryHighSchool() != null) {
            return registration.getPerson().getCountryHighSchool().getCode();
        }
        if (registration.getStudentCandidacy().getPrecedentDegreeInformation().getCountryHighSchool() != null) {
            return registration.getStudentCandidacy().getPrecedentDegreeInformation().getCountryHighSchool().getCode();
        }
        if (registration.getPerson().getCountry() != null) {
            LegalReportContext.addWarn("", this.i18n("warn.Raides.countryHighSchool.retrived.from.nationality", Raides.formatArgs(registration, null)), new String[0]);
            return registration.getPerson().getCountry().getCode();
        }
        return null;
    }

    protected void validaDataNascimento(TblIdentificacao bean, Unit institution, Student student, Registration registration, ExecutionYear executionYear) {
        if (bean.getDataNasc() == null) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.birth.date.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if (bean.getDataNasc() != null) {
            LocalDate december31BeginExecYear = new LocalDate(executionYear.getBeginCivilYear(), 12, 31);
            long age = Years.yearsBetween((ReadablePartial)bean.getDataNasc(), (ReadablePartial)december31BeginExecYear).getYears();
            if (age < (long)Raides.Idade.MIN.intValue() || age > (long)Raides.Idade.MAX.intValue()) {
                LegalReportContext.addError("", this.i18n("error.Raides.validation.birth.date.invalid", Raides.formatArgs(registration, executionYear)), new String[0]);
                bean.markAsInvalid();
            }
        }
    }

    protected void validaDocumentoIdentificacao(TblIdentificacao bean, Unit institution, Student student, Registration registration, ExecutionYear executionYear) {
        if (Strings.isNullOrEmpty((String)bean.getNumId())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.missing.document.id", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        } else if (bean.getNumId().matches(".*\\s.*")) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.document.id.contains.spaces", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        } else if (IDDocumentType.IDENTITY_CARD == registration.getPerson().getIdDocumentType() || IDDocumentType.CITIZEN_CARD == registration.getPerson().getIdDocumentType()) {
            if (!bean.getNumId().matches("\\d+")) {
                LegalReportContext.addError("", this.i18n("error.Raides.validation.national.document.id.contains.other.than.spaces", Raides.formatArgs(registration, executionYear)), new String[0]);
                bean.markAsInvalid();
            }
            if (student.getPerson().getIdDocumentType() == IDDocumentType.IDENTITY_CARD && student.getPerson().getDocumentIdNumber().length() != 8) {
                LegalReportContext.addError("", this.i18n("error.Raides.validation.document.id.invalid", Raides.formatArgs(registration, executionYear)), new String[0]);
                bean.markAsInvalid();
            }
        }
    }

    protected void validaPais(TblIdentificacao bean, Unit institution, Student student, Registration registration, ExecutionYear executionYear) {
        if (Strings.isNullOrEmpty((String)bean.getResidePais())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.country.of.residence.incomplete", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getNacionalidade())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.nationality.incomplete", Raides.formatArgs(registration, executionYear)), new String[0]);
            bean.markAsInvalid();
        }
        if (Strings.isNullOrEmpty((String)bean.getPaisEnsinoSecundario())) {
            LegalReportContext.addError("", this.i18n("error.Raides.validation.high.school.country.missing", Raides.formatArgs(registration, executionYear)), new String[0]);
        }
    }
}

