/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse.components;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.BibliographicReference;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.executionCourse.components.BaseExecutionCourseComponent;

@ComponentType(name="bibliographicReferences", description="Bibliographic References for an Execution Course")
public class BibliographicReferencesComponent
extends BaseExecutionCourseComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        ExecutionCourse executionCourse = page.getSite().getExecutionCourse();
        globalContext.put((Object)"executionCourse", (Object)executionCourse);
        globalContext.put((Object)"mainReferences", this.mainReferences(executionCourse));
        globalContext.put((Object)"secondaryReferences", this.secundaryReferences(executionCourse));
        globalContext.put((Object)"optionalReferences", this.optionalReferences(executionCourse));
        globalContext.put((Object)"nonOptionalReferences", this.nonOptionalReferences(executionCourse));
    }

    public List<BibliographicReferences.BibliographicReference> secundaryReferences(ExecutionCourse executionCourse) {
        return this.bibliographiReferences(executionCourse).stream().filter(b -> b.isSecondary()).collect(Collectors.toList());
    }

    public List<BibliographicReferences.BibliographicReference> mainReferences(ExecutionCourse executionCourse) {
        return this.bibliographiReferences(executionCourse).stream().filter(b -> b.isMain()).collect(Collectors.toList());
    }

    public List<BibliographicReference> optionalReferences(ExecutionCourse executionCourse) {
        return executionCourse.getOrderedBibliographicReferences().stream().filter(b -> b.isOptional()).collect(Collectors.toList());
    }

    public List<BibliographicReference> nonOptionalReferences(ExecutionCourse executionCourse) {
        return executionCourse.getOrderedBibliographicReferences().stream().filter(b -> !b.isOptional()).collect(Collectors.toList());
    }

    public List<BibliographicReferences.BibliographicReference> bibliographiReferences(ExecutionCourse executionCourse) {
        ArrayList references = Lists.newArrayList();
        for (CompetenceCourseInformation competenceCourseInfo : executionCourse.getCompetenceCoursesInformations()) {
            if (competenceCourseInfo.getBibliographicReferences() == null) continue;
            references.addAll(competenceCourseInfo.getBibliographicReferences().getBibliographicReferencesSortedByOrder());
        }
        return references;
    }
}

