/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse;

import com.google.common.base.Joiner;
import java.util.Objects;
import java.util.Optional;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.cms.domain.Role;
import org.fenixedu.cms.domain.RoleTemplate;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.learning.domain.executionCourse.ExecutionCourseSiteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionCourseListener {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionCourseListener.class);

    public static Site create(ExecutionCourse executionCourse) {
        Group group;
        Role teacherRole;
        Site newSite = ExecutionCourseSiteBuilder.getInstance().create(executionCourse.getNameI18N(), ExecutionCourseListener.getObjectives(executionCourse).orElseGet(() -> executionCourse.getNameI18N()), ExecutionCourseListener.formatSlugForExecutionCourse(executionCourse));
        executionCourse.setSite(newSite);
        RoleTemplate defaultTemplate = newSite.getDefaultRoleTemplate();
        if (defaultTemplate != null) {
            teacherRole = new Role(defaultTemplate, executionCourse.getSite());
            group = teacherRole.getGroup();
            for (Professorship pr : executionCourse.getProfessorshipsSet()) {
                User user = pr.getPerson().getUser();
                if (pr.getPermissions().getSections() && !group.isMember(user)) {
                    group = group.grant(user);
                    continue;
                }
                if (!group.isMember(user)) continue;
                group = group.revoke(user);
            }
        } else {
            throw new DomainException("no.default.role", new String[0]);
        }
        teacherRole.setGroup(group);
        logger.info("Created site for execution course " + executionCourse.getSigla());
        return newSite;
    }

    private static Optional<LocalizedString> getObjectives(ExecutionCourse executionCourse) {
        return executionCourse.getCompetenceCourses().stream().map(competenceCourse -> competenceCourse.getObjectivesI18N((ExecutionInterval)executionCourse.getExecutionPeriod())).filter(Objects::nonNull).findFirst();
    }

    private static String formatSlugForExecutionCourse(ExecutionCourse executionCourse) {
        return Joiner.on((String)"-").join((Object)executionCourse.getSigla(), (Object)executionCourse.getExternalId(), new Object[0]);
    }

    public static void updateSiteSlug(ExecutionCourse instance) {
        instance.getSite().setSlug(ExecutionCourseListener.formatSlugForExecutionCourse(instance));
        instance.setSiteUrl(instance.getSite().getFullUrl());
    }

    public static void updateProfessorship(Professorship professorship, Boolean allowAccess) {
        ExecutionCourse executionCourse = professorship.getExecutionCourse();
        RoleTemplate defaultTemplate = executionCourse.getSite().getDefaultRoleTemplate();
        if (defaultTemplate != null) {
            Role teacherRole = executionCourse.getSite().getRolesSet().stream().filter(role -> role.getRoleTemplate().equals((Object)defaultTemplate)).findAny().orElseGet(() -> new Role(defaultTemplate, executionCourse.getSite()));
            Group group = teacherRole.getGroup();
            User user = professorship.getPerson().getUser();
            if (allowAccess.booleanValue() && !group.isMember(user)) {
                group = group.grant(user);
                teacherRole.setGroup(group);
            } else if (group.isMember(user)) {
                group = group.revoke(user);
                teacherRole.setGroup(group);
            }
        } else {
            throw new DomainException("no.default.role", new String[0]);
        }
    }
}

