/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.degree.components;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.EnrolmentToBeApprovedByCoordinator;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degreeStructure.BranchCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.util.CurricularPeriodLabelFormatter;
import org.fenixedu.academic.util.CurricularRuleLabelFormatter;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.domain.wraps.Wrap;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.learning.domain.DegreeCurricularPlanServices;
import org.fenixedu.learning.domain.degree.components.CurricularCourseComponent;
import org.fenixedu.learning.domain.degree.components.DegreeSiteComponent;
import pt.ist.fenixframework.FenixFramework;

@ComponentType(name="Degree Curriculum", description="Curriculum for a degree")
public class DegreeCurriculumComponent
extends DegreeSiteComponent {
    private Site site;

    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        Degree degree = this.degree(page);
        this.site = page.getSite();
        String pageUrl = DegreeCurriculumComponent.pageForComponent(this.site, CurricularCourseComponent.class).map(Page::getAddress).orElse(null);
        ExecutionYear selectedYear = this.selectedYear((String)globalContext.get((Object)"year"), degree);
        DegreeCurricularPlan plan = this.selectedPlan((String)globalContext.get((Object)"plan"), degree, selectedYear);
        globalContext.put((Object)"courseGroups", this.courseGroups(plan, selectedYear, pageUrl));
        globalContext.put((Object)"allCurricularCourses", this.allCurricularCourses(this.courseGroups(plan, selectedYear, pageUrl).collect(Collectors.toSet())));
        globalContext.put((Object)"coursesByCurricularSemester", this.coursesByCurricularSemester(plan, selectedYear, pageUrl));
        globalContext.put((Object)"years", DegreeCurricularPlanServices.getDegreeCurricularPlansExecutionYears(degree).stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList()));
        globalContext.put((Object)"selectedYear", (Object)selectedYear);
        globalContext.put((Object)"plans", DegreeCurricularPlanServices.getDegreeCurricularPlansForYear(degree, Optional.of(selectedYear)).stream().sorted(DegreeCurricularPlan.COMPARATOR_BY_PRESENTATION_NAME.reversed()).collect(Collectors.toList()));
        globalContext.put((Object)"selectedPlan", (Object)plan);
    }

    SortedMap<CurricularPeriod, Set<CurricularCourseWrap>> coursesByCurricularSemester(DegreeCurricularPlan plan, ExecutionYear year, String pageUrl) {
        return this.allCurricularCourses(this.courseGroups(plan, year, pageUrl).collect(Collectors.toSet())).collect(Collectors.groupingBy(CurricularCourseWrap::getCurricularPeriod, TreeMap::new, Collectors.toCollection(TreeSet::new)));
    }

    Stream<CurricularCourseWrap> allCurricularCourses(Collection<CourseGroupWrap> fathers) {
        Stream childrenCall = fathers.stream().flatMap(father -> this.allCurricularCourses(father.getCourseGroups().collect(Collectors.toSet())));
        return Stream.concat(fathers.stream().flatMap(CourseGroupWrap::getCurricularCourses), childrenCall);
    }

    Stream<CourseGroupWrap> courseGroups(DegreeCurricularPlan plan, ExecutionYear year, String pageUrl) {
        if (plan == null) {
            return Stream.empty();
        }
        CourseGroupWrap root = new CourseGroupWrap(null, (CourseGroup)plan.getRoot(), year, pageUrl);
        return root.getCourseGroups();
    }

    ExecutionYear selectedYear(String year, Degree degree) {
        DegreeCurricularPlan dcp;
        ExecutionYear result = null;
        if (!Strings.isNullOrEmpty((String)year)) {
            result = (ExecutionYear)FenixFramework.getDomainObject((String)year);
        }
        if (result == null && (dcp = DegreeCurricularPlanServices.getMostRecentDegreeCurricularPlan(degree, Optional.empty())) != null) {
            result = dcp.getLastExecutionYear();
        }
        if (result == null) {
            result = ExecutionYear.readCurrentExecutionYear();
        }
        return result;
    }

    DegreeCurricularPlan selectedPlan(String oid, Degree degree, ExecutionYear year) {
        DegreeCurricularPlan result = null;
        if (!Strings.isNullOrEmpty((String)oid)) {
            result = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)oid);
        }
        if (result == null) {
            result = DegreeCurricularPlanServices.getMostRecentDegreeCurricularPlan(degree, Optional.of(year));
        }
        return result;
    }

    private class CurricularCourseWrap
    extends Wrap
    implements Comparable<CurricularCourseWrap> {
        private final Context context;
        private final ExecutionYear executionInterval;
        private final CurricularCourse curricularCourse;
        private final String pageUrl;

        public CurricularCourseWrap(Context context, ExecutionYear executionInterval, String pageUrl) {
            this.context = context;
            this.pageUrl = pageUrl;
            this.curricularCourse = (CurricularCourse)context.getChildDegreeModule();
            this.executionInterval = executionInterval;
        }

        public boolean isOptional() {
            return this.curricularCourse.isOptional() || this.context.getParentCourseGroup().isOptionalCourseGroup();
        }

        public LocalizedString getName() {
            LocalizedString name = this.curricularCourse.getNameI18N((ExecutionInterval)this.executionInterval);
            return name.isEmpty() ? new LocalizedString(I18N.getLocale(), "-") : name;
        }

        public String getUrl() {
            return this.pageUrl + "/" + this.curricularCourse.getExternalId();
        }

        public String getContextInformation() {
            return CurricularPeriodLabelFormatter.getFullLabel((CurricularPeriod)this.context.getCurricularPeriod(), (boolean)true);
        }

        public boolean isSemestrial() {
            return this.curricularCourse.isSemestrial(this.executionInterval);
        }

        public boolean hasRegime() {
            return !this.isOptional() && this.curricularCourse.hasRegime(this.executionInterval);
        }

        public String getRegime() {
            RegimeType regime = this.curricularCourse.getRegime(this.executionInterval);
            return regime == null ? "-" : regime.getLocalizedName();
        }

        public String getRegimeAcronym() {
            RegimeType regime = this.curricularCourse.getRegime(this.executionInterval);
            return regime == null ? "-" : regime.getAcronym();
        }

        public String getContactLoad() {
            Double load = this.curricularCourse.getContactLoad(null, (ExecutionInterval)this.executionInterval);
            return new BigDecimal(load).setScale(2, RoundingMode.HALF_EVEN).toPlainString();
        }

        public String getAutonomousWorkHours() {
            return this.curricularCourse.getAutonomousWorkHours(this.context.getCurricularPeriod(), (ExecutionInterval)this.executionInterval).toString();
        }

        public String getTotalLoad() {
            return this.curricularCourse.getTotalLoad(null, (ExecutionInterval)this.executionInterval).toString();
        }

        public String getECTS() {
            return this.curricularCourse.getEctsCredits((CurricularPeriod)null, (ExecutionInterval)this.executionInterval).toString();
        }

        public boolean hasCompentenceCourse() {
            return this.curricularCourse.getCompetenceCourse() != null;
        }

        public Stream<String> getRules() {
            return this.getRulesObjects().map(rule -> CurricularRuleLabelFormatter.getLabel((ICurricularRule)rule));
        }

        private Stream<CurricularRule> getRulesObjects() {
            return this.curricularCourse.getVisibleCurricularRules(this.executionInterval).stream().filter(rule -> rule.appliesToContext(this.context));
        }

        public CurricularPeriod getCurricularPeriod() {
            return this.context.getCurricularPeriod();
        }

        @Override
        public int compareTo(CurricularCourseWrap o) {
            if (this.isOptional() && !o.isOptional()) {
                return 1;
            }
            if (!this.isOptional() && o.isOptional()) {
                return -1;
            }
            return this.getName().compareTo(o.getName());
        }
    }

    private class CourseGroupWrap
    extends Wrap {
        private final ExecutionYear executionInterval;
        private final CourseGroup courseGroup;
        private final Context previous;
        private final String pageUrl;

        public CourseGroupWrap(Context previous, CourseGroup courseGroup, ExecutionYear executionInterval, String pageUrl) {
            this.executionInterval = executionInterval;
            this.courseGroup = courseGroup;
            this.previous = previous;
            this.pageUrl = pageUrl;
        }

        public boolean hasCurricularCourses() {
            return this.courseGroup.hasAnyChildContextWithCurricularCourse();
        }

        public LocalizedString getName() {
            return this.courseGroup.getNameI18N();
        }

        public Stream<String> getRules() {
            return this.courseGroup.getVisibleCurricularRules(this.executionInterval).stream().filter(rule -> rule.appliesToContext(this.previous)).map(rule -> CurricularRuleLabelFormatter.getLabel((ICurricularRule)rule));
        }

        public Stream<CurricularCourseWrap> getCurricularCourses() {
            return this.courseGroup.getSortedOpenChildContextsWithCurricularCourses(this.executionInterval).stream().map(context -> new CurricularCourseWrap((Context)context, this.executionInterval, this.pageUrl)).filter(course -> ((CurricularCourseWrap)course).getRulesObjects().noneMatch(EnrolmentToBeApprovedByCoordinator.class::isInstance));
        }

        public Stream<CourseGroupWrap> getCourseGroups() {
            return this.courseGroup.getSortedOpenChildContextsWithCourseGroups(this.executionInterval).stream().map(context -> new CourseGroupWrap((Context)context, (CourseGroup)context.getChildDegreeModule(), this.executionInterval, this.pageUrl));
        }

        public String getExternalId() {
            return this.courseGroup.getExternalId();
        }

        public String buildImage() {
            String oid = this.getExternalId();
            return String.format("<img id=\"aa%s\" src=\"%s\" onclick=\"toggleImage($('#aa%s'));toggleCheck($('#%s'));return false\">", oid, this.getInitialImage(), oid, oid);
        }

        public String getInitialStyle() {
            return this.courseGroup.getIsOptional() || this.courseGroup instanceof BranchCourseGroup ? "display:none" : "";
        }

        private String getInitialImage() {
            String result = Strings.isNullOrEmpty((String)this.getInitialStyle()) ? "toggle_minus10.gif" : "toggle_plus10.gif";
            return DegreeCurriculumComponent.this.site.getStaticDirectory() + "/images/" + result;
        }
    }
}

