/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.degree.components;

import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.DegreeCurricularPlanServices;
import org.fenixedu.learning.domain.degree.components.DegreeSiteComponent;
import pt.ist.fenixframework.FenixFramework;

@ComponentType(name="Degree curricular plans", description="Curricular plans of a degree")
public class DegreeCurricularPlansComponent
extends DegreeSiteComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        Degree degree = this.degree(page);
        Optional<ExecutionYear> yearOptional = this.getSelectedExecutionYear(globalContext.getRequestContext());
        DegreeCurricularPlan degreeCurricularPlan = DegreeCurricularPlanServices.getMostRecentDegreeCurricularPlan(degree, yearOptional);
        ExecutionYear year = yearOptional.isPresent() ? yearOptional.get() : degreeCurricularPlan.getLastExecutionYear();
        globalContext.put((Object)"degreeCurricularPlan", (Object)degreeCurricularPlan);
        globalContext.put((Object)"executionYear", (Object)year);
        globalContext.put((Object)"executionYears", DegreeCurricularPlanServices.getDegreeCurricularPlansExecutionYears(degree).stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList()));
    }

    private Optional<ExecutionYear> getSelectedExecutionYear(String[] requestContext) {
        return requestContext.length > 2 ? Optional.of(FenixFramework.getDomainObject((String)requestContext[1])) : Optional.empty();
    }
}

