/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.degree.components;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.degree.components.DegreeSiteComponent;
import pt.ist.fenixframework.FenixFramework;

@ComponentType(name="Curricular Course", description="Curricular course info")
public class CurricularCourseComponent
extends DegreeSiteComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        CurricularCourse curricularCourse = (CurricularCourse)FenixFramework.getDomainObject((String)globalContext.getRequestContext()[1]);
        ExecutionSemester period = this.getExecutionSemester(curricularCourse, globalContext.getRequestContext());
        globalContext.put((Object)"curricularCourse", this.createWrap(curricularCourse, period));
    }

    private ExecutionSemester getExecutionSemester(CurricularCourse curricularCourse, String[] request) {
        return request.length > 2 ? (ExecutionSemester)FenixFramework.getDomainObject((String)request[2]) : curricularCourse.getParentDegreeCurricularPlan().getMostRecentExecutionYear().getLastExecutionPeriod();
    }

    private HashMap<String, Object> createWrap(CurricularCourse curricularCourse, ExecutionSemester period) {
        HashMap wrap = Maps.newHashMap();
        wrap.put("period", period);
        wrap.put("name", curricularCourse.getNameI18N((ExecutionInterval)period));
        wrap.put("degreeCurricularPlanName", curricularCourse.getDegreeCurricularPlan().getPresentationName());
        wrap.put("acronym", curricularCourse.getAcronym((ExecutionInterval)period));
        wrap.put("isOptional", curricularCourse.isOptional());
        wrap.put("executionCourses", curricularCourse.getAssociatedExecutionCoursesSet().stream().sorted(ExecutionCourse.EXECUTION_COURSE_EXECUTION_PERIOD_COMPARATOR.reversed()).map(ec -> this.createWrap((ExecutionCourse)ec)).collect(Collectors.toList()));
        wrap.put("parentContexts", curricularCourse.getParentContextsByExecutionYear(period.getExecutionYear()));
        wrap.put("weight", curricularCourse.getWeight((ExecutionInterval)period));
        wrap.put("prerequisites", curricularCourse.getPrerequisitesI18N());
        wrap.put("objectives", curricularCourse.getObjectivesI18N((ExecutionInterval)period));
        wrap.put("program", curricularCourse.getProgramI18N((ExecutionInterval)period));
        wrap.put("evaluationMethod", curricularCourse.getEvaluationMethodI18N((ExecutionInterval)period));
        return wrap;
    }

    private Map<String, Object> createWrap(ExecutionCourse executionCourse) {
        HashMap wrap = Maps.newHashMap();
        wrap.put("name", executionCourse.getNameI18N());
        wrap.put("executionYear", executionCourse.getExecutionYear().getYear());
        wrap.put("executionPeriod", executionCourse.getExecutionPeriod().getName());
        wrap.put("url", executionCourse.getSite() != null ? executionCourse.getSite().getFullUrl() : "#");
        return wrap;
    }
}

