/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DegreeCurricularPlanServices {
    public static final Logger logger = LoggerFactory.getLogger(DegreeCurricularPlanServices.class);

    public static DegreeCurricularPlan getMostRecentDegreeCurricularPlan(Degree degree, Optional<ExecutionYear> executionYearOptional) {
        return DegreeCurricularPlanServices.getDegreeCurricularPlansForYear(degree, executionYearOptional).stream().max(Comparator.comparing(DegreeCurricularPlan::getInitialDateYearMonthDay)).orElse(null);
    }

    public static Set<DegreeCurricularPlan> getDegreeCurricularPlansForYear(Degree degree, Optional<ExecutionYear> yearOptional) {
        HashSet result = Sets.newHashSet();
        if (degree != null) {
            ExecutionYear year;
            ExecutionYear executionYear = year = yearOptional.isPresent() ? yearOptional.get() : (ExecutionYear)DegreeCurricularPlanServices.getDegreeCurricularPlansExecutionYears(degree).stream().max(ExecutionYear::compareTo).orElse(null);
            if (year != null) {
                degree.getDegreeCurricularPlansSet().stream().filter(DegreeCurricularPlanServices.predicateDCP(year)).collect(Collectors.toCollection(() -> result));
            }
        }
        return result;
    }

    private static Predicate<DegreeCurricularPlan> predicateDCP(ExecutionYear year) {
        return plan -> plan.isApproved() && plan.isActive() && plan.hasExecutionDegreeFor(year) && !plan.getCurricularCoursesWithExecutionIn(year).isEmpty();
    }

    public static Set<ExecutionYear> getDegreeCurricularPlansExecutionYears(Degree degree) {
        HashSet result = Sets.newHashSet();
        if (degree != null) {
            return degree.getDegreeCurricularPlansSet().stream().flatMap(plan -> plan.getExecutionDegreesSet().stream()).filter(ed -> DegreeCurricularPlanServices.predicateDCP(ed.getExecutionYear()).test(ed.getDegreeCurricularPlan())).map(ed -> ed.getExecutionYear()).collect(Collectors.toCollection(() -> result));
        }
        return result;
    }
}

