/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.commons.i18n.LocalizedString;

public class CompetenceCourseBean {
    private final CompetenceCourse competenceCourse;
    private final ExecutionSemester executionSemester;
    private final Set<CurricularCourse> curricularCourses;
    private final LocalizedString name;
    private final LocalizedString objectives;
    private final LocalizedString program;

    public CompetenceCourseBean(CompetenceCourse competenceCourse, Set<CurricularCourse> curricularCourses, ExecutionSemester executionSemester) {
        this.competenceCourse = competenceCourse;
        this.executionSemester = executionSemester;
        this.curricularCourses = curricularCourses;
        this.name = competenceCourse.getNameI18N((ExecutionInterval)executionSemester);
        this.objectives = competenceCourse.getObjectivesI18N((ExecutionInterval)executionSemester);
        this.program = competenceCourse.getProgramI18N((ExecutionInterval)executionSemester);
    }

    public CompetenceCourse getCompetenceCourse() {
        return this.competenceCourse;
    }

    public ExecutionSemester getExecutionSemester() {
        return this.executionSemester;
    }

    public Set<CurricularCourse> getCurricularCourses() {
        return this.curricularCourses;
    }

    public LocalizedString getName() {
        return this.name;
    }

    public LocalizedString getObjectives() {
        return this.objectives;
    }

    public static List<CompetenceCourseBean> approvedCompetenceCourses(ExecutionCourse executionCourse) {
        return executionCourse.getCurricularCoursesIndexedByCompetenceCourse().entrySet().stream().filter(entry -> ((CompetenceCourse)entry.getKey()).isApproved()).map(entry -> new CompetenceCourseBean((CompetenceCourse)entry.getKey(), (Set)entry.getValue(), executionCourse.getExecutionPeriod())).collect(Collectors.toList());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("objectives", (Object)this.objectives).add("executionSemester", (Object)this.executionSemester).add("curricularCourses", this.curricularCourses).toString();
    }

    public LocalizedString getProgram() {
        return this.program;
    }
}

