/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.degree.components;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.SchoolClass_Base;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.dto.InfoDegree;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.DegreeCurricularPlanServices;
import org.fenixedu.learning.domain.degree.components.ClassScheduleComponent;
import org.fenixedu.learning.domain.degree.components.DegreeSiteComponent;
import pt.ist.fenixframework.FenixFramework;

@ComponentType(name="Degree classes", description="Schedule of a class")
public class DegreeClassesComponent
extends DegreeSiteComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext global) {
        Degree degree = this.degree(page);
        global.put((Object)"degreeInfo", (Object)InfoDegree.newInfoFromDomain((Degree)degree));
        global.put((Object)"timetablePage", DegreeClassesComponent.pageForComponent(page.getSite(), ClassScheduleComponent.class).map(Page::getAddress).orElse(null));
        ExecutionSemester selectedSemester = this.getExecutionSemester(global.getRequestContext());
        ExecutionSemester otherSemester = this.getOtherExecutionSemester(selectedSemester);
        SortedMap<Integer, Set<SchoolClass>> selectedClasses = this.classesByCurricularYear(degree, selectedSemester);
        SortedMap<Integer, Set<SchoolClass>> nextClasses = this.classesByCurricularYear(degree, otherSemester);
        global.put((Object)"classesByCurricularYearAndSemesters", (Object)ImmutableMap.of((Object)selectedSemester, selectedClasses, (Object)otherSemester, nextClasses));
    }

    private SortedMap<Integer, Set<SchoolClass>> classesByCurricularYear(Degree degree, ExecutionSemester semester) {
        DegreeCurricularPlan plan = DegreeCurricularPlanServices.getMostRecentDegreeCurricularPlan(degree, Optional.of(semester.getExecutionYear()));
        Predicate<SchoolClass> predicate = schoolClass -> schoolClass.getExecutionDegree().getDegreeCurricularPlan() == plan;
        return semester.getSchoolClassesSet().stream().filter(predicate).collect(Collectors.groupingBy(SchoolClass_Base::getAnoCurricular, TreeMap::new, Collectors.toCollection(() -> Sets.newTreeSet((Comparator)SchoolClass.COMPARATOR_BY_NAME))));
    }

    private ExecutionSemester getOtherExecutionSemester(ExecutionSemester semester) {
        ExecutionSemester next = semester.getNextExecutionPeriod();
        return next != null && this.canViewNextExecutionSemester(next) ? next : semester.getPreviousExecutionPeriod();
    }

    private boolean canViewNextExecutionSemester(ExecutionSemester nextExecutionSemester) {
        Predicate<Person> hasPerson = person -> person != null;
        Predicate<Person> isCoordinator = person -> RoleType.COORDINATOR.isMember(person.getUser());
        Predicate<Person> isManager = person -> RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(person.getUser());
        return nextExecutionSemester.getState() == PeriodState.OPEN || nextExecutionSemester.getState() == PeriodState.NOT_OPEN && Authenticate.getUser() != null && hasPerson.and(isManager.or(isCoordinator)).test(Authenticate.getUser().getPerson());
    }

    private ExecutionSemester getExecutionSemester(String[] requestContext) {
        return requestContext.length > 2 ? (ExecutionSemester)FenixFramework.getDomainObject((String)requestContext[1]) : ExecutionSemester.readActualExecutionSemester();
    }
}

