/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class ScheduleEventBean
implements Comparable<ScheduleEventBean> {
    public static final String[] COLORS = new String[]{"#f44336", "#607d8b", "#9c27b0", "#673ab7", "#3f51b5", "#2196f3", "#03a9f4", "#00bcd4", "#009688", "#4caf50", "#6d7297"};
    private static final String COLOR_BLACK = "333";
    public final LocalizedString title;
    public final LocalizedString subtitle;
    public final LocalizedString description;
    public final DateTime begin;
    public final DateTime end;
    public final String id;
    public final String url;
    public final String color;
    public final String textColor;
    public final Collection<Space> spaces;
    public final String location;

    public ScheduleEventBean(LocalizedString title, LocalizedString subtitle, LocalizedString description, DateTime start, DateTime end, String id, String url, String color, String textColor, Collection<Space> spaces) {
        this.title = title;
        this.subtitle = subtitle;
        this.description = description;
        this.begin = start.toDateTimeISO();
        this.end = Optional.ofNullable(end).orElse(start).toDateTimeISO();
        this.id = Optional.ofNullable(id).orElse(UUID.randomUUID().toString());
        this.url = Optional.ofNullable(url).orElse("#");
        this.color = Optional.ofNullable(color).orElse(COLORS[0]);
        this.textColor = Optional.ofNullable(color).orElse(COLOR_BLACK);
        this.spaces = Optional.ofNullable(spaces).orElse((Collection<Space>)ImmutableSet.of());
        this.location = this.secureSpaceNames(spaces);
    }

    public ScheduleEventBean(String title, String subtitle, String description, DateTime start, DateTime end, String id, String url, String color, String textColor, Collection<Space> spaces) {
        this(new LocalizedString().with(I18N.getLocale(), title), new LocalizedString().with(I18N.getLocale(), subtitle), new LocalizedString().with(I18N.getLocale(), description), start, end, id, url, color, textColor, spaces);
    }

    private String secureSpaceNames(Collection<Space> spaces) {
        try {
            return spaces.stream().map(Space::getPresentationName).collect(Collectors.joining(";"));
        }
        catch (Exception e) {
            return new String();
        }
    }

    @Override
    public int compareTo(ScheduleEventBean o) {
        return this.begin.compareTo((ReadableInstant)o.begin);
    }

    public static Collection<ScheduleEventBean> forExecutionCourse(ExecutionCourse executionCourse, Interval interval) {
        ArrayList events = Lists.newArrayList();
        for (CourseLoad courseLoad : executionCourse.getCourseLoadsSet()) {
            for (Shift shift : courseLoad.getShiftsSet()) {
                for (Lesson lesson : shift.getAssociatedLessonsSet()) {
                    for (Interval lessonInterval : lesson.getAllLessonIntervals()) {
                        if (!interval.contains((ReadableInterval)lessonInterval)) continue;
                        events.add(ScheduleEventBean.scheduleEvent(shift, lesson, lessonInterval));
                    }
                }
            }
        }
        return events;
    }

    public String getTitle() {
        return Optional.ofNullable(this.title.getContent()).orElse("") + "\n" + Optional.ofNullable(this.subtitle.getContent()).orElse("");
    }

    public String getDescription() {
        return Optional.ofNullable(this.description.getContent()).orElse("") + "\n" + Optional.ofNullable(this.location).orElse("");
    }

    private static ScheduleEventBean scheduleEvent(Shift shift, Lesson lesson, Interval interval) {
        String shiftAcronym = shift.getShiftTypesCodePrettyPrint();
        String url = "#";
        String roomName = lesson.getSala() != null ? lesson.getSala().getName() : null;
        String shiftTypesPrettyPrint = shift.getShiftTypesPrettyPrint();
        String color = COLORS[((ShiftType)shift.getSortedTypes().stream().findFirst().get()).ordinal()];
        HashSet spaces = Sets.newHashSet((Object[])new Space[]{lesson.getSala()});
        return new ScheduleEventBean(shiftAcronym, roomName, shiftTypesPrettyPrint, interval.getStart(), interval.getEnd(), null, url, color, null, (Collection<Space>)spaces);
    }
}

