/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.ui;

import java.net.URISyntaxException;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.exceptions.CmsDomainException;
import org.fenixedu.learning.domain.degree.DegreeSiteListener;
import org.fenixedu.learning.domain.executionCourse.ExecutionCourseListener;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/learning/sites/"})
public class SpecificSitesAdmin {
    @RequestMapping(value={"/degree"}, method={RequestMethod.POST})
    public RedirectView getDegreeSite(@RequestParam(value="dsigla") String degreeSigla) throws URISyntaxException {
        Degree degree = Degree.readBySigla((String)degreeSigla);
        if (degree == null) {
            throw CmsDomainException.notFound();
        }
        if (degree.getSite() != null) {
            Site site = degree.getSite();
            return new RedirectView(site.getEditUrl());
        }
        Site site = DegreeSiteListener.create(degree);
        return new RedirectView(site.getEditUrl());
    }

    @RequestMapping(value={"/executionCourse"}, method={RequestMethod.POST})
    public RedirectView getExecutionCourseSite(@RequestParam(value="ecsigla") String executionCourseSigla) throws URISyntaxException {
        ExecutionCourse ec = ExecutionCourse.readLastBySigla((String)executionCourseSigla);
        if (ec == null) {
            throw CmsDomainException.notFound();
        }
        if (ec.getSite() != null) {
            Site site = ec.getSite();
            return new RedirectView(site.getEditUrl());
        }
        Site site = ExecutionCourseListener.create(ec);
        return new RedirectView(site.getEditUrl());
    }
}

