/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse.components;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.executionCourse.components.BaseExecutionCourseComponent;

@ComponentType(name="LessonsPlanning", description="Lessons planing for an Execution Course")
public class LessonPlanComponent
extends BaseExecutionCourseComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        ExecutionCourse executionCourse = page.getSite().getExecutionCourse();
        if (executionCourse.getLessonPlanningAvailable()) {
            HashMap lessonPlanningsMap = Maps.newHashMap();
            for (ShiftType shiftType : executionCourse.getShiftTypes()) {
                List lessonPlanningsOrderedByOrder = executionCourse.getLessonPlanningsOrderedByOrder(shiftType);
                if (lessonPlanningsOrderedByOrder.isEmpty()) continue;
                lessonPlanningsMap.put(shiftType, lessonPlanningsOrderedByOrder);
            }
            globalContext.put((Object)"lessonPlanningsMap", (Object)lessonPlanningsMap);
        }
    }
}

