/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse.components;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.Project_Base;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.executionCourse.components.BaseExecutionCourseComponent;

@ComponentType(name="Evaluations", description="Evaluations for an Execution Course")
public class EvaluationsComponent
extends BaseExecutionCourseComponent {
    private static final Comparator<Evaluation> EVALUATION_COMPARATOR = Comparator.comparing(Evaluation::getEvaluationDate);
    private static final Comparator<Project> PROJECT_COMPARATOR = Comparator.comparing(Project_Base::getProjectBeginDateTime).thenComparing(Project_Base::getProjectEndDateTime).thenComparing(Project_Base::getName);

    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        ExecutionCourse executionCourse = page.getSite().getExecutionCourse();
        globalContext.put((Object)"comment", (Object)executionCourse.getComment());
        globalContext.put((Object)"adHocEvaluations", (Object)executionCourse.getOrderedAssociatedAdHocEvaluations());
        globalContext.put((Object)"projects", executionCourse.getAssociatedProjects().stream().sorted(PROJECT_COMPARATOR).collect(Collectors.toList()));
        globalContext.put((Object)"publishedExams", this.publishedExams(executionCourse));
        globalContext.put((Object)"writtenTests", executionCourse.getAssociatedWrittenTests().stream().sorted(EVALUATION_COMPARATOR).collect(Collectors.toList()));
    }

    private List<Exam> publishedExams(ExecutionCourse executionCourse) {
        return executionCourse.getAssociatedExams().stream().filter(Exam::isExamsMapPublished).sorted(EVALUATION_COMPARATOR).collect(Collectors.toList());
    }
}

