/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse.components;

import java.util.Set;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.learning.domain.executionCourse.components.BaseExecutionCourseComponent;

@ComponentType(name="EvaluationMethods", description="Evaluation Methods for an Execution Course")
public class EvaluationMethodsComponent
extends BaseExecutionCourseComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        ExecutionCourse executionCourse = page.getSite().getExecutionCourse();
        LocalizedString evaluationMethod = this.getEvaluationMethod(executionCourse);
        globalContext.put((Object)"evaluationMethod", (Object)executionCourse.getEvaluationMethod());
        globalContext.put((Object)"evaluationMethodText", (Object)evaluationMethod.getContent());
        globalContext.put((Object)"evaluationMethodLocalizedString", (Object)evaluationMethod);
    }

    private LocalizedString getEvaluationMethod(ExecutionCourse executionCourse) {
        if (executionCourse.getEvaluationMethod() != null) {
            return executionCourse.getEvaluationMethod().getEvaluationElements();
        }
        Set competences = executionCourse.getCompetenceCourses();
        CompetenceCourse competence = competences.isEmpty() ? null : (CompetenceCourse)competences.iterator().next();
        return competence == null ? new LocalizedString() : competence.getLocalizedEvaluationMethod(executionCourse.getExecutionPeriod());
    }
}

