/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.executionCourse;

import com.google.common.collect.ComparisonChain;
import java.util.Calendar;
import java.util.TimeZone;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.dto.InfoLessonInstanceAggregation;
import org.joda.time.format.ISODateTimeFormat;

public class LessonBean
implements Comparable<LessonBean> {
    private static final String[] COLORS = new String[]{"CCAE87", "997649", "FFE8E0", "BECC87", "#FF9999", "#FFCC99", "#FFFF99", "#CCFF99", "#99FF99", "#99FF88"};
    private final InfoLessonInstanceAggregation info;

    public LessonBean(InfoLessonInstanceAggregation info) {
        this.info = info;
    }

    public String getEnd() {
        return this.isoDate(this.getWeekDay(), this.getEndHour(), this.getEndMinutes(), 0);
    }

    public String getStart() {
        return this.isoDate(this.getWeekDay(), this.getBeginHour(), this.getBeginMinutes(), 0);
    }

    private String isoDate(int dayOfWeek, int hour, int minutes, int seconds) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(7, dayOfWeek);
        calendar.set(11, hour);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        return ISODateTimeFormat.dateTime().print(calendar.getTime().getTime());
    }

    public String getId() {
        return this.info.getExternalId();
    }

    public int getWeekDay() {
        return this.info.getDiaSemana().getDiaSemana();
    }

    public int getBeginHour() {
        return this.info.getBeginHourMinuteSecond().getHour();
    }

    public int getBeginMinutes() {
        return this.info.getBeginHourMinuteSecond().getMinuteOfHour();
    }

    public int getEndHour() {
        return this.info.getEndHourMinuteSecond().getHour();
    }

    public int getEndMinutes() {
        return this.info.getEndHourMinuteSecond().getMinuteOfHour();
    }

    public String getShiftType() {
        return this.info.getShift().getShiftTypesPrettyPrint();
    }

    public String getShiftTypeCode() {
        return this.info.getShift().getShiftTypesCodePrettyPrint();
    }

    public String getShiftSpace() {
        return this.info.getAllocatableSpace().getName();
    }

    public String getShiftWeeks() {
        return this.info.prettyPrintWeeks();
    }

    public InfoLessonInstanceAggregation getInfo() {
        return this.info;
    }

    public String getTextColor() {
        return "#333";
    }

    public String getSpaceUrl() {
        return "#";
    }

    public String getColor() {
        int id = ((ShiftType)this.info.getShift().getTypes().stream().findFirst().get()).ordinal();
        return COLORS[id % COLORS.length];
    }

    @Override
    public int compareTo(LessonBean o) {
        return ComparisonChain.start().compare(this.getWeekDay(), o.getWeekDay()).compare(this.getBeginHour(), o.getBeginHour()).compare(this.getBeginMinutes(), o.getBeginMinutes()).result();
    }
}

