/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.degree.components;

import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.CMSComponent;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.exceptions.ResourceNotFoundException;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.DissertationsUtils;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

@ComponentType(name="thesis", description="Provides information for a specific thesis")
public class ThesisComponent
implements CMSComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        String[] ctx = globalContext.getRequestContext();
        if (ctx.length < 2) {
            throw new ResourceNotFoundException();
        }
        Thesis thesis = (Thesis)FenixFramework.getDomainObject((String)ctx[1]);
        if (!FenixFramework.isDomainObjectValid((DomainObject)thesis)) {
            throw new ResourceNotFoundException();
        }
        globalContext.put((Object)"thesis", (Object)thesis);
        globalContext.put((Object)"states", DissertationsUtils.getThesisStateMapping());
        globalContext.put((Object)"isAccessible", (Object)this.isAccessible(thesis));
    }

    private boolean isAccessible(Thesis thesis) {
        return thesis != null && thesis.getDissertation() != null && thesis.getDissertation().isAccessible(Authenticate.getUser());
    }
}

