/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.degree.components;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.DegreeCurricularPlanServices;
import org.fenixedu.learning.domain.degree.components.DegreeSiteComponent;

@ComponentType(name="Degree execution courses", description="execution courses for a degree")
public class DegreeExecutionCoursesComponent
extends DegreeSiteComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        Degree degree = this.degree(page);
        globalContext.put((Object)"executionCoursesBySemesterAndCurricularYear", this.executionCourses(degree));
        globalContext.put((Object)"executionYears", DegreeCurricularPlanServices.getDegreeCurricularPlansExecutionYears(degree).stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList()));
    }

    public SortedMap<ExecutionSemester, SortedMap<Integer, SortedSet<ExecutionCourse>>> executionCourses(Degree degree) {
        TreeMap result = Maps.newTreeMap((Comparator)ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR);
        ExecutionSemester current = ExecutionSemester.readActualExecutionSemester();
        ExecutionSemester previous = current.getPreviousExecutionPeriod();
        ExecutionSemester next = current.getNextExecutionPeriod();
        boolean hasNext = next.getExecutionYear().isCurrent() && next != null && next.getState().equals((Object)PeriodState.OPEN);
        ExecutionSemester selected = hasNext ? next : previous;
        result.put(selected, this.executionCourses(degree, selected));
        result.put(current, this.executionCourses(degree, current));
        return result;
    }

    public SortedMap<Integer, SortedSet<ExecutionCourse>> executionCourses(Degree degree, ExecutionSemester executionSemester) {
        TreeMap<Integer, SortedSet<ExecutionCourse>> courses = new TreeMap<Integer, SortedSet<ExecutionCourse>>();
        if (executionSemester != null) {
            DegreeCurricularPlanServices.getDegreeCurricularPlansForYear(degree, Optional.of(executionSemester.getExecutionYear())).forEach(plan -> this.addExecutionCourses((CourseGroup)plan.getRoot(), courses, executionSemester));
        }
        return courses;
    }

    private void addExecutionCourses(CourseGroup courseGroup, Map<Integer, SortedSet<ExecutionCourse>> courses, ExecutionSemester ... executionPeriods) {
        for (Context context : courseGroup.getChildContextsSet()) {
            for (ExecutionSemester executionSemester : executionPeriods) {
                if (!context.isValid(executionSemester)) continue;
                DegreeModule degreeModule = context.getChildDegreeModule();
                if (degreeModule.isLeaf()) {
                    CurricularCourse curricularCourse = (CurricularCourse)degreeModule;
                    for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                        if (executionCourse.getExecutionPeriod() != executionSemester) continue;
                        courses.computeIfAbsent(context.getCurricularYear(), i -> new TreeSet(ExecutionCourse.EXECUTION_COURSE_NAME_COMPARATOR)).add(executionCourse);
                    }
                    continue;
                }
                CourseGroup childCourseGroup = (CourseGroup)degreeModule;
                this.addExecutionCourses(childCourseGroup, courses, executionPeriods);
            }
        }
    }
}

