/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.degree.components;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.component.ComponentType;
import org.fenixedu.cms.rendering.TemplateContext;
import org.fenixedu.learning.domain.DissertationsUtils;
import org.fenixedu.learning.domain.degree.components.DegreeSiteComponent;
import org.fenixedu.learning.domain.degree.components.ThesisComponent;

@ComponentType(name="degreeDissertations", description="Dissertations information for a Degree")
public class DegreeDissertationsComponent
extends DegreeSiteComponent {
    public void handle(Page page, TemplateContext componentContext, TemplateContext globalContext) {
        ImmutableSet degrees = ImmutableSet.of((Object)this.degree(page));
        SortedMap<ExecutionYear, List<Thesis>> allThesesByYear = DissertationsUtils.allThesesByYear((Collection<Degree>)degrees);
        globalContext.put((Object)"unit", (Object)this.degree(page).getUnit());
        globalContext.put((Object)"thesesByYear", allThesesByYear);
        globalContext.put((Object)"years", allThesesByYear.keySet().stream().sorted(ExecutionYear.COMPARATOR_BY_YEAR));
        globalContext.put((Object)"degrees", degrees.stream().sorted(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID));
        globalContext.put((Object)"states", DissertationsUtils.getThesisStateMapping());
        Page thesisPage = DegreeSiteComponent.pageForComponent(page.getSite(), ThesisComponent.class).get();
        globalContext.put((Object)"dissertationUrl", (Object)thesisPage.getAddress());
    }
}

