/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain.degree;

import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.cms.domain.Menu;
import org.fenixedu.cms.domain.Page;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.cms.domain.component.Component;
import org.fenixedu.cms.domain.component.ListCategoryPosts;
import org.fenixedu.cms.domain.component.ViewPost;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.learning.domain.degree.DegreeSiteBuilder_Base;
import org.fenixedu.learning.domain.degree.components.ClassScheduleComponent;
import org.fenixedu.learning.domain.degree.components.CurricularCourseComponent;
import org.fenixedu.learning.domain.degree.components.DegreeClassesComponent;
import org.fenixedu.learning.domain.degree.components.DegreeCurricularPlansComponent;
import org.fenixedu.learning.domain.degree.components.DegreeCurriculumComponent;
import org.fenixedu.learning.domain.degree.components.DegreeDissertationsComponent;
import org.fenixedu.learning.domain.degree.components.DegreeEvaluations;
import org.fenixedu.learning.domain.degree.components.DegreeExecutionCoursesComponent;
import org.fenixedu.learning.domain.degree.components.DescriptionComponent;
import org.fenixedu.learning.domain.degree.components.LatestAnnouncementsComponent;
import org.fenixedu.learning.domain.degree.components.ThesisComponent;

public class DegreeSiteBuilder
extends DegreeSiteBuilder_Base {
    private static final String BUNDLE = "resources.FenixEduLearningResources";
    private static final LocalizedString MENU_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.menu", (String[])new String[0]);
    private static final LocalizedString ANNOUNCEMENTS_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.announcements", (String[])new String[0]);
    private static final LocalizedString VIEW_POST_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"label.viewPost", (String[])new String[0]);
    private static final LocalizedString TITLE_CURRICULUM = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"degree.curriculum.title", (String[])new String[0]);
    private static final LocalizedString DESCRIPTION_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"degree.description.title", (String[])new String[0]);
    private static final LocalizedString REQUIREMENTS_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"degree.requirements.title", (String[])new String[0]);
    private static final LocalizedString PROFESSIONAL_STATUS_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"degree.pstatus.title", (String[])new String[0]);
    private static final LocalizedString CURRICULAR_PLAN_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"degree.cplan.title", (String[])new String[0]);
    private static final LocalizedString EXECUTION_COURSE_SITES_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"degree.ecsites.title", (String[])new String[0]);
    private static final LocalizedString TITLE_CLASS = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"degree.class.title", (String[])new String[0]);
    private static final LocalizedString CLASSES_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"degree.classes.title", (String[])new String[0]);
    private static final LocalizedString EVALUATIONS_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"degree.evaluations.title", (String[])new String[0]);
    private static final LocalizedString THESES_TITLE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"degree.theses.title", (String[])new String[0]);
    private static final LocalizedString TITLE_THESIS = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"department.thesis", (String[])new String[0]);
    private static final LocalizedString TITLE_COURSE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"department.course", (String[])new String[0]);
    private static final LocalizedString TITLE_CURRICULAR_COURSE = BundleUtil.getLocalizedString((String)"resources.FenixEduLearningResources", (String)"degree.curricularCourse.title", (String[])new String[0]);

    private DegreeSiteBuilder() {
        this.setSlug(DegreeSiteBuilder.class.getSimpleName());
        Bennu.getInstance().getSiteBuildersSet().add(this);
    }

    public static DegreeSiteBuilder getInstance() {
        return Bennu.getInstance().getSiteBuildersSet().stream().filter(siteBuilder -> siteBuilder instanceof DegreeSiteBuilder).map(siteBuilder -> (DegreeSiteBuilder)((Object)siteBuilder)).findFirst().orElseGet(() -> new DegreeSiteBuilder());
    }

    public Site create(LocalizedString name) {
        Site site = super.create(name, name);
        Menu menu = new Menu(site, site.getName());
        menu.setName(MENU_TITLE);
        menu.setPrivileged(true);
        menu.setOrder(Integer.valueOf(0));
        site.setSystemMenu(menu);
        User user = Authenticate.getUser();
        ListCategoryPosts announcementsComponent = new ListCategoryPosts(site.getOrCreateCategoryForSlug("announcement", ANNOUNCEMENTS_TITLE));
        Page initialPage = Page.create((Site)site, (Menu)menu, null, (LocalizedString)DESCRIPTION_TITLE, (boolean)true, (String)"degreeDescription", (User)user, (Component[])new Component[]{Component.forType(DescriptionComponent.class), Component.forType(LatestAnnouncementsComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)ANNOUNCEMENTS_TITLE, (boolean)true, (String)"category", (User)user, (Component[])new Component[]{announcementsComponent});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)TITLE_CURRICULUM, (boolean)true, (String)"degreeCurriculum", (User)user, (Component[])new Component[]{Component.forType(DegreeCurriculumComponent.class)});
        Page.create((Site)site, null, null, (LocalizedString)VIEW_POST_TITLE, (boolean)true, (String)"view", (User)user, (Component[])new Component[]{Component.forType(ViewPost.class)});
        Page.create((Site)site, null, null, (LocalizedString)TITLE_THESIS, (boolean)true, (String)"dissertation", (User)user, (Component[])new Component[]{Component.forType(ThesisComponent.class)});
        Page.create((Site)site, null, null, (LocalizedString)TITLE_CLASS, (boolean)true, (String)"calendarEvents", (User)user, (Component[])new Component[]{Component.forType(ClassScheduleComponent.class)});
        Page.create((Site)site, null, null, (LocalizedString)TITLE_CURRICULAR_COURSE, (boolean)true, (String)"curricularCourse", (User)user, (Component[])new Component[]{Component.forType(CurricularCourseComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)THESES_TITLE, (boolean)true, (String)"dissertations", (User)user, (Component[])new Component[]{Component.forType(DegreeDissertationsComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)REQUIREMENTS_TITLE, (boolean)true, (String)"accessRequirements", (User)user, (Component[])new Component[]{Component.forType(DescriptionComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)PROFESSIONAL_STATUS_TITLE, (boolean)true, (String)"professionalStatus", (User)user, (Component[])new Component[]{Component.forType(DescriptionComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)CURRICULAR_PLAN_TITLE, (boolean)true, (String)"curricularPlans", (User)user, (Component[])new Component[]{Component.forType(DegreeCurricularPlansComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)EXECUTION_COURSE_SITES_TITLE, (boolean)true, (String)"degreeExecutionCourses", (User)user, (Component[])new Component[]{Component.forType(DegreeExecutionCoursesComponent.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)EVALUATIONS_TITLE, (boolean)true, (String)"calendarEvents", (User)user, (Component[])new Component[]{Component.forType(DegreeEvaluations.class)});
        Page.create((Site)site, (Menu)menu, null, (LocalizedString)CLASSES_TITLE, (boolean)true, (String)"degreeClasses", (User)user, (Component[])new Component[]{Component.forType(DegreeClassesComponent.class)});
        site.setInitialPage(initialPage);
        return site;
    }
}

