/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.domain;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisState;

public class DissertationsUtils {
    private static Map<ThesisState, String> states;

    public static Map<ThesisState, String> getThesisStateMapping() {
        if (states == null) {
            states = Maps.newHashMap();
            states.put(ThesisState.EVALUATED, "success");
            states.put(ThesisState.CONFIRMED, "primary");
            states.put(ThesisState.DRAFT, "default");
            states.put(ThesisState.APPROVED, "info");
            states.put(ThesisState.REVISION, "warning");
            states.put(ThesisState.SUBMITTED, "primary");
        }
        return states;
    }

    public static SortedMap<ExecutionYear, List<Thesis>> allThesesByYear(Collection<Degree> degrees) {
        TreeMap thesesByYear = Maps.newTreeMap((Comparator)ExecutionYear.REVERSE_COMPARATOR_BY_YEAR);
        Stream<Map<ExecutionYear, List<Thesis>>> allTheses = degrees.stream().flatMap(degree -> degree.getThesisSet().stream().filter(thesis -> thesis.getEnrolment() != null));
        thesesByYear.putAll(allTheses.collect(Collectors.groupingBy(Thesis::getExecutionYear)));
        return thesesByYear;
    }
}

