/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.learning.api;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.fenixedu.academic.domain.Coordinator_Base;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.util.EvaluationType;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.cms.domain.Site;
import org.fenixedu.learning.domain.DegreeCurricularPlanServices;
import org.fenixedu.learning.domain.ScheduleEventBean;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;

@Path(value="/fenixedu-learning/events")
public class EventsResource {
    private static Collection<ScheduleEventBean> projectEvents(Project project, ExecutionCourse executionCourse, Interval interval) {
        DateTime projectStart = project.getProjectBeginDateTime();
        DateTime projectEnd = project.getProjectEndDateTime();
        HashSet<ScheduleEventBean> events = new HashSet<ScheduleEventBean>();
        if (interval.contains((ReadableInstant)projectStart)) {
            events.add(new ScheduleEventBean(executionCourse.getPrettyAcronym(), project.getEvaluationType().toString(), project.getPresentationName(), projectStart, projectStart.plusHours(1), null, executionCourse.getSiteUrl(), EventsResource.colorForType(project.getEvaluationType()), null, null));
        }
        if (interval.contains((ReadableInstant)projectEnd)) {
            events.add(new ScheduleEventBean(executionCourse.getPrettyAcronym(), project.getEvaluationType().toString(), project.getPresentationName(), projectEnd.minusHours(1), projectEnd, null, executionCourse.getSiteUrl(), EventsResource.colorForType(project.getEvaluationType()), null, null));
        }
        return events;
    }

    private static String colorForType(EvaluationType type) {
        return ScheduleEventBean.COLORS[type.getType() % ScheduleEventBean.COLORS.length];
    }

    @GET
    @Path(value="/executionCourse/{course}")
    @Produces(value={"application/json; charset=utf-8"})
    public String executionCourseEvents(@PathParam(value="course") ExecutionCourse course, @QueryParam(value="start") String start, @QueryParam(value="end") String end) {
        return this.toJson(this.hasPermissionToViewSchedule(course) ? ScheduleEventBean.forExecutionCourse(course, this.getInterval(start, end)) : Collections.emptySet()).toString();
    }

    @GET
    @Path(value="/executionCourse/{course}/nearestEvent")
    @Produces(value={"application/json; charset=utf-8"})
    public String nearestExecutionCourseEvent(@PathParam(value="course") ExecutionCourse course) {
        LocalDate date = LocalDate.now();
        if (this.hasPermissionToViewSchedule(course)) {
            date = this.nearestEventDate(ScheduleEventBean.forExecutionCourse(course, course.getAcademicInterval().toInterval()));
        }
        return this.toJson(date).toString();
    }

    @GET
    @Path(value="/degree/evaluations/{degree}")
    @Produces(value={"application/json; charset=utf-8"})
    public String degreeEvaluationsEvents(@PathParam(value="degree") Degree degree, @QueryParam(value="start") String start, @QueryParam(value="end") String end) {
        return this.toJson(this.allPublicEvaluations(degree, this.getInterval(start, end))).toString();
    }

    @GET
    @Path(value="/degree/class/{schoolClass}/nearestEvent")
    @Produces(value={"application/json; charset=utf-8"})
    public String nearestClassScheduleEvent(@PathParam(value="schoolClass") SchoolClass schoolClass) {
        return this.toJson(this.nearestEventDate(this.getEvents(schoolClass, schoolClass.getAcademicInterval().toInterval()))).toString();
    }

    @GET
    @Path(value="/degree/class/{schoolClass}")
    @Produces(value={"application/json; charset=utf-8"})
    public String classScheduleEvents(@PathParam(value="schoolClass") SchoolClass schoolClass, @QueryParam(value="start") String start, @QueryParam(value="end") String end) {
        return this.toJson(this.getEvents(schoolClass, this.getInterval(start, end))).toString();
    }

    @GET
    @Path(value="/degree/evaluations/{degree}/nearestEvent")
    @Produces(value={"application/json; charset=utf-8"})
    public String nearestEvaluationEvent(@PathParam(value="degree") Degree degree) {
        Optional<Interval> interval = DegreeCurricularPlanServices.getDegreeCurricularPlansExecutionYears(degree).stream().sorted(ExecutionYear.COMPARATOR_BY_YEAR.reversed()).map(year -> year.getAcademicInterval().toInterval()).findFirst();
        LocalDate date = interval.isPresent() ? this.nearestEventDate(this.allPublicEvaluations(degree, interval.get())) : LocalDate.now();
        return this.toJson(date).toString();
    }

    private Collection<ScheduleEventBean> getEvents(SchoolClass schoolClass, Interval interval) {
        return schoolClass.getAssociatedShiftsSet().stream().flatMap(shift -> shift.getAssociatedLessonsSet().stream()).flatMap(lesson -> this.lessonEvents((Lesson)lesson, interval)).collect(Collectors.toList());
    }

    private Stream<ScheduleEventBean> lessonEvents(Lesson lesson, Interval interval) {
        return Stream.concat(this.lessonsWithoutInstances(lesson, interval), this.lessonWithInstances(lesson, interval));
    }

    private Stream<ScheduleEventBean> lessonsWithoutInstances(Lesson lesson, Interval interval) {
        return lesson.getAllLessonIntervalsWithoutInstanceDates().stream().filter(i -> interval.contains((ReadableInterval)i) || i.contains((ReadableInterval)interval)).map(i -> this.createEventBean(lesson, (Interval)i));
    }

    private Stream<ScheduleEventBean> lessonWithInstances(Lesson lesson, Interval interval) {
        return lesson.getLessonInstancesSet().stream().filter(instance -> interval.contains((ReadableInterval)instance.getInterval())).map(instance -> this.createEventBean(lesson, instance.getInterval()));
    }

    private ScheduleEventBean createEventBean(Lesson lesson, Interval interval) {
        Optional<Site> site = Optional.ofNullable(lesson.getExecutionCourse().getSite());
        String url = site.isPresent() ? site.get().getFullUrl() : "#";
        String executionCourseAcronym = lesson.getShift().getExecutionCourse().getPrettyAcronym();
        String shiftTypeAcronym = lesson.getShift().getShiftTypesCodePrettyPrint();
        String executionCourseName = lesson.getShift().getExecutionCourse().getNameI18N().getContent();
        String shifType = lesson.getShift().getShiftTypesPrettyPrint();
        HashSet location = lesson.getLessonSpaceOccupation() != null ? lesson.getLessonSpaceOccupation().getSpaces() : Sets.newHashSet();
        String description = executionCourseName + "( " + shifType + " )";
        return new ScheduleEventBean(executionCourseAcronym, shiftTypeAcronym, description, interval.getStart(), interval.getEnd(), null, url, null, null, (Collection<Space>)location);
    }

    private Interval getInterval(String start, String end) {
        DateTime endDate;
        DateTime beginDate;
        if (Strings.isNullOrEmpty((String)start)) {
            DateTime now = new DateTime();
            beginDate = now.withDayOfWeek(1).withHourOfDay(0).withMinuteOfHour(0);
            endDate = now.withDayOfWeek(7).plusDays(1).withHourOfDay(0).withMinuteOfHour(0);
        } else {
            beginDate = ISODateTimeFormat.date().parseLocalDate(start).toDateTimeAtStartOfDay();
            endDate = ISODateTimeFormat.date().parseLocalDate(end).plusDays(1).toDateTimeAtStartOfDay().minusMillis(1);
        }
        return new Interval((ReadableInstant)beginDate, (ReadableInstant)endDate);
    }

    private JsonArray toJson(Iterable<ScheduleEventBean> events) {
        JsonArray array = new JsonArray();
        events.forEach(event -> {
            JsonObject ev = new JsonObject();
            ev.addProperty("id", event.id);
            ev.addProperty("start", event.begin.toDateTimeISO().toString());
            ev.addProperty("end", event.end.toDateTimeISO().toString());
            ev.addProperty("url", event.url);
            ev.addProperty("title", event.getTitle());
            ev.addProperty("description", event.getDescription());
            ev.addProperty("color", event.color);
            array.add((JsonElement)ev);
        });
        return array;
    }

    private Collection<ScheduleEventBean> allPublicEvaluations(Degree degree, Interval interval) {
        HashSet<ScheduleEventBean> allEvaluations = new HashSet<ScheduleEventBean>(this.writtenEvaluations(degree, interval));
        allEvaluations.addAll(this.projects(degree, interval));
        return allEvaluations;
    }

    private Collection<ScheduleEventBean> writtenEvaluations(Degree degree, Interval interval) {
        HashSet<ScheduleEventBean> events = new HashSet<ScheduleEventBean>();
        this.allExecutionCourses(degree).forEach(executionCourse -> executionCourse.getAssociatedWrittenEvaluations().stream().filter(writtenEval -> writtenEval.getBeginningDateTime() != null && interval.contains((ReadableInstant)writtenEval.getBeginningDateTime())).forEach(writtenEval -> events.add(this.createEventBean((ExecutionCourse)executionCourse, (WrittenEvaluation)writtenEval))));
        return events;
    }

    private ScheduleEventBean createEventBean(ExecutionCourse executionCourse, WrittenEvaluation evaluation) {
        return new ScheduleEventBean(executionCourse.getPrettyAcronym(), evaluation.getEvaluationType().toString(), executionCourse.getName(), evaluation.getBeginningDateTime(), evaluation.getEndDateTime(), null, executionCourse.getSiteUrl(), EventsResource.colorForType(evaluation.getEvaluationType()), null, null);
    }

    private Collection<ScheduleEventBean> projects(Degree degree, Interval interval) {
        HashSet projects = Sets.newHashSet();
        this.allExecutionCourses(degree).forEach(executionCourse -> {
            for (Project project : executionCourse.getAssociatedProjects()) {
                projects.addAll(EventsResource.projectEvents(project, executionCourse, interval));
            }
        });
        return projects;
    }

    private Stream<ExecutionCourse> allExecutionCourses(Degree degree) {
        return degree.getDegreeCurricularPlansSet().stream().flatMap(curricularPlan -> curricularPlan.getCurricularCoursesSet().stream()).flatMap(curricularCourse -> curricularCourse.getAssociatedExecutionCoursesSet().stream());
    }

    private boolean hasPermissionToViewSchedule(ExecutionCourse executionCourse) {
        boolean isOpenPeriod = !executionCourse.getExecutionPeriod().isNotOpen();
        boolean isLogged = Authenticate.isLogged();
        boolean isAllocationManager = isLogged && Group.dynamic((String)"resourceAllocationManager").isMember(Authenticate.getUser());
        boolean isCoordinator = executionCourse.getDegreesSortedByDegreeName().stream().flatMap(degree -> degree.getCurrentCoordinators().stream()).map(Coordinator_Base::getPerson).filter(coordinator -> coordinator.equals((Object)AccessControl.getPerson())).findFirst().isPresent();
        return isOpenPeriod || isLogged && (isAllocationManager || isCoordinator);
    }

    private JsonElement toJson(LocalDate localDate) {
        if (localDate == null) {
            return new JsonPrimitive(ISODateTimeFormat.date().print((ReadablePartial)LocalDate.now()));
        }
        return new JsonPrimitive(ISODateTimeFormat.date().print((ReadablePartial)localDate));
    }

    private LocalDate nearestEventDate(Collection<ScheduleEventBean> events) {
        LocalDate now = LocalDate.now();
        LocalDate result = events.stream().map(e -> e.begin).map(DateTime::toLocalDate).collect(Collectors.toCollection(TreeSet::new)).lower(now);
        return Optional.ofNullable(result).orElse(now);
    }
}

