/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet.styles;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.fenixedu.commons.spreadsheet.styles.CellStyle;

public class FontColor
extends CellStyle {
    private final HSSFColor color;

    public FontColor(HSSFColor color) {
        this.color = color;
    }

    @Override
    protected void appendToStyle(HSSFWorkbook book, HSSFCellStyle style, HSSFFont font) {
        font.setColor(this.color.getIndex());
    }

    @Override
    public HSSFCellStyle getStyle(HSSFWorkbook book) {
        HSSFCellStyle style = book.createCellStyle();
        HSSFFont font = book.createFont();
        this.appendToStyle(book, style, font);
        style.setFont(font);
        return style;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FontColor) {
            FontColor fontColor = (FontColor)obj;
            return this.color.equals((Object)fontColor.color);
        }
        return false;
    }

    public int hashCode() {
        return this.color.hashCode();
    }
}

