/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellReference;
import org.fenixedu.commons.spreadsheet.ExcelStyle;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.MutablePeriod;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class StyledExcelSpreadsheet {
    private static final String EMPTY_STRING = "";
    private final HSSFWorkbook workbook = new HSSFWorkbook();
    private HSSFSheet sheet;
    private final ExcelStyle excelStyle = new ExcelStyle(this.workbook);
    private final boolean wrapText;
    private static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
    private static final DateTimeFormatter dateTimeFormat = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm");

    public StyledExcelSpreadsheet() {
        this.wrapText = true;
    }

    public StyledExcelSpreadsheet(String sheetName) {
        this.sheet = this.workbook.createSheet(sheetName);
        this.sheet.setGridsPrinted(false);
        this.wrapText = true;
    }

    public StyledExcelSpreadsheet(String sheetName, boolean wrapText) {
        this.sheet = this.workbook.createSheet(sheetName);
        this.sheet.setGridsPrinted(false);
        this.wrapText = wrapText;
    }

    public StyledExcelSpreadsheet(String sheetName, int defaultColumnWith) {
        this.sheet = this.workbook.createSheet(sheetName);
        this.sheet.setDefaultColumnWidth(defaultColumnWith);
        this.sheet.setGridsPrinted(false);
        this.wrapText = true;
    }

    public ExcelStyle getExcelStyle() {
        return this.excelStyle;
    }

    public HSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    public HSSFSheet getSheet(String sheetName) {
        this.sheet = this.workbook.getSheet(sheetName);
        if (this.sheet == null) {
            this.sheet = this.workbook.createSheet(sheetName);
        }
        return this.sheet;
    }

    public boolean hasSheet(String sheetName) {
        return this.workbook.getSheet(sheetName) != null;
    }

    public void addHeader(String value) {
        HSSFRow currentRow = this.getRow();
        HSSFCell cell = currentRow.createCell(this.getNextWritableCell());
        cell.setCellValue(value);
        cell.setCellStyle(this.excelStyle.getHeaderStyle());
    }

    public void addHeader(int rowNumber, int columnNumber, String value) {
        HSSFRow currentRow = this.getRow(rowNumber);
        HSSFCell cell = currentRow.createCell(columnNumber);
        cell.setCellValue(value);
        cell.setCellStyle(this.excelStyle.getHeaderStyle());
    }

    public void addHeader(int columnNumber, String value) {
        HSSFRow currentRow = this.getRow();
        HSSFCell cell = currentRow.createCell(columnNumber);
        cell.setCellValue(value);
        cell.setCellStyle(this.excelStyle.getHeaderStyle());
    }

    public void addHeader(String value, int columnSize) {
        HSSFRow currentRow = this.getRow();
        int thisCellNumber = this.getNextWritableCell();
        HSSFCell cell = currentRow.createCell(thisCellNumber);
        cell.setCellValue(value);
        cell.setCellStyle(this.excelStyle.getHeaderStyle());
        this.sheet.setColumnWidth(thisCellNumber, (int)((short)columnSize));
    }

    public void addHeader(String value, HSSFCellStyle newStyle) {
        HSSFRow currentRow = this.getRow();
        HSSFCell cell = currentRow.createCell(this.getNextWritableCell());
        cell.setCellValue(value);
        cell.setCellStyle(newStyle);
    }

    public void addHeader(String value, HSSFCellStyle newStyle, int columnSize) {
        HSSFRow currentRow = this.getRow();
        int thisCellNumber = this.getNextWritableCell();
        HSSFCell cell = currentRow.createCell(thisCellNumber);
        cell.setCellValue(value);
        cell.setCellStyle(newStyle);
        this.sheet.setColumnWidth(thisCellNumber, (int)((short)columnSize));
    }

    public void addHeader(String value, int columnSize, int columnNumber) {
        HSSFRow currentRow = this.getRow();
        HSSFCell cell = currentRow.createCell(columnNumber);
        cell.setCellValue(value);
        cell.setCellStyle(this.excelStyle.getHeaderStyle());
        this.sheet.setColumnWidth(columnNumber, columnSize);
    }

    public void newHeaderRow() {
        int rowNumber = this.sheet.getLastRowNum();
        if (rowNumber != 0 || this.sheet.getRow(rowNumber) != null) {
            ++rowNumber;
        }
        this.sheet.createRow(rowNumber);
    }

    public void newRow() {
        int rowNumber = this.sheet.getLastRowNum();
        if (rowNumber != 0 || this.sheet.getRow(rowNumber) != null) {
            ++rowNumber;
        }
        HSSFRow currentRow = this.sheet.createRow(rowNumber);
        currentRow.setHeight((short)250);
    }

    public HSSFRow getRow() {
        return this.sheet.getRow(this.sheet.getLastRowNum());
    }

    public HSSFRow getRow(int rowNumber) {
        return this.sheet.getRow(rowNumber);
    }

    public int getNextWritableCell() {
        return this.getRow().getLastCellNum() == -1 ? 0 : (int)this.getRow().getLastCellNum();
    }

    public void addCell(Object value) {
        this.addCell(value, this.getDefaultExcelStyle(value), this.getNextWritableCell());
    }

    public void addCell(Object value, boolean wrap) {
        if (value == null) {
            value = EMPTY_STRING;
        }
        this.addCell(value, this.getDefaultExcelStyle(value), this.getNextWritableCell(), wrap);
    }

    public void addCell(Object value, HSSFCellStyle newStyle) {
        this.addCell(value, newStyle, this.getNextWritableCell());
    }

    public void addCell(Object value, int columnNumber) {
        this.addCell(value, this.getDefaultExcelStyle(value), columnNumber);
    }

    public void addCell(Object value, int columnNumber, boolean wrap) {
        this.addCell(value, this.getDefaultExcelStyle(value), columnNumber, wrap);
    }

    public void addCell(Object value, HSSFCellStyle newStyle, int columnNumber) {
        this.addCell(value, newStyle, columnNumber, this.wrapText);
    }

    private void addCell(Object value, HSSFCellStyle newStyle, int columnNumber, boolean wrap) {
        if (value == null) {
            value = EMPTY_STRING;
        }
        if (value instanceof String) {
            this.addCell((String)value, newStyle, columnNumber, wrap);
        } else if (value instanceof Integer) {
            this.addCell((Integer)value, newStyle, columnNumber, wrap);
        } else if (value instanceof Double) {
            this.addCell((Double)value, newStyle, columnNumber, wrap);
        } else {
            this.addCell(value.toString(), newStyle, columnNumber, wrap);
        }
    }

    private void addCell(String value, HSSFCellStyle newStyle, int columnNumber, boolean wrap) {
        HSSFRow currentRow = this.getRow();
        HSSFCell cell = currentRow.createCell(columnNumber);
        cell.setCellValue(value);
        cell.setCellStyle(this.getExcelStyle(newStyle, wrap));
    }

    private void addCell(Double value, HSSFCellStyle newStyle, int columnNumber, boolean wrap) {
        HSSFRow currentRow = this.getRow();
        HSSFCell cell = currentRow.createCell(columnNumber);
        cell.setCellValue(value.doubleValue());
        cell.setCellStyle(this.getExcelStyle(newStyle, wrap));
    }

    private void addCell(Integer value, HSSFCellStyle newStyle, int columnNumber, boolean wrap) {
        HSSFRow currentRow = this.getRow();
        HSSFCell cell = currentRow.createCell(columnNumber);
        cell.setCellValue((double)value.intValue());
        cell.setCellStyle(this.getExcelStyle(newStyle, wrap));
    }

    public void addDateTimeCell(DateTime value) {
        HSSFRow currentRow = this.getRow();
        HSSFCell cell = currentRow.createCell(this.getNextWritableCell());
        cell.setCellValue(dateTimeFormat.print((ReadableInstant)value));
        cell.setCellStyle(this.getExcelStyle(this.excelStyle.getValueStyle(), this.wrapText));
    }

    public void addDateCell(LocalDate value) {
        HSSFRow currentRow = this.getRow();
        HSSFCell cell = currentRow.createCell(this.getNextWritableCell());
        cell.setCellValue(dateFormat.print((ReadablePartial)value));
        cell.setCellStyle(this.getExcelStyle(this.excelStyle.getValueStyle(), this.wrapText));
    }

    public void addDuration(Duration value, int columnNumber) {
        HSSFRow currentRow = this.getRow();
        HSSFCell cell = currentRow.createCell(columnNumber);
        PeriodFormatter fmt = new PeriodFormatterBuilder().printZeroAlways().appendHours().appendSeparator(":").minimumPrintedDigits(2).appendMinutes().toFormatter();
        MutablePeriod valueFormatted = new MutablePeriod(value.getMillis(), PeriodType.time());
        if (value.toPeriod().getMinutes() < 0) {
            valueFormatted.setMinutes(-value.toPeriod().getMinutes());
            if (value.toPeriod().getHours() == 0) {
                fmt = new PeriodFormatterBuilder().printZeroAlways().appendLiteral("-").appendHours().appendSeparator(":").minimumPrintedDigits(2).appendMinutes().toFormatter();
            }
        }
        cell.setCellValue(fmt.print((ReadablePeriod)valueFormatted));
        cell.setCellStyle(this.getExcelStyle(this.excelStyle.getValueStyle(), this.wrapText));
    }

    public void addDuration(Duration value) {
        this.addDuration(value, this.getNextWritableCell());
    }

    public void sumColumn(int firstRow, int lastRow, int firstColumn, int lastColumn, HSSFCellStyle newStyle) {
        for (int col = firstColumn; col <= lastColumn; ++col) {
            CellReference cellRef1 = new CellReference(firstRow, col);
            CellReference cellRef2 = new CellReference(lastRow, col);
            HSSFRow currentRow = this.getRow();
            HSSFCell cell = currentRow.createCell(col);
            cell.setCellStyle(this.getExcelStyle(newStyle, this.wrapText));
            cell.setCellFormula("sum(" + cellRef1.formatAsString() + ":" + cellRef2.formatAsString() + ")");
        }
    }

    public void sumRows(int firstRow, int lastRow, int firstColumn, int lastColumn, int increment, HSSFCellStyle newStyle) {
        for (int row = firstRow; row <= lastRow; ++row) {
            CellReference[] refs = new CellReference[lastColumn - firstColumn / increment];
            int colIndex = 0;
            int col = firstColumn;
            while (col <= lastColumn) {
                refs[colIndex] = new CellReference(row, col);
                col += increment;
                ++colIndex;
            }
            HSSFRow currentRow = this.sheet.getRow(row);
            HSSFCell cell = currentRow.createCell(lastColumn);
            cell.setCellStyle(this.getExcelStyle(newStyle, this.wrapText));
            StringBuilder formula = new StringBuilder();
            for (CellReference ref : refs) {
                if (ref == null) continue;
                if (formula.length() != 0) {
                    formula.append(",");
                }
                formula.append(ref.formatAsString());
            }
            formula.append(")");
            cell.setCellFormula("sum(" + formula.toString());
        }
    }

    protected void setCellBorder(HSSFCell cell) {
        HSSFCellStyle style = this.workbook.createCellStyle();
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        cell.setCellStyle((CellStyle)style);
    }

    public void setRegionBorder(int firstRow, int lastRow, int firstColumn, int lastColumn) {
        for (int rowIndex = firstRow; rowIndex < lastRow; ++rowIndex) {
            for (int colIndex = firstColumn; colIndex <= lastColumn; ++colIndex) {
                HSSFRow row = this.sheet.getRow(rowIndex);
                HSSFCell cell = row.getCell(colIndex);
                if (cell == null) {
                    cell = row.createCell(colIndex);
                }
                this.setCellBorder(cell);
            }
        }
    }

    public int getMaxiumColumnNumber() {
        short result = -1;
        for (int row = 0; row <= this.sheet.getLastRowNum(); ++row) {
            result = this.sheet.getRow(row).getLastCellNum() > result ? this.sheet.getRow(row).getLastCellNum() : result;
        }
        return result;
    }

    public void setSheetOrientation() {
        HSSFPrintSetup ps = this.getSheet().getPrintSetup();
        ps.setLandscape(true);
        this.getSheet().setMargin((short)2, 0.1);
        this.getSheet().setMargin((short)3, 0.1);
        this.getSheet().setMargin((short)0, 0.1);
        this.getSheet().setMargin((short)1, 0.1);
    }

    private HSSFCellStyle getExcelStyle(HSSFCellStyle style, boolean wrap) {
        if (!wrap) {
            style.setWrapText(false);
        }
        return style;
    }

    private HSSFCellStyle getDefaultExcelStyle(Object value) {
        if (value instanceof Integer) {
            return this.getExcelStyle(this.getExcelStyle().getIntegerStyle(), this.wrapText);
        }
        if (value instanceof Double) {
            return this.getExcelStyle(this.getExcelStyle().getDoubleStyle(), this.wrapText);
        }
        return this.getExcelStyle(this.getExcelStyle().getValueStyle(), this.wrapText);
    }
}

