/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.commons.spreadsheet.AbstractSheetBuilder;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.converters.CellConverter;
import org.fenixedu.commons.spreadsheet.converters.LocalizedStringCellConverter;
import org.fenixedu.commons.spreadsheet.converters.excel.BigDecimalCellConverter;
import org.fenixedu.commons.spreadsheet.converters.excel.DateTimeCellConverter;
import org.fenixedu.commons.spreadsheet.converters.excel.IntegerCellConverter;
import org.fenixedu.commons.spreadsheet.converters.excel.LocalDateCellConverter;
import org.fenixedu.commons.spreadsheet.styles.CellAlignment;
import org.fenixedu.commons.spreadsheet.styles.CellBorder;
import org.fenixedu.commons.spreadsheet.styles.CellDateFormat;
import org.fenixedu.commons.spreadsheet.styles.CellFillForegroundColor;
import org.fenixedu.commons.spreadsheet.styles.CellFillPattern;
import org.fenixedu.commons.spreadsheet.styles.CellStyle;
import org.fenixedu.commons.spreadsheet.styles.CellVerticalAlignment;
import org.fenixedu.commons.spreadsheet.styles.CellWrapText;
import org.fenixedu.commons.spreadsheet.styles.ComposedCellStyle;
import org.fenixedu.commons.spreadsheet.styles.FontColor;
import org.fenixedu.commons.spreadsheet.styles.FontHeight;
import org.fenixedu.commons.spreadsheet.styles.FontWeight;
import org.fenixedu.commons.spreadsheet.styles.StyleCache;
import org.joda.time.DateTime;

class ExcelBuilder
extends AbstractSheetBuilder {
    static Map<Class<?>, CellConverter> BASE_CONVERTERS = new HashMap();
    private static Map<Class<?>, CellStyle> TYPE_STYLES;
    private static List<CellStyle> ROW_STYLES;
    private static CellStyle HEADER_STYLE;
    private CellStyle headerStyle;
    private final Map<Class<?>, CellStyle> typeStyles;
    private List<CellStyle> rowStyles;
    private StyleCache styleCache;
    int usefulAreaStart;
    int usefulAreaEnd;

    ExcelBuilder() {
        this.converters.putAll(BASE_CONVERTERS);
        this.headerStyle = HEADER_STYLE;
        this.typeStyles = new HashMap(TYPE_STYLES);
        this.rowStyles = new ArrayList<CellStyle>(ROW_STYLES);
    }

    protected void setHeaderStyle(CellStyle style) {
        this.headerStyle = style;
    }

    protected void appendHeaderStyle(CellStyle style) {
        ComposedCellStyle composed = new ComposedCellStyle();
        composed.merge(this.headerStyle);
        composed.merge(style);
        this.headerStyle = composed;
    }

    protected void addTypeStyle(Class<?> type, CellStyle style) {
        this.typeStyles.put(type, style);
    }

    protected void setRowStyle(CellStyle ... styles) {
        this.rowStyles = Arrays.asList(styles);
    }

    protected void setValue(HSSFWorkbook book, HSSFCell cell, Object value, short span) {
        ComposedCellStyle style = new ComposedCellStyle();
        if (!this.rowStyles.isEmpty()) {
            style.merge(this.rowStyles.get(cell.getRowIndex() % this.rowStyles.size()));
        }
        if (value != null && this.typeStyles.containsKey(value.getClass())) {
            style.merge(this.typeStyles.get(value.getClass()));
        }
        this.setValue(book, cell, value, span, this.styleCache.getStyle(style));
    }

    private void setValue(HSSFWorkbook book, HSSFCell cell, Object value, short span, HSSFCellStyle style) {
        if (value != null) {
            Object content = this.convert(value);
            if (content instanceof Boolean) {
                cell.setCellValue(((Boolean)content).booleanValue());
            } else if (content instanceof Double) {
                cell.setCellValue(((Double)content).doubleValue());
            } else if (content instanceof String) {
                cell.setCellValue((String)content);
            } else if (content instanceof GregorianCalendar) {
                cell.setCellValue((Calendar)((GregorianCalendar)content));
            } else if (content instanceof Date) {
                cell.setCellValue((Date)content);
            } else if (content instanceof RichTextString) {
                cell.setCellValue((RichTextString)content);
            } else {
                cell.setCellValue(content.toString());
            }
        } else {
            cell.setCellValue((String)null);
        }
        if (span > 1) {
            CellRangeAddress region = new CellRangeAddress(cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex() + span - 1);
            cell.getSheet().addMergedRegion(region);
        }
        cell.setCellStyle(style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(Map<String, SheetData<?>> sheets, OutputStream output) throws IOException {
        try {
            HSSFWorkbook book = new HSSFWorkbook();
            this.styleCache = new StyleCache(book);
            for (Map.Entry<String, SheetData<?>> entry : sheets.entrySet()) {
                HSSFRow row;
                HSSFSheet sheet = book.createSheet(entry.getKey());
                int rownum = 0;
                int colnum = 0;
                SheetData<?> data = entry.getValue();
                if (!data.headers.get(0).isEmpty()) {
                    for (List<SheetData.Cell> headerRow : data.headers) {
                        colnum = 0;
                        row = sheet.createRow(rownum++);
                        for (SheetData.Cell cell : headerRow) {
                            this.setValue(book, row.createCell(colnum++), cell.value, cell.span, this.styleCache.getStyle(this.headerStyle));
                            colnum = colnum + cell.span - 1;
                        }
                    }
                }
                this.usefulAreaStart = rownum;
                for (List<SheetData.Cell> line : data.matrix) {
                    colnum = 0;
                    row = sheet.createRow(rownum++);
                    for (SheetData.Cell cell : line) {
                        this.setValue(book, row.createCell(colnum++), cell.value, cell.span);
                        colnum = colnum + cell.span - 1;
                    }
                }
                this.usefulAreaEnd = rownum - 1;
                if (data.hasFooter()) {
                    colnum = 0;
                    HSSFRow row2 = sheet.createRow(rownum++);
                    for (SheetData.Cell cell : data.footer) {
                        this.setValue(book, row2.createCell(colnum++), cell.value, cell.span);
                        colnum = colnum + cell.span - 1;
                    }
                }
                for (int i = 0; i < sheet.getLastRowNum(); ++i) {
                    sheet.autoSizeColumn(i);
                }
            }
            book.write(output);
        }
        finally {
            output.flush();
            output.close();
        }
    }

    static {
        BASE_CONVERTERS.put(Integer.class, new IntegerCellConverter());
        BASE_CONVERTERS.put(DateTime.class, new DateTimeCellConverter());
        BASE_CONVERTERS.put(LocalDate.class, new LocalDateCellConverter());
        BASE_CONVERTERS.put(BigDecimal.class, new BigDecimalCellConverter());
        BASE_CONVERTERS.put(LocalizedString.class, new LocalizedStringCellConverter());
        TYPE_STYLES = new HashMap();
        TYPE_STYLES.put(DateTime.class, new CellDateFormat());
        TYPE_STYLES.put(LocalDate.class, new CellDateFormat("dd/MM/yyyy"));
        TYPE_STYLES.put(GregorianCalendar.class, new CellDateFormat());
        TYPE_STYLES.put(Date.class, new CellDateFormat());
        ROW_STYLES = Collections.emptyList();
        HEADER_STYLE = new ComposedCellStyle(){
            {
                this.merge(new FontColor(HSSFColor.HSSFColorPredefined.BLACK.getColor()));
                this.merge(new FontWeight(true));
                this.merge(new FontHeight(8));
                this.merge(new CellAlignment(HorizontalAlignment.CENTER.getCode()));
                this.merge(new CellFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getColor()));
                this.merge(new CellFillPattern(FillPatternType.SOLID_FOREGROUND.getCode()));
                this.merge(new CellBorder(BorderStyle.THIN.getCode()));
                this.merge(new CellVerticalAlignment(VerticalAlignment.CENTER.getCode()));
                this.merge(new CellWrapText(true));
            }
        };
    }
}

