/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet.styles;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.fenixedu.commons.spreadsheet.styles.CellStyle;

public class FontHeight
extends CellStyle {
    private final short height;

    public FontHeight(short height) {
        this.height = height;
    }

    @Override
    protected void appendToStyle(HSSFWorkbook book, HSSFCellStyle style, HSSFFont font) {
        font.setFontHeightInPoints(this.height);
    }

    @Override
    public HSSFCellStyle getStyle(HSSFWorkbook book) {
        HSSFCellStyle style = book.createCellStyle();
        HSSFFont font = book.createFont();
        this.appendToStyle(book, style, font);
        style.setFont(font);
        return style;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FontHeight) {
            FontHeight fontHeight = (FontHeight)obj;
            return this.height == fontHeight.height;
        }
        return false;
    }

    public int hashCode() {
        return this.height;
    }
}

