/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.commons.spreadsheet;

import java.io.Serializable;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ExcelStyle
implements Serializable {
    private static final long serialVersionUID = 6778686809629990612L;
    private HSSFCellStyle titleStyle;
    private HSSFCellStyle headerStyle;
    private HSSFCellStyle verticalHeaderStyle;
    private HSSFCellStyle stringStyle;
    private HSSFCellStyle doubleStyle;
    private HSSFCellStyle doubleNegativeStyle;
    private HSSFCellStyle integerStyle;
    private HSSFCellStyle labelStyle;
    private HSSFCellStyle valueStyle;
    private HSSFCellStyle redValueStyle;

    public ExcelStyle(HSSFWorkbook wb) {
        this.setTitleStyle(wb);
        this.setHeaderStyle(wb);
        this.setVerticalHeaderStyle(wb);
        this.setStringStyle(wb);
        this.setDoubleStyle(wb);
        this.setDoubleNegativeStyle(wb);
        this.setIntegerStyle(wb);
        this.setLabelStyle(wb);
        this.setValueStyle(wb);
        this.setRedValueStyle(wb);
    }

    private void setTitleStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        font.setBold(true);
        font.setFontHeightInPoints((short)10);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.CENTER);
        this.titleStyle = style;
    }

    private void setHeaderStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        font.setBold(true);
        font.setFontHeightInPoints((short)8);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        this.headerStyle = style;
    }

    private void setVerticalHeaderStyle(HSSFWorkbook wb) {
        this.verticalHeaderStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        font.setBold(true);
        font.setFontHeightInPoints((short)8);
        this.verticalHeaderStyle.setFont(font);
        this.verticalHeaderStyle.setAlignment(HorizontalAlignment.CENTER);
        this.verticalHeaderStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        this.verticalHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.verticalHeaderStyle.setBorderLeft(BorderStyle.THIN);
        this.verticalHeaderStyle.setBorderRight(BorderStyle.THIN);
        this.verticalHeaderStyle.setBorderBottom(BorderStyle.THIN);
        this.verticalHeaderStyle.setBorderTop(BorderStyle.THIN);
        this.verticalHeaderStyle.setRotation((short)90);
    }

    private void setStringStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        font.setFontHeightInPoints((short)8);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.CENTER);
        this.stringStyle = style;
    }

    private void setDoubleStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        font.setFontHeightInPoints((short)8);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.RIGHT);
        style.setDataFormat(wb.createDataFormat().getFormat("#,##0.00"));
        this.doubleStyle = style;
    }

    private void setDoubleNegativeStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        font.setFontHeightInPoints((short)8);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.RIGHT);
        style.setDataFormat(wb.createDataFormat().getFormat("#,##0.00"));
        font.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        this.doubleNegativeStyle = style;
    }

    private void setIntegerStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        font.setFontHeightInPoints((short)8);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setDataFormat(wb.createDataFormat().getFormat("0"));
        this.integerStyle = style;
    }

    private void setLabelStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        font.setBold(true);
        font.setFontHeightInPoints((short)8);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.LEFT);
        this.labelStyle = style;
    }

    private void setValueStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        font.setFontHeightInPoints((short)8);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setWrapText(true);
        this.valueStyle = style;
    }

    private void setRedValueStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        font.setFontHeightInPoints((short)8);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setWrapText(true);
        this.redValueStyle = style;
    }

    public HSSFCellStyle getDoubleNegativeStyle() {
        return this.doubleNegativeStyle;
    }

    public HSSFCellStyle getDoubleStyle() {
        return this.doubleStyle;
    }

    public HSSFCellStyle getHeaderStyle() {
        return this.headerStyle;
    }

    public HSSFCellStyle getIntegerStyle() {
        return this.integerStyle;
    }

    public HSSFCellStyle getLabelStyle() {
        return this.labelStyle;
    }

    public HSSFCellStyle getStringStyle() {
        return this.stringStyle;
    }

    public HSSFCellStyle getTitleStyle() {
        return this.titleStyle;
    }

    public HSSFCellStyle getValueStyle() {
        return this.valueStyle;
    }

    public HSSFCellStyle getRedValueStyle() {
        return this.redValueStyle;
    }

    public HSSFCellStyle getVerticalHeaderStyle() {
        return this.verticalHeaderStyle;
    }
}

