/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.cms.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.domain.exceptions.BennuCoreDomainException;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.cms.domain.CMSFolder;
import org.fenixedu.cms.domain.CMSTheme;
import org.fenixedu.cms.domain.CmsSettings;
import org.fenixedu.cms.domain.RoleTemplate;
import org.fenixedu.cms.domain.SiteBuilder;
import pt.ist.fenixframework.FenixFramework;

@DefaultJsonAdapter(value=SiteBuilder.class)
public class SiteBuilderAdapter
implements JsonAdapter<SiteBuilder> {
    public SiteBuilder create(JsonElement json, JsonBuilder ctx) {
        JsonObject jObj = json.getAsJsonObject();
        String slug = this.getRequiredValue(jObj, "slug").getAsString();
        SiteBuilder builder = new SiteBuilder(slug);
        if (jObj.has("theme") && !jObj.get("theme").isJsonNull()) {
            builder.setTheme((CMSTheme)FenixFramework.getDomainObject((String)jObj.get("theme").getAsString()));
        }
        if (jObj.has("folder") && !jObj.get("folder").isJsonNull()) {
            builder.setFolder((CMSFolder)FenixFramework.getDomainObject((String)jObj.get("folder").getAsString()));
        }
        if (jObj.has("embedded") && !jObj.get("embedded").isJsonNull()) {
            builder.setEmbedded(jObj.get("embedded").getAsBoolean());
        }
        if (jObj.has("roles") && !jObj.get("roles").isJsonArray()) {
            jObj.get("embedded").getAsJsonArray().forEach(role -> builder.addRoleTemplate((RoleTemplate)FenixFramework.getDomainObject((String)role.getAsString())));
        }
        return builder;
    }

    public SiteBuilder update(JsonElement json, SiteBuilder builder, JsonBuilder ctx) {
        JsonObject jObj = json.getAsJsonObject();
        CmsSettings.getInstance().ensureCanManageSettings();
        if (jObj.has("theme") && !jObj.get("theme").isJsonNull()) {
            builder.setTheme((CMSTheme)FenixFramework.getDomainObject((String)jObj.get("theme").getAsString()));
        }
        if (jObj.has("folder") && !jObj.get("folder").isJsonNull()) {
            builder.setFolder((CMSFolder)FenixFramework.getDomainObject((String)jObj.get("folder").getAsString()));
        }
        if (jObj.has("embedded") && !jObj.get("embedded").isJsonNull()) {
            builder.setEmbedded(jObj.get("embedded").getAsBoolean());
        }
        if (jObj.has("roles") && !jObj.get("roles").isJsonArray()) {
            jObj.get("embedded").getAsJsonArray().forEach(role -> builder.addRoleTemplate((RoleTemplate)FenixFramework.getDomainObject((String)role.getAsString())));
        }
        return builder;
    }

    public JsonElement view(SiteBuilder builder, JsonBuilder ctx) {
        JsonObject json = new JsonObject();
        json.addProperty("slug", builder.getSlug());
        json.addProperty("published", Boolean.valueOf(builder.getPublished()));
        json.addProperty("embedded", Boolean.valueOf(builder.getEmbedded()));
        if (builder.getTheme() != null) {
            json.addProperty("theme", builder.getTheme().getExternalId());
        }
        if (builder.getFolder() != null) {
            json.addProperty("createdBy", builder.getFolder().getExternalId());
        }
        json.add("roles", ctx.view((Object)builder.getRoleTemplateSet()));
        return json;
    }

    private JsonElement getRequiredValue(JsonObject obj, String property) {
        if (obj.has(property)) {
            return obj.get(property);
        }
        throw BennuCoreDomainException.cannotCreateEntity();
    }
}

