/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util.date;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public class IntervalTools {
    public static Interval getInterval(DateTime startDate, DateTime endDate) {
        long start = startDate == null ? Long.MIN_VALUE : startDate.getMillis();
        long end = endDate == null ? Long.MAX_VALUE : endDate.getMillis();
        return new Interval(start, end);
    }

    public static Interval getInterval(LocalDate startDate, LocalDate endDate) {
        long start = startDate == null ? Long.MIN_VALUE : startDate.toDateMidnight().getMillis();
        long end = endDate == null ? Long.MAX_VALUE : endDate.toDateMidnight().toDateTime().withTime(23, 59, 59, 999).getMillis();
        return new Interval(start, end);
    }

    @Deprecated
    public static Interval getInterval(YearMonthDay startDate, YearMonthDay endDate) {
        long start = startDate == null ? Long.MIN_VALUE : startDate.toDateMidnight().getMillis();
        long end = endDate == null ? Long.MAX_VALUE : endDate.toDateMidnight().toDateTime().withTime(23, 59, 59, 999).getMillis();
        return new Interval(start, end);
    }

    public static Interval getInterval(Date startDate, Date endDate) {
        long start = startDate == null ? Long.MIN_VALUE : startDate.getTime();
        long end = endDate == null ? Long.MAX_VALUE : endDate.getTime();
        return new Interval(start, end);
    }

    @Deprecated
    public static YearMonthDay getStartYMD(Interval interval) {
        long startTime = interval.getStartMillis();
        return startTime == Long.MIN_VALUE ? null : new YearMonthDay(startTime);
    }

    @Deprecated
    public static YearMonthDay getEndYMD(Interval interval) {
        long endTime = interval.getEndMillis();
        return endTime == Long.MAX_VALUE ? null : new YearMonthDay(endTime);
    }

    @Deprecated
    public static Interval intervalWithStart(Interval originalInterval, YearMonthDay day) {
        long millis = day.toDateMidnight().getMillis();
        return new Interval(millis, originalInterval.getEndMillis());
    }

    @Deprecated
    public static Interval intervalWithEnd(Interval originalInterval, YearMonthDay day) {
        long millis = day.toDateMidnight().toDateTime().withTime(23, 59, 59, 999).getMillis();
        return new Interval(originalInterval.getStartMillis(), millis);
    }

    public static Interval intervalWithStart(Interval interval, Date date) {
        long millis = date == null ? Long.MIN_VALUE : date.getTime();
        return new Interval(millis, interval.getEndMillis());
    }

    public static Interval intervalWithEnd(Interval interval, Date date) {
        long millis = date == null ? Long.MAX_VALUE : date.getTime();
        return new Interval(interval.getStartMillis(), millis);
    }
}

