/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.publico.candidacies;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.candidacy.GenericApplication;
import org.fenixedu.academic.domain.candidacy.GenericApplicationFile;
import org.fenixedu.academic.domain.candidacy.GenericApplicationLetterOfRecomentation;
import org.fenixedu.academic.domain.candidacy.GenericApplicationRecomentation;
import org.fenixedu.academic.domain.candidacy.util.GenericApplicationPeriodBean;
import org.fenixedu.academic.domain.candidacy.util.GenericApplicationRecommendationBean;
import org.fenixedu.academic.domain.candidacy.util.GenericApplicationUploadBean;
import org.fenixedu.academic.domain.candidacy.util.GenericApplicationUserBean;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.GenericApplicationPeriod;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.publico.PublicApplication;
import org.fenixedu.academic.ui.struts.action.publico.candidacies.GenericCandidaciesDA$callable$removeRecommendationFromApplication;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=PublicApplication.PublicCandidaciesApp.class, path="generic-applications", titleKey="title.applications")
@Mapping(path="/genericApplications", module="publico")
@Forwards(value={@Forward(name="genericApplications.listApplicationPeriods", path="/publico/candidacy/genericApplications/listApplicationPeriods.jsp"), @Forward(name="genericApplications.viewApplicationPeriod", path="/publico/candidacy/genericApplications/viewApplicationPeriod.jsp"), @Forward(name="genericApplications.confirmEmail", path="/publico/candidacy/genericApplications/confirmEmail.jsp"), @Forward(name="genericApplications.uploadRecommendation", path="/publico/candidacy/genericApplications/uploadRecommendation.jsp")})
public class GenericCandidaciesDA
extends FenixDispatchAction {
    public static final Advice advice$removeRecommendationFromApplication = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @EntryPoint
    public ActionForward listApplicationPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SortedSet<GenericApplicationPeriod> periods = GenericApplicationPeriod.getPeriods();
        request.setAttribute("periods", periods);
        User userView = Authenticate.getUser();
        if (userView != null && RoleType.MANAGER.isMember(userView.getPerson().getUser())) {
            GenericApplicationPeriodBean genericApplicationPeriodBean = new GenericApplicationPeriodBean();
            request.setAttribute("genericApplicationPeriodBean", (Object)genericApplicationPeriodBean);
        }
        return mapping.findForward("genericApplications.listApplicationPeriods");
    }

    public ActionForward viewApplicationPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GenericApplicationPeriod applicationPeriod = (GenericApplicationPeriod)((Object)this.getDomainObject(request, "applicationPeriodId"));
        request.setAttribute("applicationPeriod", (Object)applicationPeriod);
        if (applicationPeriod.isCurrentUserAllowedToMange()) {
            GenericApplicationUserBean genericApplicationUserBean = new GenericApplicationUserBean(applicationPeriod);
            request.setAttribute("genericApplicationUserBean", (Object)genericApplicationUserBean);
        }
        return mapping.findForward("genericApplications.viewApplicationPeriod");
    }

    public ActionForward createApplicationPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GenericApplicationPeriodBean bean = (GenericApplicationPeriodBean)this.getRenderedObject("genericApplicationPeriodBean");
        bean.createNewPeriod();
        return this.listApplicationPeriods(mapping, form, request, response);
    }

    public ActionForward addManager(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GenericApplicationUserBean bean = (GenericApplicationUserBean)this.getRenderedObject("genericApplicationUserBean");
        bean.addManagerUser();
        request.setAttribute("changedManagerList", (Object)Boolean.TRUE);
        return this.viewApplicationPeriod(mapping, form, request, response);
    }

    public ActionForward removeManager(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GenericApplicationPeriod applicationPeriod = (GenericApplicationPeriod)((Object)this.getDomainObject(request, "applicationPeriodId"));
        User user = (User)this.getDomainObject(request, "userId");
        applicationPeriod.removeManagerService(user);
        request.setAttribute("changedManagerList", (Object)Boolean.TRUE);
        return this.viewApplicationPeriod(mapping, form, request, response);
    }

    public void justCreateApplication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GenericApplicationPeriod period = (GenericApplicationPeriod)((Object)this.getDomainObject(request, "periodOid"));
        String email = (String)this.getFromRequest(request, "email");
        if (period != null && email != null) {
            GenericApplication application = period.createApplication(email);
            request.setAttribute("sentEmailForApplication", (Object)application);
        }
    }

    public ActionForward createApplication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.justCreateApplication(mapping, form, request, response);
        }
        catch (DomainException ex1) {
            this.addActionMessage(request, ex1.getMessage());
        }
        return this.listApplicationPeriods(mapping, form, request, response);
    }

    public ActionForward createApplicationFromPeriodPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.justCreateApplication(mapping, form, request, response);
        }
        catch (DomainException ex1) {
            this.addActionMessage(request, ex1.getMessage());
        }
        return this.viewApplicationPeriod(mapping, form, request, response);
    }

    public ActionForward confirmEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GenericApplication application = (GenericApplication)((Object)this.getDomainObject(request, "applicationExternalId"));
        String confirmationCode = (String)this.getFromRequest(request, "confirmationCode");
        if (application != null && confirmationCode != null && application.getConfirmationCode() != null && application.getConfirmationCode().equals(confirmationCode)) {
            request.setAttribute("application", (Object)application);
            if (application.getGenericApplicationPeriod().isOpen()) {
                request.setAttribute("uploadBean", (Object)new GenericApplicationUploadBean());
            }
            request.setAttribute("recommendationBean", (Object)new GenericApplicationRecommendationBean());
            return mapping.findForward("genericApplications.confirmEmail");
        }
        request.setAttribute("invalidOrIncorrectConfirmationCode", (Object)Boolean.TRUE);
        return this.listApplicationPeriods(mapping, form, request, response);
    }

    public ActionForward viewApplication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GenericApplication application = (GenericApplication)((Object)this.getDomainObject(request, "applicationId"));
        if (application != null && application.getGenericApplicationPeriod().isCurrentUserAllowedToMange()) {
            request.setAttribute("application", (Object)application);
            return mapping.findForward("genericApplications.confirmEmail");
        }
        request.setAttribute("invalidOrIncorrectConfirmationCode", (Object)Boolean.TRUE);
        return this.listApplicationPeriods(mapping, form, request, response);
    }

    public ActionForward saveApplication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState();
        request.setAttribute("applicationSaved", (Object)Boolean.TRUE);
        return this.confirmEmail(mapping, form, request, response);
    }

    public ActionForward submitApplication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState();
        GenericApplication application = (GenericApplication)((Object)this.getDomainObject(request, "applicationExternalId"));
        String confirmationCode = (String)this.getFromRequest(request, "confirmationCode");
        if (application != null && confirmationCode != null && application.getConfirmationCode() != null && application.getConfirmationCode().equals(confirmationCode)) {
            application.submitApplication();
            request.setAttribute("applicationSaved", (Object)Boolean.TRUE);
        }
        return this.confirmEmail(mapping, form, request, response);
    }

    public ActionForward uploadDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GenericApplicationUploadBean uploadBean = (GenericApplicationUploadBean)this.getRenderedObject("genericApplicationDocumentUploadFormFile");
        GenericApplication application = (GenericApplication)((Object)this.getDomainObject(request, "applicationExternalId"));
        String confirmationCode = (String)this.getFromRequest(request, "confirmationCode");
        if (application != null && confirmationCode != null && application.getConfirmationCode() != null && application.getConfirmationCode().equals(confirmationCode)) {
            try {
                GenericApplicationFile file = uploadBean.uploadTo(application);
                if (file != null) {
                    RenderUtils.invalidateViewState();
                } else {
                    request.setAttribute("hasUploadFileError", (Object)Boolean.TRUE);
                }
                return this.confirmEmail(mapping, form, request, response);
            }
            catch (Error e) {
                this.addActionMessage(request, "message.file.could.not.read");
                request.setAttribute("hasUploadFileError", (Object)Boolean.TRUE);
                return this.confirmEmail(mapping, form, request, response);
            }
        }
        request.setAttribute("invalidOrIncorrectConfirmationCode", (Object)Boolean.TRUE);
        return this.listApplicationPeriods(mapping, form, request, response);
    }

    public ActionForward downloadFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        GenericApplication application = (GenericApplication)((Object)this.getDomainObject(request, "applicationExternalId"));
        String confirmationCode = (String)this.getFromRequest(request, "confirmationCode");
        GenericApplicationFile file = (GenericApplicationFile)((Object)this.getDomainObject(request, "fileExternalId"));
        if (application != null && file != null && file.getGenericApplication() == application && (confirmationCode != null && application.getConfirmationCode() != null && application.getConfirmationCode().equals(confirmationCode) || application.getGenericApplicationPeriod().isCurrentUserAllowedToMange())) {
            response.setContentType(file.getContentType());
            response.addHeader("Content-Disposition", "attachment; filename=\"" + file.getFilename() + "\"");
            response.setContentLength(file.getSize().intValue());
            DataOutputStream dos = new DataOutputStream((OutputStream)response.getOutputStream());
            dos.write(file.getContent());
            dos.close();
        } else {
            response.setStatus(400);
            response.getWriter().write(HttpStatus.getStatusText((int)400));
            response.getWriter().close();
        }
        return null;
    }

    public ActionForward downloadRecomendationFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String confirmationCode = (String)this.getFromRequest(request, "confirmationCode");
        GenericApplicationLetterOfRecomentation file = (GenericApplicationLetterOfRecomentation)((Object)this.getDomainObject(request, "fileExternalId"));
        if (file != null && file.getRecomentation() != null && file.getRecomentation().getConfirmationCode() != null && (file.getRecomentation().getGenericApplication().getGenericApplicationPeriod().isCurrentUserAllowedToMange() || file.getRecomentation().getConfirmationCode().equals(confirmationCode))) {
            response.setContentType(file.getContentType());
            response.addHeader("Content-Disposition", "attachment; filename=\"" + file.getFilename() + "\"");
            response.setContentLength(file.getSize().intValue());
            DataOutputStream dos = new DataOutputStream((OutputStream)response.getOutputStream());
            dos.write(file.getContent());
            dos.close();
        } else {
            response.setStatus(400);
            response.getWriter().write(HttpStatus.getStatusText((int)400));
            response.getWriter().close();
        }
        return null;
    }

    public ActionForward deleteFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        GenericApplication application = (GenericApplication)((Object)this.getDomainObject(request, "applicationExternalId"));
        String confirmationCode = (String)this.getFromRequest(request, "confirmationCode");
        GenericApplicationFile file = (GenericApplicationFile)((Object)this.getDomainObject(request, "fileExternalId"));
        if (application != null && confirmationCode != null && application.getConfirmationCode() != null && application.getConfirmationCode().equals(confirmationCode) && file != null && file.getGenericApplication() == application) {
            FenixFramework.atomic(() -> file.delete());
        } else {
            response.setStatus(400);
            response.getWriter().write(HttpStatus.getStatusText((int)400));
            response.getWriter().close();
        }
        return this.confirmEmail(mapping, form, request, response);
    }

    public ActionForward requestRecommendation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GenericApplicationRecommendationBean recommendationBean = (GenericApplicationRecommendationBean)this.getRenderedObject("recommendationBean");
        GenericApplication application = (GenericApplication)((Object)this.getDomainObject(request, "applicationExternalId"));
        String confirmationCode = (String)this.getFromRequest(request, "confirmationCode");
        if (application != null && confirmationCode != null && application.getConfirmationCode() != null && application.getConfirmationCode().equals(confirmationCode)) {
            recommendationBean.requestRecommendation(application);
            RenderUtils.invalidateViewState();
            return this.confirmEmail(mapping, form, request, response);
        }
        request.setAttribute("invalidOrIncorrectConfirmationCode", (Object)Boolean.TRUE);
        return this.listApplicationPeriods(mapping, form, request, response);
    }

    public ActionForward deleteRecommendationRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        GenericApplication application = (GenericApplication)((Object)this.getDomainObject(request, "applicationExternalId"));
        String confirmationCode = (String)this.getFromRequest(request, "confirmationCode");
        GenericApplicationRecomentation recommendation = (GenericApplicationRecomentation)((Object)this.getDomainObject(request, "recomentationId"));
        if (application != null && confirmationCode != null && application.getConfirmationCode() != null && application.getConfirmationCode().equals(confirmationCode) && recommendation != null && recommendation.getGenericApplication() == application) {
            recommendation.sendEmailForRecommendationDelete();
            this.removeRecommendationFromApplication(application, recommendation);
            return this.confirmEmail(mapping, form, request, response);
        }
        request.setAttribute("invalidOrIncorrectConfirmationCode", (Object)Boolean.TRUE);
        return this.listApplicationPeriods(mapping, form, request, response);
    }

    private void removeRecommendationFromApplication(GenericApplication genericApplication, GenericApplicationRecomentation genericApplicationRecomentation) {
        Object object = advice$removeRecommendationFromApplication.perform((Callable)new GenericCandidaciesDA$callable$removeRecommendationFromApplication(this, genericApplication, genericApplicationRecomentation));
    }

    static /* synthetic */ void advised$removeRecommendationFromApplication(GenericCandidaciesDA this_, GenericApplication application, GenericApplicationRecomentation recommendation) {
        application.removeGenericApplicationRecomentation(recommendation);
    }

    public ActionForward resendRecommendationRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        GenericApplication application = (GenericApplication)((Object)this.getDomainObject(request, "applicationExternalId"));
        String confirmationCode = (String)this.getFromRequest(request, "confirmationCode");
        GenericApplicationRecomentation recomentation = (GenericApplicationRecomentation)((Object)this.getDomainObject(request, "recomentationId"));
        if (application != null && confirmationCode != null && application.getConfirmationCode() != null && application.getConfirmationCode().equals(confirmationCode) && recomentation != null && recomentation.getGenericApplication() == application) {
            recomentation.sendEmailForRecommendation();
            return this.confirmEmail(mapping, form, request, response);
        }
        request.setAttribute("invalidOrIncorrectConfirmationCode", (Object)Boolean.TRUE);
        return this.listApplicationPeriods(mapping, form, request, response);
    }

    public ActionForward uploadRecommendation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GenericApplicationRecomentation recomentation = (GenericApplicationRecomentation)((Object)this.getDomainObject(request, "recommendationExternalId"));
        String confirmationCode = (String)this.getFromRequest(request, "confirmationCode");
        if (recomentation != null && confirmationCode != null && recomentation.getConfirmationCode() != null && recomentation.getConfirmationCode().equals(confirmationCode)) {
            GenericApplicationUploadBean uploadBean = (GenericApplicationUploadBean)this.getRenderedObject("uploadBean");
            if (uploadBean == null) {
                uploadBean = new GenericApplicationUploadBean();
                uploadBean.setDisplayName(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.recommendation.document", (String[])new String[0]));
            } else {
                try {
                    GenericApplicationLetterOfRecomentation file = uploadBean.uploadTo(recomentation);
                    if (file != null) {
                        RenderUtils.invalidateViewState();
                        request.setAttribute("recommendationSaved", (Object)Boolean.TRUE);
                    }
                }
                catch (Error e) {
                    this.addActionMessage(request, "message.file.could.not.read");
                }
            }
            request.setAttribute("uploadBean", (Object)uploadBean);
            request.setAttribute("recomentation", (Object)recomentation);
            return mapping.findForward("genericApplications.uploadRecommendation");
        }
        request.setAttribute("invalidOrIncorrectConfirmationCode", (Object)Boolean.TRUE);
        return this.listApplicationPeriods(mapping, form, request, response);
    }
}

