/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.publico;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PublicCandidacyHashCode;
import org.fenixedu.academic.service.services.exceptions.PasswordInitializationException;
import org.fenixedu.academic.service.services.person.InitializePassword;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.publico.InternationalRegistrationForm;
import org.fenixedu.academic.ui.struts.action.publico.candidacies.erasmus.ErasmusIndividualCandidacyProcessPublicDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(module="external", path="/internationalRegistration", scope="request", parameter="method", validate=true, formBean="internationalRegistrationForm", formBeanClass=InternationalRegistrationForm.class, functionality=ErasmusIndividualCandidacyProcessPublicDA.class)
@Forwards(value={@Forward(name="international-registration", path="/publico/candidacy/internationalRegistration_bd.jsp"), @Forward(name="success", path="/publico/candidacy/internationalRegistrationSuccess_bd.jsp")})
public class InternationalRegistrationDA
extends FenixDispatchAction {
    public ActionForward showInternationalRegistration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.readPersonByCandidacyHashCode(request.getParameter("hash"));
        if (person != null) {
            request.setAttribute("person", (Object)person);
            return mapping.findForward("international-registration");
        }
        return this.setError(request, mapping, "internationalRegistration.error.invalidLink", "international-registration", null);
    }

    public ActionForward updateUserPassword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (form == null || !(form instanceof InternationalRegistrationForm)) {
            return this.setError(request, mapping, "internationalRegistration.error.invalidLink", "international-registration", null);
        }
        InternationalRegistrationForm registrationForm = (InternationalRegistrationForm)form;
        Person person = this.readPersonByCandidacyHashCode(registrationForm.getHashCode());
        request.setAttribute("person", (Object)person);
        if (person == null) {
            return this.setError(request, mapping, "internationalRegistration.error.invalidLink", "international-registration", null);
        }
        if (!StringUtils.equals((String)registrationForm.getPassword(), (String)registrationForm.getRetypedPassword())) {
            return this.setError(request, mapping, "internationalRegistration.error.passwordsDontMatch", "international-registration", null);
        }
        if (StringUtils.isEmpty((String)registrationForm.getPassword())) {
            return this.setError(request, mapping, "internationalRegistration.error.passwordsDontMatch", "international-registration", null);
        }
        try {
            InitializePassword.run(person.getUser(), registrationForm.getPassword());
        }
        catch (PasswordInitializationException e) {
            return this.setError(request, mapping, e.getMessage(), "international-registration", e);
        }
        catch (Exception e) {
            return this.setError(request, mapping, "internationalRegistration.error.registering", "international-registration", e);
        }
        return mapping.findForward("success");
    }

    private Person readPersonByCandidacyHashCode(String hashCode) {
        if (!StringUtils.isEmpty((String)hashCode)) {
            PublicCandidacyHashCode publicCandidacyHashCode = PublicCandidacyHashCode.getPublicCandidacyCodeByHash(hashCode);
            return publicCandidacyHashCode != null ? Person.readPersonByEmailAddress(publicCandidacyHashCode.getEmail()) : null;
        }
        return null;
    }
}

