/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice;

import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramContextPeriod;
import org.fenixedu.academic.domain.phd.PhdProgramContextPeriodBean;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.ui.struts.action.phd.PhdDA;
import org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice.PhdIndividualProgramProcessDA;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/phdProgram", module="academicAdministration", functionality=PhdIndividualProgramProcessDA.class)
@Forwards(value={@Forward(name="listPhdProgramForPeriods", path="/phd/academicAdminOffice/periods/phdProgram/listPhdProgramForPeriods.jsp"), @Forward(name="viewPhdProgramPeriods", path="/phd/academicAdminOffice/periods/phdProgram/viewPhdProgramPeriods.jsp"), @Forward(name="addPhdProgramPeriod", path="/phd/academicAdminOffice/periods/phdProgram/addPhdProgramPeriod.jsp")})
public class PhdProgramDA
extends PhdDA {
    public ActionForward listPhdProgramForPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdPrograms", AcademicAccessRule.getPhdProgramsAccessibleToFunction(AcademicOperationType.MANAGE_PHD_PROCESSES, Authenticate.getUser()).collect(Collectors.toSet()));
        return mapping.findForward("listPhdProgramForPeriods");
    }

    public ActionForward viewPhdProgramPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgram phdProgram = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
        request.setAttribute("phdProgram", (Object)phdProgram);
        return mapping.findForward("viewPhdProgramPeriods");
    }

    public ActionForward removePhdProgramPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramContextPeriod period = (PhdProgramContextPeriod)((Object)this.getDomainObject(request, "phdProgramContextPeriodId"));
        period.deletePeriod();
        return this.viewPhdProgramPeriods(mapping, form, request, response);
    }

    public ActionForward prepareAddPhdProgramPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgram phdProgram = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
        PhdProgramContextPeriodBean bean = new PhdProgramContextPeriodBean(phdProgram);
        request.setAttribute("phdProgram", (Object)phdProgram);
        request.setAttribute("phdProgramContextPeriodBean", (Object)bean);
        return mapping.findForward("addPhdProgramPeriod");
    }

    public ActionForward addPhdProgramPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdProgram phdProgram = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
            PhdProgramContextPeriodBean bean = (PhdProgramContextPeriodBean)this.getRenderedObject("phdProgramContextPeriodBean");
            phdProgram.create(bean);
        }
        catch (PhdDomainOperationException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.addPhdProgramPeriodInvalid(mapping, form, request, response);
        }
        return this.viewPhdProgramPeriods(mapping, form, request, response);
    }

    public ActionForward addPhdProgramPeriodInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgram phdProgram = (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
        PhdProgramContextPeriodBean bean = (PhdProgramContextPeriodBean)this.getRenderedObject("phdProgramContextPeriodBean");
        request.setAttribute("phdProgram", (Object)phdProgram);
        request.setAttribute("phdProgramContextPeriodBean", (Object)bean);
        return mapping.findForward("addPhdProgramPeriod");
    }
}

