/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.messaging;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.service.services.person.SearchPerson;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.messaging.FindPersonBean;
import org.fenixedu.academic.ui.struts.action.messaging.MessagingApplication;
import org.fenixedu.academic.util.CollectionPager;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=MessagingApplication.MessagingSearchApp.class, path="find-person", titleKey="label.person.findPerson")
@Forwards(value={@Forward(name="findPerson", path="/messaging/findPerson.jsp")})
@Mapping(path="/findPerson", module="messaging")
public class FindPersonAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareFindPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FindPersonBean bean = new FindPersonBean();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("findPerson");
    }

    public ActionForward findPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SearchPerson.SearchPersonPredicate predicate;
        SearchPerson.SearchParameters searchParameters;
        CollectionPager<Person> result;
        User userView = Authenticate.getUser();
        FindPersonBean bean = (FindPersonBean)this.getRenderedObject();
        boolean fromRequest = true;
        String name = request.getParameter("name");
        String roleType = null;
        String departmentId = null;
        String degreeId = null;
        String degreeType = null;
        if (bean != null && name == null) {
            fromRequest = false;
            name = bean.getName();
            roleType = bean.getRoleType() == null ? null : bean.getRoleType().toString();
            departmentId = bean.getDepartmentExternalId();
            degreeId = bean.getDegreeExternalId();
            degreeType = bean.getDegreeType() == null ? null : bean.getDegreeType().toString();
        } else {
            roleType = request.getParameter("roleType");
            departmentId = request.getParameter("departmentId");
            degreeId = request.getParameter("degreeId");
            degreeType = request.getParameter("degreeType");
        }
        if (name == null) {
            // empty if block
        }
        if ((result = SearchPerson.runSearchPerson(searchParameters = new SearchPerson.SearchParameters(name, null, null, null, null, roleType, degreeType, degreeId, departmentId, Boolean.TRUE, null, null), predicate = new SearchPerson.SearchPersonPredicate(searchParameters))) == null) {
            this.addErrorMessage(request, "impossibleFindPerson", "error.manager.implossible.findPerson", new Object[0]);
            return mapping.findForward("findPerson");
        }
        if (result.getCollection().isEmpty()) {
            this.addErrorMessage(request, "impossibleFindPerson", "error.manager.implossible.findPerson", new Object[0]);
            return mapping.findForward("findPerson");
        }
        String pageNumberString = request.getParameter("pageNumber");
        Integer pageNumber = !StringUtils.isEmpty((String)pageNumberString) ? Integer.valueOf(pageNumberString) : Integer.valueOf(1);
        request.setAttribute("pageNumber", (Object)pageNumber);
        request.setAttribute("numberOfPages", (Object)result.getNumberOfPages());
        request.setAttribute("personListFinded", result.getPage(pageNumber));
        request.setAttribute("totalFindedPersons", (Object)result.getCollection().size());
        request.setAttribute("name", (Object)name);
        request.setAttribute("roleType", (Object)(roleType == null ? "" : roleType));
        request.setAttribute("degreeId", (Object)(degreeId == null ? "" : degreeId.toString()));
        request.setAttribute("degreeType", (Object)(degreeType == null ? "" : degreeType.toString()));
        request.setAttribute("departmentId", (Object)(departmentId == null ? "" : departmentId.toString()));
        Boolean viewPhoto = null;
        if (request.getParameter("viewPhoto") != null && request.getParameter("viewPhoto").length() > 0) {
            viewPhoto = this.getCheckBoxValue(request.getParameter("viewPhoto"));
        } else if (bean.getViewPhoto() != null) {
            viewPhoto = bean.getViewPhoto();
        }
        request.setAttribute("viewPhoto", (Object)viewPhoto);
        if (fromRequest) {
            bean = new FindPersonBean();
            bean.setName(name);
            bean.setViewPhoto(viewPhoto);
            if (!StringUtils.isEmpty((String)roleType)) {
                bean.setRoleType(RoleType.valueOf(roleType));
            }
            if (!StringUtils.isEmpty((String)degreeId)) {
                bean.setDegree((Degree)FenixFramework.getDomainObject((String)degreeId));
            }
            if (!StringUtils.isEmpty((String)degreeType)) {
                bean.setDegreeType((DegreeType)FenixFramework.getDomainObject((String)degreeType));
            }
            if (!StringUtils.isEmpty((String)departmentId)) {
                bean.setDepartment((Department)FenixFramework.getDomainObject((String)departmentId));
            }
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("findPerson");
    }

    private Boolean getCheckBoxValue(String value) {
        if (value != null && (value.equals("true") || value.equals("yes") || value.equals("on"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public ActionForward postback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FindPersonBean bean = (FindPersonBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("findPerson");
    }
}

