/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.executionDegreesManagement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.coordinator.AddCoordinator;
import org.fenixedu.academic.service.services.coordinator.RemoveCoordinators;
import org.fenixedu.academic.service.services.coordinator.ResponsibleCoordinators;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.manager.DeleteExecutionDegreesOfDegreeCurricularPlan;
import org.fenixedu.academic.service.services.manager.executionDegreesManagement.EditExecutionDegree;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.spaces.domain.Space;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=ManagerApplications.ManagerExecutionsApp.class, path="execution-degrees-management", titleKey="label.manager.executionDegreeManagement")
@Mapping(module="manager", path="/executionDegreesManagement", input="/executionDegreesManagement.do?method=readDegreeCurricularPlans", formBean="executionDegreesManagementForm")
@Forwards(value={@Forward(name="manageCoordinators", path="/manager/executionDegreesManagement/manageCoordinators.jsp"), @Forward(name="insertCoordinator", path="/manager/executionDegreesManagement/insertCoordinator.jsp"), @Forward(name="editExecutionDegree", path="/manager/executionDegreesManagement/editExecutionDegree.jsp"), @Forward(name="executionDegreeManagement", path="/manager/executionDegreesManagement/executionDegreesManagement.jsp")})
public class ExecutionDegreesManagementDispatchAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward readDegreeCurricularPlans(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.readAndSetDegrees(request);
        DynaActionForm form = (DynaActionForm)actionForm;
        String degreeType = form.getString("degreeType");
        if (degreeType != null && degreeType.length() != 0) {
            this.readAndSetDegreeCurricularPlans(request, degreeType);
        }
        return mapping.findForward("executionDegreeManagement");
    }

    public ActionForward readExecutionDegrees(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlan degreeCurricularPlan;
        DynaActionForm form = (DynaActionForm)actionForm;
        String degreeCurricularPlanID = (String)form.get("degreeCurricularPlanID");
        if (!StringUtils.isEmpty((String)degreeCurricularPlanID) && (degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanID)) != null) {
            request.setAttribute("executionDegrees", (Object)degreeCurricularPlan.getExecutionDegreesSet());
        }
        return this.readDegreeCurricularPlans(mapping, actionForm, request, response);
    }

    public ActionForward readCoordinators(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm form = (DynaActionForm)actionForm;
        String executionDegreeID = (String)form.get("executionDegreeID");
        if (!StringUtils.isEmpty((String)executionDegreeID)) {
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeID);
            request.setAttribute("executionDegree", (Object)executionDegree);
            this.setResponsibleCoordinatorsIDs(executionDegree, form);
            return mapping.findForward("manageCoordinators");
        }
        return mapping.getInputForward();
    }

    private void setResponsibleCoordinatorsIDs(ExecutionDegree executionDegree, DynaActionForm form) {
        ArrayList<String> responsibleCoordinatorsList = new ArrayList<String>();
        for (Coordinator coordinator : executionDegree.getCoordinatorsListSet()) {
            if (!coordinator.isResponsible()) continue;
            responsibleCoordinatorsList.add(coordinator.getExternalId());
        }
        form.set("responsibleCoordinatorsIDs", (Object)responsibleCoordinatorsList.toArray(new String[responsibleCoordinatorsList.size()]));
    }

    public ActionForward prepareInsertCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.readExecutionDegree(mapping, actionForm, request, "insertCoordinator");
    }

    public ActionForward insertCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm form = (DynaActionForm)actionForm;
        String coordinatorID = (String)form.get("coordinatorID");
        String executionDegreeID = (String)form.get("executionDegreeID");
        try {
            AddCoordinator.run(executionDegreeID, coordinatorID);
        }
        catch (IllegalDataAccessException e) {
            this.addMessage(request, "error.notAuthorized");
        }
        catch (FenixServiceException e) {
            this.addMessage(request, e.getMessage());
        }
        catch (DomainException e) {
            this.addMessage(request, e.getMessage());
        }
        return this.readCoordinators(mapping, actionForm, request, response);
    }

    public ActionForward saveCoordinatorsInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm form = (DynaActionForm)actionForm;
        String executionDegreeID = (String)form.get("executionDegreeID");
        try {
            String[] coordinatorsToBeResponsibleIDs = (String[])form.get("responsibleCoordinatorsIDs");
            ResponsibleCoordinators.run(executionDegreeID, Arrays.asList(coordinatorsToBeResponsibleIDs));
            String[] coordinatorsToRemoveIDs = (String[])form.get("removeCoordinatorsIDs");
            RemoveCoordinators.run(executionDegreeID, Arrays.asList(coordinatorsToRemoveIDs));
        }
        catch (IllegalDataAccessException e) {
            this.addMessage(request, "error.notAuthorized");
        }
        catch (FenixServiceException e) {
            this.addMessage(request, e.getMessage());
        }
        catch (DomainException e) {
            this.addMessage(request, e.getMessage());
        }
        return this.readCoordinators(mapping, actionForm, request, response);
    }

    public ActionForward prepareEditExecutionDegree(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm form = (DynaActionForm)actionForm;
        String executionDegreeID = (String)form.get("executionDegreeID");
        if (!StringUtils.isEmpty((String)executionDegreeID)) {
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeID);
            request.setAttribute("executionDegree", (Object)executionDegree);
            request.setAttribute("executionYears", ExecutionYear.readNotClosedExecutionYears());
            request.setAttribute("campus", (Object)Space.getAllCampus());
            form.set("executionYearID", (Object)executionDegree.getExecutionYear().getExternalId());
            form.set("campusID", (Object)executionDegree.getCampus().getExternalId());
        }
        return mapping.findForward("editExecutionDegree");
    }

    public ActionForward editExecutionDegree(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm form = (DynaActionForm)actionForm;
        String executionDegreeID = (String)form.get("executionDegreeID");
        String executionYearID = (String)form.get("executionYearID");
        String campusID = (String)form.get("campusID");
        Boolean temporaryExamMap = Boolean.valueOf((String)form.get("temporaryExamMap"));
        try {
            EditExecutionDegree.run(executionDegreeID, executionYearID, campusID, temporaryExamMap == false);
            return this.readExecutionDegrees(mapping, actionForm, request, response);
        }
        catch (NotAuthorizedException e) {
            this.addMessage(request, "error.notAuthorized");
            return this.readExecutionDegrees(mapping, actionForm, request, response);
        }
        catch (FenixServiceException e) {
            this.addMessage(request, e.getMessage());
        }
        catch (DomainException e) {
            this.addMessage(request, e.getMessage());
        }
        return this.prepareEditExecutionDegree(mapping, actionForm, request, response);
    }

    private void readAndSetDegrees(HttpServletRequest request) {
        ArrayList<LabelValueBean> degreeTypes = new ArrayList<LabelValueBean>();
        DegreeType.all().forEach(type -> degreeTypes.add(new LabelValueBean(type.getName().getContent(), type.getExternalId())));
        degreeTypes.add(0, new LabelValueBean(BundleUtil.getString((String)"resources.EnumerationResources", (String)"dropDown.Default", (String[])new String[0]), ""));
        request.setAttribute("degreeTypes", degreeTypes);
    }

    private void readAndSetDegreeCurricularPlans(HttpServletRequest request, String degreeTypeName) {
        ArrayList<DegreeCurricularPlan> toShow = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : DegreeCurricularPlan.readNotEmptyDegreeCurricularPlans()) {
            if (!degreeCurricularPlan.getDegree().getDegreeType().getExternalId().equals(degreeTypeName) || degreeCurricularPlan.getExecutionDegreesSet().isEmpty()) continue;
            toShow.add(degreeCurricularPlan);
        }
        Collections.sort(toShow, DegreeCurricularPlan.DEGREE_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_EXECUTION_DEGREE_AND_DEGREE_CODE);
        ArrayList<LabelValueBean> degreeCurricularPlans = new ArrayList<LabelValueBean>();
        for (DegreeCurricularPlan degreeCurricularPlan : toShow) {
            degreeCurricularPlans.add(new LabelValueBean(degreeCurricularPlan.getDegree().getName() + " > " + degreeCurricularPlan.getName(), degreeCurricularPlan.getExternalId().toString()));
        }
        degreeCurricularPlans.add(0, new LabelValueBean(BundleUtil.getString((String)"resources.EnumerationResources", (String)"dropDown.Default", (String[])new String[0]), ""));
        request.setAttribute("degreeCurricularPlans", degreeCurricularPlans);
    }

    private ActionForward readExecutionDegree(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, String findForward) {
        DynaActionForm form = (DynaActionForm)actionForm;
        String executionDegreeID = (String)form.get("executionDegreeID");
        if (!StringUtils.isEmpty((String)executionDegreeID)) {
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeID);
            request.setAttribute("executionDegree", (Object)executionDegree);
            return mapping.findForward(findForward);
        }
        return mapping.getInputForward();
    }

    private void addMessage(HttpServletRequest request, String keyMessage) {
        ActionMessages actionMessages = new ActionMessages();
        actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(keyMessage));
        this.saveMessages(request, actionMessages);
    }

    public ActionForward deleteExecutionDegrees(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        DynaActionForm deleteForm = (DynaActionForm)form;
        List<String> executionDegreesIds = Arrays.asList((String[])deleteForm.get("internalIds"));
        try {
            List<String> undeletedExecutionDegreesYears = DeleteExecutionDegreesOfDegreeCurricularPlan.run(executionDegreesIds);
            if (!undeletedExecutionDegreesYears.isEmpty()) {
                ActionErrors actionErrors = new ActionErrors();
                for (String undeletedExecutionDegreesYear : undeletedExecutionDegreesYears) {
                    ActionError error = new ActionError("errors.invalid.delete.not.empty.execution.degree", (Object)undeletedExecutionDegreesYear);
                    actionErrors.add("errors.invalid.delete.not.empty.execution.degree", error);
                }
                this.saveErrors(request, actionErrors);
            }
            return this.readExecutionDegrees(mapping, form, request, response);
        }
        catch (FenixServiceException fenixServiceException) {
            throw new FenixActionException(fenixServiceException.getMessage());
        }
    }
}

