/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.RootCourseGroup;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.RootCurriculumGroup;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.bennu.portal.servlet.PortalLayoutInjector;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.core.SharedIdentityMap;

@StrutsFunctionality(app=ManagerApplications.ManagerSystemManagementApp.class, path="system-info", titleKey="title.system.information")
@Mapping(module="manager", path="/monitorSystem")
@Forwards(value={@Forward(name="Show", path="/manager/monitorSystem_bd.jsp")})
public class MonitorSystemDA
extends FenixDispatchAction {
    private static final Logger logger = LoggerFactory.getLogger(MonitorSystemDA.class);

    @EntryPoint
    public ActionForward monitor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("properties", (Object)System.getProperties());
        request.setAttribute("startMillis", (Object)("" + ExecutionSemester.readActualExecutionSemester().getAcademicInterval().getStartMillis()));
        request.setAttribute("endMillis", (Object)("" + ExecutionSemester.readActualExecutionSemester().getAcademicInterval().getEndMillis()));
        request.setAttribute("chronology", (Object)("" + ExecutionSemester.readActualExecutionSemester().getAcademicInterval().getChronology().toString()));
        request.setAttribute("cacheSize", (Object)SharedIdentityMap.getCache().size());
        return mapping.findForward("Show");
    }

    public ActionForward dumpThreadTrace(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> trace : traces.entrySet()) {
            builder.append(trace.getKey());
            builder.append(":\n");
            for (StackTraceElement element : trace.getValue()) {
                builder.append("\t");
                builder.append(element);
                builder.append("\n");
            }
            builder.append("\n");
        }
        try (PrintWriter writer = response.getWriter();){
            PortalLayoutInjector.skipLayoutOn((HttpServletRequest)request);
            response.setContentType("text/plain");
            response.setStatus(200);
            writer.write(builder.toString());
            writer.flush();
        }
        return null;
    }

    public ActionForward warmUpCacheForEnrolmentPeriodStart(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExecutionSemester pes;
        ExecutionSemester ces = ExecutionSemester.readActualExecutionSemester();
        ExecutionSemester executionSemester = pes = ces == null ? null : ces.getPreviousExecutionPeriod();
        if (ces != null && pes != null) {
            long s = System.currentTimeMillis();
            for (ExecutionCourse executionCourse : ces.getAssociatedExecutionCoursesSet()) {
                executionCourse.getName();
                for (CourseLoad courseLoad : executionCourse.getCourseLoadsSet()) {
                    courseLoad.getType();
                    for (Shift shift : courseLoad.getShiftsSet()) {
                        shift.getNome();
                        for (SchoolClass schoolClass : shift.getAssociatedClassesSet()) {
                            schoolClass.getNome();
                            ExecutionDegree executionDegree = schoolClass.getExecutionDegree();
                            DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
                            degreeCurricularPlan.getName();
                            Degree degree = degreeCurricularPlan.getDegree();
                            degree.getDegreeType();
                            RootCourseGroup root = degreeCurricularPlan.getRoot();
                            this.load((DegreeModule)((Object)root));
                        }
                        for (Lesson lesson : shift.getAssociatedLessonsSet()) {
                            Object period;
                            lesson.getBeginHourMinuteSecond();
                            for (period = lesson.getPeriod(); period != null; period = period.getNextPeriod()) {
                                ((OccupationPeriod)((Object)period)).getStartDate();
                            }
                            period = lesson.getLessonInstancesSet().iterator();
                            while (period.hasNext()) {
                                LessonInstance lessonInstance = (LessonInstance)((Object)period.next());
                                lessonInstance.getBeginDateTime();
                            }
                        }
                    }
                }
            }
            long e = System.currentTimeMillis();
            logger.info("Warming up cache for enrolment period. Load of current semester information took {}ms.", (Object)(e - s));
            s = System.currentTimeMillis();
            e = System.currentTimeMillis();
            logger.info("Warming up cache for enrolment period. Load of room listing took {}ms.", (Object)(e - s));
            HashSet<Student> students = new HashSet<Student>();
            s = System.currentTimeMillis();
            for (Enrolment enrolment : pes.getEnrolmentsSet()) {
                students.add(enrolment.getStudent());
            }
            e = System.currentTimeMillis();
            logger.info("Warming up cache for enrolment period. Search for students took {}ms.", (Object)(e - s));
            s = System.currentTimeMillis();
            for (Student student : students) {
                student.getNumber();
                for (Registration registration : student.getRegistrationsSet()) {
                    registration.getNumber();
                    for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
                        RootCurriculumGroup root = studentCurricularPlan.getRoot();
                        this.load((CurriculumModule)((Object)root));
                    }
                }
            }
            e = System.currentTimeMillis();
            logger.info("Warming up cache for enrolment period. Load of student curriculum took {}ms.", (Object)(e - s));
        }
        return this.monitor(mapping, form, request, response);
    }

    private void load(CurriculumModule curriculumModule) {
        block3: {
            block4: {
                if (curriculumModule == null) break block3;
                curriculumModule.getCreationDateDateTime();
                DegreeModule degreeModule = curriculumModule.getDegreeModule();
                if (degreeModule != null) {
                    degreeModule.getName();
                }
                if (!curriculumModule.isCurriculumLine()) break block4;
                CurriculumLine curriculumLine = (CurriculumLine)((Object)curriculumModule);
                if (!curriculumLine.isEnrolment()) break block3;
                Enrolment enrolment = (Enrolment)((Object)curriculumLine);
                for (EnrolmentEvaluation enrolmentEvaluation : enrolment.getEvaluationsSet()) {
                    enrolmentEvaluation.getGrade();
                }
                break block3;
            }
            CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)curriculumModule);
            for (CurriculumModule child : curriculumGroup.getCurriculumModulesSet()) {
                this.load(child);
            }
        }
    }

    private void load(DegreeModule degreeModule) {
        degreeModule.getName();
        if (degreeModule.isCourseGroup()) {
            CourseGroup courseGroup = (CourseGroup)((Object)degreeModule);
            for (Context context : courseGroup.getChildContextsSet()) {
                DegreeModule child = context.getChildDegreeModule();
                this.load(child);
            }
        } else {
            CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModule);
            CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
            if (competenceCourse != null) {
                competenceCourse.getName();
            }
        }
    }
}

