/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager;

import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.service.services.manager.AlterExecutionPeriodState;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=ManagerApplications.ManagerExecutionsApp.class, path="manage-periods", titleKey="title.execution.periods")
@Mapping(module="manager", path="/manageExecutionPeriods")
@Forwards(value={@Forward(name="Manage", path="/manager/manageExecutionPeriods_bd.jsp"), @Forward(name="EditExecutionPeriod", path="/manager/editExecutionPeriodDates.jsp")})
public class ManageExecutionPeriodsDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ArrayList periods = new ArrayList(Bennu.getInstance().getExecutionPeriodsSet());
        Collections.sort(periods);
        request.setAttribute("periods", periods);
        return mapping.findForward("Manage");
    }

    public ActionForward alterExecutionPeriodState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String year = request.getParameter("year");
        Integer semester = new Integer(request.getParameter("semester"));
        String periodStateToSet = request.getParameter("periodState");
        PeriodState periodState = new PeriodState(periodStateToSet);
        try {
            AlterExecutionPeriodState.run(year, semester, periodState);
        }
        catch (InvalidArgumentsServiceException ex) {
            throw new FenixActionException("errors.nonExisting.executionPeriod", ex);
        }
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String externalId = request.getParameter("executionPeriodID");
        try {
            ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)externalId);
            request.setAttribute("executionPeriod", (Object)executionSemester);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
        }
        return mapping.findForward("EditExecutionPeriod");
    }
}

