/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.externalSupervision.consult;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.externalSupervision.ExternalSupervisionApplication;
import org.fenixedu.academic.ui.struts.action.externalSupervision.consult.ExternalSupervisorViewsBean;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=ExternalSupervisionApplication.ExternalSupervisionConsultApp.class, path="degree", titleKey="label.selectDegree.executionDegree")
@Mapping(path="/viewDegree", module="externalSupervision")
@Forwards(value={@Forward(name="selectDegree", path="/externalSupervision/consult/selectDegree.jsp")})
public class ExternalSupervisorViewDegreeDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward beginTaskFlow(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExternalSupervisorViewsBean bean;
        User userView = Authenticate.getUser();
        Person supervisor = userView.getPerson();
        RegistrationProtocol protocol = supervisor.getOnlyRegistrationProtocol();
        if (protocol == null) {
            bean = new ExternalSupervisorViewsBean(ExecutionYear.readCurrentExecutionYear());
            bean.setMegavisor(true);
            boolean selectProtocol = true;
            request.setAttribute("selectProtocol", (Object)selectProtocol);
        } else {
            bean = new ExternalSupervisorViewsBean(ExecutionYear.readCurrentExecutionYear(), protocol);
        }
        request.setAttribute("sessionBean", (Object)bean);
        return mapping.findForward("selectDegree");
    }

    public ActionForward degreePostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExternalSupervisorViewsBean bean = (ExternalSupervisorViewsBean)this.getRenderedObject("sessionBean");
        if (bean.getMegavisor().booleanValue()) {
            boolean selectProtocol = true;
            request.setAttribute("selectProtocol", (Object)selectProtocol);
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("sessionBean", (Object)bean);
        return mapping.findForward("selectDegree");
    }

    public ActionForward showStudents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExternalSupervisorViewsBean bean = (ExternalSupervisorViewsBean)this.getRenderedObject("sessionBean");
        RenderUtils.invalidateViewState();
        if (bean == null) {
            String registrationProtocolId = request.getParameter("registrationProtocolId");
            RegistrationProtocol registrationProtocol = (RegistrationProtocol)FenixFramework.getDomainObject((String)registrationProtocolId);
            String executionYearId = request.getParameter("executionYearId");
            ExecutionYear executionYear = (ExecutionYear)FenixFramework.getDomainObject((String)executionYearId);
            String executionDegreeId = request.getParameter("executionDegreeId");
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeId);
            Boolean megavisor = Boolean.valueOf(request.getParameter("megavisor"));
            bean = new ExternalSupervisorViewsBean(executionYear, registrationProtocol);
            bean.setExecutionDegree(executionDegree);
            bean.setDegreeType(executionDegree.getDegreeType());
            bean.setMegavisor(megavisor);
        }
        if (bean.getMegavisor().booleanValue()) {
            boolean selectProtocol = true;
            request.setAttribute("selectProtocol", (Object)selectProtocol);
        }
        bean.generateStudentsFromDegree();
        Boolean degreeSelected = true;
        request.setAttribute("sessionBean", (Object)bean);
        request.setAttribute("hasChosenDegree", (Object)degreeSelected);
        return mapping.findForward("selectDegree");
    }

    public ActionForward exportXLS(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ExternalSupervisorViewsBean bean = (ExternalSupervisorViewsBean)this.getRenderedObject("sessionBean");
        Spreadsheet spreadsheet = this.generateSpreadsheet(bean);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + this.getFilename(bean) + ".xls");
        spreadsheet.exportToXLSSheet((OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
        response.flushBuffer();
        return null;
    }

    private String getFilename(ExternalSupervisorViewsBean bean) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.students.lowercase", (String[])new String[0]));
        strBuilder.append("_");
        strBuilder.append(bean.getProtocol().getCode());
        strBuilder.append("_");
        strBuilder.append(bean.getExecutionDegree().getDegree().getSigla());
        strBuilder.append("_");
        strBuilder.append(bean.getExecutionYear().getName());
        return strBuilder.toString();
    }

    private Spreadsheet generateSpreadsheet(ExternalSupervisorViewsBean bean) {
        Spreadsheet spreadsheet = this.createSpreadSheet();
        for (StudentCurricularPlan studentCurricularPlan : bean.generateAllStudentCurricularPlans()) {
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(studentCurricularPlan.getPerson().getUsername());
            row.setCell(studentCurricularPlan.getRegistration().getNumber());
            row.setCell(studentCurricularPlan.getPerson().getName());
            row.setCell(studentCurricularPlan.getPerson().getInstitutionalOrDefaultEmailAddressValue());
            row.setCell(studentCurricularPlan.getPerson().getIdDocumentType().getLocalizedName());
            row.setCell(studentCurricularPlan.getPerson().getDocumentIdNumber());
            row.setCell(studentCurricularPlan.getDegree().getSigla());
            row.setCell(studentCurricularPlan.getName());
            row.setCell(studentCurricularPlan.getStartDateYearMonthDay().toString());
            row.setCell(studentCurricularPlan.getEndDate() == null ? "" : studentCurricularPlan.getEndDate().toString());
            row.setCell(studentCurricularPlan.getRegistration().getActiveStateType().getDescription());
            row.setCell(Integer.valueOf(studentCurricularPlan.getRegistration().getNumberOfCurriculumEntries()));
            row.setCell(Double.valueOf(studentCurricularPlan.getRegistration().getEctsCredits()));
            row.setCell(this.getAverageInformation(studentCurricularPlan));
            row.setCell(Integer.valueOf(studentCurricularPlan.getRegistration().getCurricularYear()));
        }
        return spreadsheet;
    }

    private String getAverageInformation(StudentCurricularPlan studentCurricularPlan) {
        Registration registration = studentCurricularPlan.getRegistration();
        if (registration.isConcluded()) {
            if (registration.isRegistrationConclusionProcessed() && (!registration.isBolonha() || studentCurricularPlan.getInternalCycleCurriculumGroupsSize() == 1)) {
                return registration.getRawGrade().getValue();
            }
            return " - ";
        }
        return registration.getRawGrade().getValue();
    }

    private Spreadsheet createSpreadSheet() {
        Spreadsheet spreadsheet = new Spreadsheet(BundleUtil.getString((String)"resources.ApplicationResources", (String)"list.students", (String[])new String[0]));
        spreadsheet.setHeaders(new String[]{BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.username", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.number", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.name", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.email", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.identificationDocumentType", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.identificationDocumentNumber", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.Degree", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curricularPlan", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.org.fenixedu.academic.domain.student.Registration.startDate", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.org.fenixedu.academic.domain.student.Registration.conclusionDate", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.student.curricular.plan.state", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.number.approved.curricular.courses", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.ects", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.average", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.student.curricular.year", (String[])new String[0]), " ", " "});
        return spreadsheet;
    }
}

