/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidacy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCodeOperations;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessWithPrecedentDegreeInformationBean;
import org.fenixedu.academic.domain.candidacyProcess.PrecedentDegreeInformationBeanFactory;
import org.fenixedu.academic.domain.candidacyProcess.exceptions.HashCodeForEmailAndProcessAlreadyBounded;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.period.CandidacyPeriod;
import org.fenixedu.academic.domain.period.CandidacyProcessCandidacyPeriod;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.academic.dto.person.ChoosePersonBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.service.services.caseHandling.CreateNewProcess;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.casehandling.CaseHandlingDispatchAction;
import org.fenixedu.bennu.core.domain.exceptions.BennuCoreDomainException;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.LifeCycleConstants;
import pt.ist.fenixWebFramework.renderers.plugin.RenderersRequestProcessorImpl;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Forward(name="prepare-move-process", path="/candidacy/moveCandidacy.jsp")
public abstract class IndividualCandidacyProcessDA
extends CaseHandlingDispatchAction {
    protected abstract Class<? extends Process> getParentProcessType();

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setParentProcess(request);
        request.setAttribute("sibsEntityCode", (Object)FenixEduAcademicConfiguration.getConfiguration().getSibsEntityCode());
        return super.execute(mapping, actionForm, request, response);
    }

    protected void setParentProcess(HttpServletRequest request) {
        String parentProcessId = (String)this.getFromRequest(request, "parentProcessId");
        if (parentProcessId != null) {
            request.setAttribute("parentProcess", (Object)FenixFramework.getDomainObject((String)parentProcessId));
        } else {
            this.setProcess(request);
            if (this.hasProcess(request)) {
                request.setAttribute("parentProcess", (Object)this.getProcess(request).getCandidacyProcess());
            }
        }
    }

    protected CandidacyProcess getParentProcess(HttpServletRequest request) {
        return (CandidacyProcess)((Object)request.getAttribute("parentProcess"));
    }

    protected boolean hasParentProcess(HttpServletRequest request) {
        return this.getParentProcess(request) != null;
    }

    @Override
    public ActionForward listProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setMainCandidacyProcessInformation(request, this.getParentProcess(request));
        return mapping.findForward("intro");
    }

    public ActionForward prepareExecuteMoveCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setMainCandidacyProcessInformation(request, this.getParentProcess(request));
        Over23IndividualCandidacyProcessBean bean = new Over23IndividualCandidacyProcessBean();
        ExecutionInterval executionInterval = this.getParentProcess(request).getCandidacyPeriod().getExecutionInterval();
        CandidacyProcessCandidacyPeriod candidacyPeriod = this.getParentProcess(request).getCandidacyPeriod();
        List<? extends CandidacyPeriod> cpp = executionInterval.getCandidacyPeriods(((Object)((Object)candidacyPeriod)).getClass());
        request.setAttribute("individualProcess", (Object)this.readProcess(request));
        request.setAttribute("processes", cpp.stream().map(cp -> (CandidacyProcessCandidacyPeriod)((Object)((Object)cp))).flatMap(cp -> cp.getCandidacyProcessesSet().stream()).collect(Collectors.toList()));
        request.setAttribute("candidacyProcess", (Object)this.getParentProcess(request));
        return mapping.findForward("prepare-move-process");
    }

    public ActionForward executeMoveCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            String parentProcessExternalId = request.getParameter("newParentProcess");
            CandidacyProcess newParentProcess = (CandidacyProcess)FenixFramework.getDomainObject((String)parentProcessExternalId);
            this.executeActivity((Process)((Object)this.getProcess(request)), "MoveCandidacy", (Object)newParentProcess);
            request.setAttribute("parentProcess", (Object)newParentProcess);
        }
        catch (DomainException e) {
            // empty catch block
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    protected IndividualCandidacyProcess getProcess(HttpServletRequest request) {
        return (IndividualCandidacyProcess)((Object)super.getProcess(request));
    }

    protected void setMainCandidacyProcessInformation(HttpServletRequest request, CandidacyProcess process2) {
        request.setAttribute("process", (Object)process2);
        request.setAttribute("processName", (Object)this.getParentProcessType().getSimpleName());
        request.setAttribute("canCreateProcess", this.canCreateProcess(this.getParentProcessType().getName()));
        request.setAttribute("processActivities", (Object)process2.getAllowedActivities(Authenticate.getUser()));
        request.setAttribute("canCreateChildProcess", this.canCreateProcess(this.getProcessType().getName()));
        request.setAttribute("childProcessName", (Object)this.getProcessType().getSimpleName());
        request.setAttribute("childProcesses", (Object)process2.getChildProcessesSet());
        request.setAttribute("executionIntervalId", (Object)process2.getCandidacyExecutionInterval().getExternalId());
        request.setAttribute("executionIntervals", ExecutionInterval.readExecutionIntervalsWithCandidacyPeriod(((Object)((Object)process2.getCandidacyPeriod())).getClass()));
    }

    protected List<Activity> getAllowedActivities(IndividualCandidacyProcess process2) {
        List activities = process2.getAllowedActivities(Authenticate.getUser());
        ArrayList<Activity> resultActivities = new ArrayList<Activity>();
        for (Activity activity : activities) {
            if (!activity.isVisibleForAdminOffice().booleanValue()) continue;
            resultActivities.add(activity);
        }
        return resultActivities;
    }

    protected String getIndividualCandidacyProcessBeanName() {
        return "individualCandidacyProcessBean";
    }

    protected IndividualCandidacyProcessBean getIndividualCandidacyProcessBean() {
        return (IndividualCandidacyProcessBean)this.getRenderedObject(this.getIndividualCandidacyProcessBeanName());
    }

    @Override
    public ActionForward prepareCreateNewProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (!this.hasParentProcess(request)) {
            this.addActionMessage(request, "error.IndividualCandidacy.invalid.candidacyProcess");
            return this.listProcesses(mapping, form, request, response);
        }
        this.setStartInformation(form, request, response);
        return mapping.findForward("prepare-create-new-process");
    }

    protected abstract void setStartInformation(ActionForm var1, HttpServletRequest var2, HttpServletResponse var3);

    public ActionForward prepareCreateNewProcessInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("prepare-create-new-process");
    }

    public ActionForward searchPersonForCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        ChoosePersonBean choosePersonBean = bean.getChoosePersonBean();
        if (!choosePersonBean.hasPerson()) {
            if (choosePersonBean.isFirstTimeSearch()) {
                Collection<Person> persons = Person.findPersonByDocumentID(choosePersonBean.getIdentificationNumber());
                choosePersonBean.setFirstTimeSearch(false);
                if (this.showSimilarPersons(choosePersonBean, persons)) {
                    RenderUtils.invalidateViewState();
                    return mapping.findForward("prepare-create-new-process");
                }
            }
            bean.setPersonBean(new PersonBean(choosePersonBean.getName(), choosePersonBean.getIdentificationNumber(), choosePersonBean.getDocumentType(), choosePersonBean.getDateOfBirth()));
            return mapping.findForward("fill-personal-information");
        }
        bean.setPersonBean(new PersonBean(bean.getChoosePersonBean().getPerson()));
        return mapping.findForward("fill-personal-information");
    }

    protected boolean showSimilarPersons(ChoosePersonBean choosePersonBean, Collection<Person> persons) {
        if (!persons.isEmpty()) {
            return true;
        }
        return !Person.findByDateOfBirth(choosePersonBean.getDateOfBirth(), Person.findPersonMatchingFirstAndLastName(choosePersonBean.getName())).isEmpty();
    }

    public ActionForward searchAgainPersonForCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        bean.getChoosePersonBean().setFirstTimeSearch(true);
        bean.getChoosePersonBean().setPerson(null);
        RenderUtils.invalidateViewState();
        return mapping.findForward("prepare-create-new-process");
    }

    public ActionForward selectPersonForCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        if (!bean.hasChoosenPerson()) {
            this.addActionMessage(request, "error.candidacy.must.select.any.person");
            return mapping.findForward("prepare-create-new-process");
        }
        if (this.existsIndividualCandidacyProcessForDocumentId(request, bean.getChoosePersonBean().getPerson().getIdDocumentType(), bean.getChoosePersonBean().getPerson().getDocumentIdNumber())) {
            this.addActionMessage(request, "error.candidacy.already.exists.for.this.person");
            return mapping.findForward("prepare-create-new-process");
        }
        bean.setPersonBean(new PersonBean(bean.getChoosePersonBean().getPerson()));
        bean.setChoosePersonBean(null);
        return mapping.findForward("fill-personal-information");
    }

    public ActionForward fillPersonalInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        ChoosePersonBean choosePersonBean = bean.getChoosePersonBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        bean.setPersonBean(new PersonBean(choosePersonBean.getName(), choosePersonBean.getIdentificationNumber(), choosePersonBean.getDocumentType(), choosePersonBean.getDateOfBirth()));
        bean.setChoosePersonBean(null);
        return mapping.findForward("fill-personal-information");
    }

    public ActionForward fillPersonalInformationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("fill-personal-information");
    }

    public ActionForward fillCommonCandidacyInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        return mapping.findForward("fill-common-candidacy-information");
    }

    public ActionForward fillCommonCandidacyInformationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("fill-common-candidacy-information");
    }

    public ActionForward fillCandidacyInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Party existingSocialSecurityNumberParty;
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        if (!StringUtils.isEmpty((String)bean.getPersonBean().getSocialSecurityNumber()) && (existingSocialSecurityNumberParty = Person.readByContributorNumber((String)bean.getPersonBean().getSocialSecurityNumber())) != null && existingSocialSecurityNumberParty != bean.getPersonBean().getPerson()) {
            this.addActionMessage(request, "error.party.existing.contributor.number");
            return mapping.findForward("fill-personal-information");
        }
        try {
            DegreeOfficePublicCandidacyHashCode candidacyHashCode = DegreeOfficePublicCandidacyHashCodeOperations.getUnusedOrCreateNewHashCode(this.getProcessType(), this.getParentProcess(request), bean.getPersonBean().getEmail());
            bean.setPublicCandidacyHashCode(candidacyHashCode);
        }
        catch (HashCodeForEmailAndProcessAlreadyBounded e) {
            this.addActionMessage(request, "error.candidacy.hash.code.already.bounded");
            return mapping.findForward("fill-personal-information");
        }
        return mapping.findForward("fill-candidacy-information");
    }

    public ActionForward fillCandidacyInformationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("fill-candidacy-information");
    }

    public ActionForward fillPrecedentInformationPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessWithPrecedentDegreeInformationBean bean = (IndividualCandidacyProcessWithPrecedentDegreeInformationBean)this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        RenderUtils.invalidateViewState();
        if (bean.hasPrecedentDegreeType()) {
            if (bean.isExternalPrecedentDegreeType()) {
                bean.setPrecedentDegreeInformation(new PrecedentDegreeInformationBean());
            } else if (bean.hasPrecedentStudentCurricularPlan()) {
                this.createCandidacyPrecedentDegreeInformation(bean, bean.getPrecedentStudentCurricularPlan());
            } else {
                List<StudentCurricularPlan> scps = bean.getPrecedentStudentCurricularPlans();
                if (scps.size() == 1) {
                    this.createCandidacyPrecedentDegreeInformation(bean, scps.iterator().next());
                    bean.setPrecedentStudentCurricularPlan(scps.iterator().next());
                }
            }
        }
        return mapping.findForward("fill-candidacy-information");
    }

    protected void createCandidacyPrecedentDegreeInformation(IndividualCandidacyProcessWithPrecedentDegreeInformationBean bean, StudentCurricularPlan studentCurricularPlan) {
        if (studentCurricularPlan.isBolonhaDegree()) {
            CycleType cycleType = studentCurricularPlan.hasConcludedAnyInternalCycle() ? studentCurricularPlan.getLastConcludedCycleCurriculumGroup().getCycleType() : studentCurricularPlan.getLastOrderedCycleCurriculumGroup().getCycleType();
            bean.setPrecedentDegreeInformation(PrecedentDegreeInformationBeanFactory.createBean(studentCurricularPlan, cycleType));
        } else {
            bean.setPrecedentDegreeInformation(PrecedentDegreeInformationBeanFactory.createBean(studentCurricularPlan));
        }
    }

    public ActionForward fillPrecedentInformationStudentCurricularPlanPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessWithPrecedentDegreeInformationBean bean = (IndividualCandidacyProcessWithPrecedentDegreeInformationBean)this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        if (bean.hasPrecedentStudentCurricularPlan()) {
            this.createCandidacyPrecedentDegreeInformation(bean, bean.getPrecedentStudentCurricularPlan());
        }
        RenderUtils.invalidateViewState();
        return mapping.findForward("fill-candidacy-information");
    }

    @Override
    public ActionForward createNewProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            request.setAttribute("process", (Object)CreateNewProcess.run(this.getProcessType().getName(), (Object)this.getIndividualCandidacyProcessBean()));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("fill-candidacy-information");
        }
        return this.listProcessAllowedActivities(mapping, form, request, response);
    }

    public ActionForward prepareExecuteCandidacyPayment(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (!this.getProcess(request).isCandidacyInternal().booleanValue()) {
            return this.prepareExecuteBindPersonToCandidacy(mapping, actionForm, request, response);
        }
        return mapping.findForward("prepare-candidacy-payment");
    }

    public ActionForward prepareExecuteCancelCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("cancel-candidacy");
    }

    public ActionForward executeCancelCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "CancelCandidacy", null);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return mapping.findForward("cancel-candidacy");
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward prepareExecuteEditDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcess process2 = this.getProcess(request);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)process2);
        CandidacyProcessDocumentUploadBean uploadBean = new CandidacyProcessDocumentUploadBean();
        uploadBean.setIndividualCandidacyProcess(process2);
        request.setAttribute("candidacyDocumentUploadBean", (Object)uploadBean);
        RenderUtils.invalidateViewState((String)"individualCandidacyProcessBean.document");
        return mapping.findForward("prepare-edit-candidacy-documents");
    }

    public ActionForward uploadDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException, IOException {
        CandidacyProcessDocumentUploadBean uploadBean = (CandidacyProcessDocumentUploadBean)this.getObjectFromViewState("individualCandidacyProcessBean.document");
        try {
            IndividualCandidacyDocumentFile documentFile = this.createIndividualCandidacyDocumentFile(uploadBean, uploadBean.getIndividualCandidacyProcess().getPersonalDetails().getDocumentIdNumber());
            uploadBean.setDocumentFile(documentFile);
            this.executeActivity((Process)((Object)this.getProcess(request)), "EditDocuments", uploadBean);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
        }
        return this.prepareExecuteEditDocuments(mapping, actionForm, request, response);
    }

    @Override
    public ActionForward listProcessAllowedActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcess process2 = this.getProcess(request);
        request.setAttribute("activities", this.getAllowedActivities(process2));
        return mapping.findForward("list-allowed-activities");
    }

    protected boolean hasInvalidViewState() {
        List viewStates = (List)RenderersRequestProcessorImpl.getCurrentRequest().getAttribute(LifeCycleConstants.VIEWSTATE_PARAM_NAME);
        boolean valid = true;
        if (viewStates != null) {
            for (IViewState state : viewStates) {
                valid &= state.isValid();
            }
        }
        return valid;
    }

    protected abstract void prepareInformationForBindPersonToCandidacyOperation(HttpServletRequest var1, IndividualCandidacyProcess var2);

    public ActionForward prepareExecuteBindPersonToCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcess individualCandidacyProcess = this.getProcess(request);
        this.prepareInformationForBindPersonToCandidacyOperation(request, individualCandidacyProcess);
        this.setProcess(request);
        return mapping.findForward("select-person-for-bind-with-candidacy");
    }

    public ActionForward prepareEditPersonalInformationForBindWithSelectedPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        if (bean.getChoosePersonBean().getPerson() == null) {
            this.addActionMessage(request, "error.candidacy.select.person.for.bind");
            return mapping.findForward("select-person-for-bind-with-candidacy");
        }
        return mapping.findForward("edit-personal-information-for-bind");
    }

    public ActionForward prepareEditPersonalInformationForBindWithNewPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("edit-personal-information-for-bind");
    }

    public ActionForward executeEditCandidacyPersonalInformationForBindInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("edit-personal-information-for-bind");
    }

    public ActionForward bindPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "BindPersonToCandidacy", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("edit-personal-information-for-bind");
        }
        catch (BennuCoreDomainException be) {
            this.addActionMessage(request, be.getLocalizedMessage(), false);
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("edit-personal-information-for-bind");
        }
        return this.prepareExecuteCandidacyPayment(mapping, actionForm, request, response);
    }

    protected IndividualCandidacyDocumentFile createIndividualCandidacyDocumentFile(CandidacyProcessDocumentUploadBean uploadBean, String documentIdNumber) throws IOException {
        return uploadBean.createIndividualCandidacyDocumentFile(this.getParentProcessType(), documentIdNumber);
    }

    public ActionForward executeChangeProcessCheckedState(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "ChangeProcessCheckedState", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("change-process-checked-state");
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward executeChangePaymentCheckedState(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "ChangePaymentCheckedState", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("change-payment-checked-state");
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward prepareExecuteRevertApplicationToStandBy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "RevertApplicationToStandBy", null);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.listProcessAllowedActivities(mapping, actionForm, request, response);
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    protected void invalidateDocumentFileRelatedViewStates() {
        ArrayList viewStates = new ArrayList((List)RenderersRequestProcessorImpl.getCurrentRequest().getAttribute(LifeCycleConstants.VIEWSTATE_PARAM_NAME));
        if (viewStates != null) {
            for (IViewState state : viewStates) {
                if (state.getId().indexOf("individualCandidacyProcessBean.document.file") <= -1) continue;
                RenderUtils.invalidateViewState((String)state.getId());
            }
        }
    }

    protected boolean existsIndividualCandidacyProcessForDocumentId(HttpServletRequest request, IDDocumentType documentType, String identification) {
        return this.getParentProcess(request).getOpenChildProcessByDocumentId(documentType, identification) != null;
    }

    public ActionForward addConcludedHabilitationsEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        bean.addConcludedFormationBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        this.invalidateDocumentFileRelatedViewStates();
        return this.forwardTo(mapping, request);
    }

    public ActionForward removeConcludedHabilitationsEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        Integer index = this.getIntegerFromRequest(request, "removeIndex");
        bean.removeFormationConcludedBean(index);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        this.invalidateDocumentFileRelatedViewStates();
        return this.forwardTo(mapping, request);
    }

    private ActionForward forwardTo(ActionMapping mapping, HttpServletRequest request) {
        if (this.getFromRequest(request, "userAction").equals("createCandidacy")) {
            return mapping.findForward("fill-candidacy-information");
        }
        if (this.getFromRequest(request, "userAction").equals("editCandidacyQualifications")) {
            return mapping.findForward("edit-candidacy-information");
        }
        return null;
    }

    public ActionForward revokeDocumentFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CandidacyProcessDocumentUploadBean uploadBean = (CandidacyProcessDocumentUploadBean)this.getObjectFromViewState("individualCandidacyProcessBean.document");
        String documentExternalId = request.getParameter("documentFileOid");
        IndividualCandidacyDocumentFile documentFile = (IndividualCandidacyDocumentFile)FenixFramework.getDomainObject((String)documentExternalId);
        uploadBean.setDocumentFile(documentFile);
        this.executeActivity((Process)((Object)this.getProcess(request)), "RevokeDocumentFile", uploadBean);
        return this.prepareExecuteEditDocuments(mapping, form, request, response);
    }

    public ActionForward prepareExecuteRejectCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
        return mapping.findForward("reject-candidacy");
    }

    public ActionForward executeRejectCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "RejectCandidacy", null);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return mapping.findForward("reject-candidacy");
        }
        return this.listProcessAllowedActivities(mapping, form, request, response);
    }
}

