/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetEnrolmentEvaluationBean;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetManagementCreateBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.MarkSheetDispatchAction;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.MarkSheetSearchDispatchAction;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/createMarkSheet", module="academicAdministration", formBean="markSheetManagementForm", input="/gradeSubmission/createMarkSheetStep1.jsp", functionality=MarkSheetSearchDispatchAction.class)
@Forwards(value={@Forward(name="createMarkSheetStep1", path="/academicAdministration/gradeSubmission/createMarkSheetStep1.jsp"), @Forward(name="createMarkSheetStep2", path="/academicAdministration/gradeSubmission/createMarkSheetStep2.jsp"), @Forward(name="searchMarkSheetFilled", path="/academicAdministration/markSheetManagement.do?method=prepareSearchMarkSheetFilled"), @Forward(name="rectifyMarkSheetStep1", path="/academicAdministration/gradeSubmission/rectifyMarkSheetStep1.jsp"), @Forward(name="rectifyMarkSheetStep2", path="/academicAdministration/gradeSubmission/rectifyMarkSheetStep2.jsp"), @Forward(name="viewMarkSheet", path="/academicAdministration/gradeSubmission/viewMarkSheet.jsp")})
public class MarkSheetCreateDispatchAction
extends MarkSheetDispatchAction {
    public ActionForward prepareCreateMarkSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetManagementCreateBean markSheetManagementCreateBean = new MarkSheetManagementCreateBean();
        markSheetManagementCreateBean.setExecutionPeriod(ExecutionSemester.readActualExecutionSemester());
        markSheetManagementCreateBean.setUrl("");
        request.setAttribute("edit", (Object)markSheetManagementCreateBean);
        return mapping.findForward("createMarkSheetStep1");
    }

    public ActionForward prepareCreateMarkSheetFilled(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetManagementCreateBean markSheetManagementCreateBean = new MarkSheetManagementCreateBean();
        this.fillMarkSheetBean(actionForm, request, markSheetManagementCreateBean);
        markSheetManagementCreateBean.setUrl(this.buildUrl((DynaActionForm)actionForm));
        request.setAttribute("edit", (Object)markSheetManagementCreateBean);
        return mapping.findForward("createMarkSheetStep1");
    }

    public ActionForward createMarkSheetStepOne(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetManagementCreateBean createBean = (MarkSheetManagementCreateBean)RenderUtils.getViewState().getMetaObject().getObject();
        request.setAttribute("edit", (Object)createBean);
        Teacher teacher = Teacher.readByIstId(createBean.getTeacherId());
        createBean.setTeacher(teacher);
        ActionMessages actionMessages = this.createActionMessages();
        this.checkIfTeacherIsResponsibleOrCoordinator(createBean.getCurricularCourse(), createBean.getExecutionPeriod(), createBean.getTeacherId(), teacher, request, createBean.getEvaluationSeason(), actionMessages);
        if (!actionMessages.isEmpty()) {
            createBean.setTeacherId(null);
        }
        this.checkIfEvaluationDateIsInExamsPeriod(createBean.getDegreeCurricularPlan(), createBean.getExecutionPeriod(), createBean.getEvaluationDate(), createBean.getEvaluationSeason(), request, actionMessages);
        this.prepareCreateEnrolmentEvaluationsForMarkSheet(createBean, request, actionMessages);
        if (!actionMessages.isEmpty()) {
            return mapping.findForward("createMarkSheetStep1");
        }
        return mapping.findForward("createMarkSheetStep2");
    }

    protected void prepareCreateEnrolmentEvaluationsForMarkSheet(MarkSheetManagementCreateBean createBean, HttpServletRequest request, ActionMessages actionMessages) {
        Set<Enrolment> enrolments = createBean.getCurricularCourse().getEnrolmentsNotInAnyMarkSheet(createBean.getEvaluationSeason(), createBean.getExecutionPeriod());
        if (enrolments.isEmpty()) {
            this.addMessage(request, actionMessages, "error.allStudentsAreInMarkSheets", new String[0]);
        } else {
            HashSet<MarkSheetEnrolmentEvaluationBean> impossibleEnrolmentEvaluationBeans = new HashSet<MarkSheetEnrolmentEvaluationBean>();
            HashSet<MarkSheetEnrolmentEvaluationBean> enrolmentEvaluationBeans = new HashSet<MarkSheetEnrolmentEvaluationBean>();
            for (Enrolment enrolment : enrolments) {
                MarkSheetEnrolmentEvaluationBean markSheetEnrolmentEvaluationBean = new MarkSheetEnrolmentEvaluationBean();
                markSheetEnrolmentEvaluationBean.setEnrolment(enrolment);
                markSheetEnrolmentEvaluationBean.setEvaluationDate(createBean.getEvaluationDate());
                if (enrolment.isImpossible()) {
                    impossibleEnrolmentEvaluationBeans.add(markSheetEnrolmentEvaluationBean);
                    continue;
                }
                enrolmentEvaluationBeans.add(markSheetEnrolmentEvaluationBean);
            }
            createBean.setEnrolmentEvaluationBeans(enrolmentEvaluationBeans);
            createBean.setImpossibleEnrolmentEvaluationBeans(impossibleEnrolmentEvaluationBeans);
        }
    }

    public ActionForward createMarkSheetStepTwo(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        MarkSheetManagementCreateBean createBean = (MarkSheetManagementCreateBean)RenderUtils.getViewState((String)"edit-invisible").getMetaObject().getObject();
        createBean.setTeacher(Teacher.readByIstId(createBean.getTeacherId()));
        ActionMessages actionMessages = this.createActionMessages();
        User userView = MarkSheetCreateDispatchAction.getUserView(request);
        try {
            MarkSheet markSheet = this.createMarkSheet(createBean, userView);
            ((DynaActionForm)actionForm).set("msID", (Object)markSheet.getExternalId());
            return this.viewMarkSheet(mapping, actionForm, request, response);
        }
        catch (IllegalDataAccessException e) {
            this.addMessage(request, actionMessages, "error.notAuthorized", new String[0]);
        }
        catch (DomainException e) {
            this.addMessage(request, actionMessages, e.getMessage(), e.getArgs());
        }
        request.setAttribute("edit", (Object)createBean);
        return mapping.findForward("createMarkSheetStep2");
    }

    public ActionForward createMarkSheetStepTwoInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        request.setAttribute("edit", RenderUtils.getViewState((String)"edit-invisible").getMetaObject().getObject());
        return mapping.findForward("createMarkSheetStep2");
    }

    public ActionForward prepareSearchMarkSheetFilled(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("searchMarkSheetFilled");
    }

    protected MarkSheet createMarkSheet(MarkSheetManagementCreateBean createBean, User userView) {
        return createBean.createMarkSheet(userView.getPerson());
    }
}

