/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.accounts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactValidation;
import org.fenixedu.academic.domain.contacts.PartyContactValidationState;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.dto.contacts.PartyContactBean;
import org.fenixedu.academic.service.services.contacts.CreatePartyContact;
import org.fenixedu.academic.service.services.contacts.EditPartyContact;
import org.fenixedu.academic.ui.struts.action.accounts.ManageAccountsDA;
import org.fenixedu.academic.ui.struts.action.person.PartyContactsManagementDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/accounts/partyContacts", functionality=ManageAccountsDA.class)
@Forwards(value={@Forward(name="visualizePersonalInformation", path="/accounts/viewPerson.jsp"), @Forward(name="editPartyContact", path="/accounts/editPartyContact.jsp"), @Forward(name="createPartyContact", path="/accounts/createPartyContact.jsp")})
public class PartyContactsManagementForAccountManagerDA
extends PartyContactsManagementDispatchAction {
    @Override
    protected Party getParty(HttpServletRequest request) {
        String personID = (String)this.getFromRequest(request, "personID");
        return (Party)FenixFramework.getDomainObject((String)personID);
    }

    @Override
    public ActionForward forwardToInputValidationCode(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, PartyContact partyContact) {
        request.setAttribute("personID", (Object)partyContact.getParty().getExternalId());
        return this.backToShowInformation(mapping, actionForm, request, response);
    }

    @Override
    public ActionForward backToShowInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("person", (Object)this.getParty(request));
        return mapping.findForward("visualizePersonalInformation");
    }

    @Override
    public boolean editContact(PartyContactBean contact) {
        return EditPartyContact.run(contact, false);
    }

    @Override
    public PartyContact createContact(PartyContactBean contact) {
        return CreatePartyContact.run(contact, false);
    }

    @Override
    protected void addWarningMessage(HttpServletRequest request, PartyContact partyContact) {
    }

    @Override
    protected void addWarningMessage(HttpServletRequest request, PartyContactBean contactBean) {
    }

    public ActionForward validate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String partyContactValidationExtId = (String)this.getFromRequest(request, "partyContactValidation");
        PartyContactValidation partyContactValidation = (PartyContactValidation)FenixFramework.getDomainObject((String)partyContactValidationExtId);
        partyContactValidation.setState(PartyContactValidationState.VALID);
        request.setAttribute("personID", (Object)partyContactValidation.getPartyContact().getParty().getExternalId());
        return this.backToShowInformation(mapping, actionForm, request, response);
    }

    public ActionForward resetValidationRequests(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String personID = (String)this.getFromRequest(request, "personID");
        Person person = (Person)FenixFramework.getDomainObject((String)personID);
        if (person != null) {
            person.setNumberOfValidationRequests(0);
        }
        return this.backToShowInformation(mapping, actionForm, request, response);
    }
}

