/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.student.equivalencies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.CurricularCourseEquivalence;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.InfoCurricularCourse;
import org.fenixedu.academic.dto.InfoDegreeCurricularPlan;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.CreateCurricularCourseEquivalency;
import org.fenixedu.academic.service.services.manager.DeleteCurricularCourseEquivalency;
import org.fenixedu.academic.service.services.manager.ReadCurricularCoursesByDegreeCurricularPlan;
import org.fenixedu.academic.service.services.manager.ReadDegreeCurricularPlansByDegree;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.config.FenixErrorExceptionHandler;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Exceptions;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminEquivalencesApp.class, path="curricular-course-equivalences", titleKey="label.studentDismissal.equivalences", accessGroup="academic(MANAGE_EQUIVALENCES)")
@Mapping(module="academicAdministration", path="/curricularCourseEquivalencies", input="/curricularCourseEquivalencies.do?method=prepare&page=0", formBean="curricularCourseEquivalenciesForm")
@Forwards(value={@Forward(name="showEquivalencies", path="/academicAdministration/equivalences/curricularCourseEquivalencies.jsp"), @Forward(name="showCreateEquivalencyForm", path="/academicAdministration/equivalences/createCurricularCourseEquivalencies.jsp")})
@Exceptions(value={@ExceptionHandling(type=DomainException.class, key="error.exists.curricular.course.equivalency", handler=FenixErrorExceptionHandler.class, scope="request")})
public class CurricularCourseEquivalenciesDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User userView = Authenticate.getUser();
        DynaActionForm actionForm = (DynaActionForm)form;
        this.setInfoDegreesToManage(request, userView);
        String degreeIDString = (String)actionForm.get("degreeID");
        if (this.isValidObjectID(degreeIDString)) {
            this.setInfoDegreeCurricularPlans(request, userView, degreeIDString, "infoDegreeCurricularPlans");
            String degreeCurricularPlanIDString = (String)actionForm.get("degreeCurricularPlanID");
            if (this.isValidObjectID(degreeCurricularPlanIDString)) {
                DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanIDString);
                ArrayList<CurricularCourseEquivalence> equivalences = new ArrayList<CurricularCourseEquivalence>(degreeCurricularPlan.getCurricularCourseEquivalencesSet());
                this.sortInfoCurricularCourseEquivalences(equivalences);
                request.setAttribute("curricularCourseEquivalences", equivalences);
            }
        }
        return mapping.findForward("showEquivalencies");
    }

    public ActionForward prepareCreate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User userView = Authenticate.getUser();
        DynaActionForm actionForm = (DynaActionForm)form;
        String degreeCurricularPlanIDString = (String)actionForm.get("degreeCurricularPlanID");
        if (this.isValidObjectID(degreeCurricularPlanIDString)) {
            String oldDegreeCurricularPlanIDString;
            this.setInfoDegreesToAdd(request, userView);
            String degreeIDString = (String)actionForm.get("degreeID");
            if (this.isValidObjectID(degreeIDString)) {
                this.setInfoDegreeCurricularPlans(request, userView, degreeIDString, "infoDegreeCurricularPlans");
            }
            this.setInfoCurricularCourses(request, userView, degreeCurricularPlanIDString, "infoCurricularCourses");
            String oldDegreeIDString = (String)actionForm.get("oldDegreeID");
            if (this.isValidObjectID(oldDegreeIDString)) {
                this.setInfoDegreeCurricularPlans(request, userView, oldDegreeIDString, "oldInfoDegreeCurricularPlans");
            }
            if (this.isValidObjectID(oldDegreeCurricularPlanIDString = (String)actionForm.get("oldDegreeCurricularPlanID"))) {
                this.setInfoCurricularCourses(request, userView, oldDegreeCurricularPlanIDString, "oldInfoCurricularCourses");
            }
            return mapping.findForward("showCreateEquivalencyForm");
        }
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm actionForm = (DynaActionForm)form;
        String degreeCurricularPlanIDString = (String)actionForm.get("degreeCurricularPlanID");
        String curricularCourseIDString = (String)actionForm.get("curricularCourseID");
        String oldCurricularCourseIDString = (String)actionForm.get("oldCurricularCourseID");
        if (this.isValidObjectID(degreeCurricularPlanIDString) && this.isValidObjectID(curricularCourseIDString) && this.isValidObjectID(oldCurricularCourseIDString)) {
            try {
                CreateCurricularCourseEquivalency.run(degreeCurricularPlanIDString, curricularCourseIDString, oldCurricularCourseIDString);
            }
            catch (DomainException e) {
                this.addActionMessage(request, e.getMessage());
            }
        }
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm actionForm = (DynaActionForm)form;
        String curricularCourseEquivalencyIDString = (String)actionForm.get("curricularCourseEquivalencyID");
        if (this.isValidObjectID(curricularCourseEquivalencyIDString)) {
            try {
                DeleteCurricularCourseEquivalency.run(curricularCourseEquivalencyIDString);
            }
            catch (DomainException e) {
                this.addActionMessage(request, e.getMessage());
            }
        }
        return this.prepare(mapping, form, request, response);
    }

    private void setInfoDegreesToManage(HttpServletRequest request, User userView) throws FenixServiceException {
        TreeSet<Degree> degrees = new TreeSet<Degree>(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        degrees.addAll(AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.MANAGE_EQUIVALENCES, Authenticate.getUser()).collect(Collectors.toSet()));
        request.setAttribute("infoDegrees", degrees);
    }

    private void setInfoDegreesToAdd(HttpServletRequest request, User userView) throws FenixServiceException {
        TreeSet<Degree> degrees = new TreeSet<Degree>(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        degrees.addAll(Degree.readAllMatching(DegreeType::isPreBolonhaDegree));
        degrees.addAll(Degree.readAllMatching(DegreeType::isBolonhaDegree));
        degrees.addAll(Degree.readAllMatching(DegreeType::isIntegratedMasterDegree));
        degrees.addAll(Degree.readAllMatching(DegreeType::isBolonhaMasterDegree));
        degrees.addAll(Degree.readAllMatching(DegreeType::isAdvancedFormationDiploma));
        request.setAttribute("infoDegrees", degrees);
    }

    private void setInfoDegreeCurricularPlans(HttpServletRequest request, User userView, String degreeID, String attributeName) throws FenixServiceException {
        List infoDegreeCurricularPlans = ReadDegreeCurricularPlansByDegree.run(degreeID);
        this.sortInfoDegreeCurricularPlans(infoDegreeCurricularPlans);
        request.setAttribute(attributeName, (Object)infoDegreeCurricularPlans);
    }

    private void setInfoCurricularCourses(HttpServletRequest request, User userView, String degreeCurricularPlanID, String attribute) throws FenixServiceException {
        List infoCurricularCourses = ReadCurricularCoursesByDegreeCurricularPlan.run(degreeCurricularPlanID);
        this.sortInfoCurricularCourses(infoCurricularCourses);
        request.setAttribute(attribute, (Object)infoCurricularCourses);
    }

    private boolean isValidObjectID(String objectIDString) {
        return objectIDString != null && objectIDString.length() > 0;
    }

    private void sortInfoDegreeCurricularPlans(List<InfoDegreeCurricularPlan> infoDegreeCurricularPlans) {
        Collections.sort(infoDegreeCurricularPlans, new BeanComparator("name"));
    }

    private void sortInfoCurricularCourseEquivalences(List<CurricularCourseEquivalence> equivalences) {
        ComparatorChain chain = new ComparatorChain();
        chain.addComparator(CurricularCourseEquivalence.COMPARATOR_BY_EQUIVALENT_COURSE_NAME);
        chain.addComparator(CurricularCourseEquivalence.COMPARATOR_BY_EQUIVALENT_COURSE_CODE);
        Collections.sort(equivalences, chain);
    }

    private void sortInfoCurricularCourses(List<InfoCurricularCourse> infoCurricularCourses) {
        Collections.sort(infoCurricularCourses, InfoCurricularCourse.COMPARATOR_BY_NAME_AND_ID);
    }
}

