/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers.academicAdminOffice;

import java.util.HashSet;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.EditCandidacyInformationDA;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class ActiveAndRecentRegistrationsAndPhds
implements DataProvider {
    public Converter getConverter() {
        return null;
    }

    public Object provide(Object source, Object current) {
        EditCandidacyInformationDA.ChooseRegistrationOrPhd chooseRegistrationOrPhd = (EditCandidacyInformationDA.ChooseRegistrationOrPhd)source;
        Student student = chooseRegistrationOrPhd.getStudent();
        HashSet<EditCandidacyInformationDA.PhdRegistrationWrapper> phdRegistrationWrapperResult = new HashSet<EditCandidacyInformationDA.PhdRegistrationWrapper>();
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        for (PhdIndividualProgramProcess phdProcess : student.getPerson().getPhdIndividualProgramProcessesSet()) {
            ExecutionYear conclusionYear;
            if (!phdProcess.isAllowedToManageProcess(Authenticate.getUser())) continue;
            if (phdProcess.isProcessActive() && student.hasValidInsuranceEvent()) {
                phdRegistrationWrapperResult.add(new EditCandidacyInformationDA.PhdRegistrationWrapper(phdProcess));
                continue;
            }
            if (!phdProcess.isConcluded() || !this.matchesRecentExecutionYear(currentExecutionYear, conclusionYear = phdProcess.getConclusionYear())) continue;
            phdRegistrationWrapperResult.add(new EditCandidacyInformationDA.PhdRegistrationWrapper(phdProcess));
        }
        for (Registration registration : student.getActiveRegistrations()) {
            if (registration.getDegreeType().isEmpty() || !registration.isAllowedToManageRegistration()) continue;
            phdRegistrationWrapperResult.add(new EditCandidacyInformationDA.PhdRegistrationWrapper(registration));
        }
        for (Registration concludedRegistration : student.getConcludedRegistrations()) {
            if (concludedRegistration.getDegreeType().isEmpty() || !concludedRegistration.isBolonha() || !concludedRegistration.isAllowedToManageRegistration()) continue;
            ProgramConclusion.conclusionsFor(concludedRegistration).filter(ProgramConclusion::isTerminal).forEach(programConclusion -> {
                RegistrationConclusionBean conclusionBean = new RegistrationConclusionBean(concludedRegistration, (ProgramConclusion)((Object)programConclusion));
                ExecutionYear conclusionYear = conclusionBean.getConclusionYear();
                if (this.matchesRecentExecutionYear(currentExecutionYear, conclusionYear)) {
                    phdRegistrationWrapperResult.add(new EditCandidacyInformationDA.PhdRegistrationWrapper(concludedRegistration));
                }
            });
        }
        return phdRegistrationWrapperResult;
    }

    private boolean matchesRecentExecutionYear(ExecutionYear currentExecutionYear, ExecutionYear conclusionYear) {
        return conclusionYear == currentExecutionYear || conclusionYear == currentExecutionYear.getPreviousExecutionYear() || conclusionYear == currentExecutionYear.getPreviousExecutionYear().getPreviousExecutionYear();
    }
}

