/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.ArrayList;
import java.util.Collections;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.interfaces.HasDegreeType;
import org.fenixedu.academic.domain.interfaces.HasExecutionYear;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class ExecutionDegreeForExecutionYearAndDegreeTypeProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        ArrayList<ExecutionDegree> executionDegrees = new ArrayList<ExecutionDegree>();
        HasExecutionYear hasExecutionYear = (HasExecutionYear)source;
        HasDegreeType hasDegreeType = (HasDegreeType)source;
        ExecutionYear executionYear = hasExecutionYear.getExecutionYear();
        if (executionYear != null) {
            DegreeType degreeType = hasDegreeType.getDegreeType();
            for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
                if (degreeType != null && !this.match(degreeType, executionDegree)) continue;
                executionDegrees.add(executionDegree);
            }
        }
        Collections.sort(executionDegrees, ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME);
        return executionDegrees;
    }

    private boolean match(DegreeType degreeType, ExecutionDegree executionDegree) {
        return executionDegree.getDegreeType() == degreeType;
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

