/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.degreeStructure;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.ui.renderers.degreeStructure.DegreeCurricularPlanRenderer;
import org.fenixedu.academic.util.CurricularRuleLabelFormatter;
import org.fenixedu.academic.util.Pair;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlImage;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

abstract class DegreeCurricularPlanLayout
extends Layout {
    protected static final String EMPTY_CELL = "-";
    protected static final String SPACER_IMAGE_PATH = "/images/scp_spacer.gif";
    private static final int MAX_LINE_SIZE = 25;
    private static final int MAX_COL_SPAN_FOR_TEXT_ON_GROUPS_WITH_CHILDS = 21;
    private static final int MAX_COL_SPAN_FOR_TEXT_ON_CURRICULAR_COURSES = 21;
    private DegreeCurricularPlanRenderer degreeCurricularPlanRenderer;

    protected DegreeCurricularPlanLayout(DegreeCurricularPlanRenderer degreeCurricularPlanRenderer) {
        this.degreeCurricularPlanRenderer = degreeCurricularPlanRenderer;
    }

    protected int getMaxLineSize() {
        return 25;
    }

    protected int getMaxColSpanForTextOnGroupsWithChilds() {
        return 21;
    }

    protected int getMaxColSpanForTextOnCurricularCourses() {
        return 21;
    }

    protected int getMaxColSpanForOptionalCurricularCourse() {
        return 25 - this.getMaxColSpanForTextOnCurricularCourses() - 1;
    }

    protected DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlanRenderer.getDegreeCurricularPlan();
    }

    protected String getTabCellClass() {
        return this.degreeCurricularPlanRenderer.getTabCellClass();
    }

    protected String getDegreeCurricularPlanClass() {
        return this.degreeCurricularPlanRenderer.getDegreeCurricularPlanClass();
    }

    protected String roundValue(Double contactLoad) {
        return new BigDecimal(contactLoad).setScale(2, RoundingMode.HALF_EVEN).toPlainString();
    }

    protected boolean showRules() {
        return this.degreeCurricularPlanRenderer.showRules();
    }

    protected boolean showCourses() {
        return this.degreeCurricularPlanRenderer.showCourses();
    }

    protected ExecutionYear getExecutionInterval() {
        return this.degreeCurricularPlanRenderer.getExecutionInterval();
    }

    protected boolean hasExecutionInterval() {
        return this.getExecutionInterval() != null;
    }

    protected String getCurricularRuleRowClass() {
        return this.degreeCurricularPlanRenderer.getCurricularRuleRowClass();
    }

    protected String getCourseGroupRowClass() {
        return this.degreeCurricularPlanRenderer.getCourseGroupRowClass();
    }

    protected String getCurricularCourseRowClass() {
        return this.degreeCurricularPlanRenderer.getCurricularCourseRowClass();
    }

    protected String getCurriclarCourseCellClass() {
        return this.degreeCurricularPlanRenderer.getCurriclarCourseCellClass();
    }

    protected String getLabelCellClass() {
        return this.degreeCurricularPlanRenderer.getLabelCellClass();
    }

    protected String getCourseLoadCellClass() {
        return this.degreeCurricularPlanRenderer.getCourseLoadCellClass();
    }

    protected String getCurricularPeriodCellClass() {
        return this.degreeCurricularPlanRenderer.getCurricularPeriodCellClass();
    }

    protected String getRegimeCellClass() {
        return this.degreeCurricularPlanRenderer.getRegimeCellClass();
    }

    protected String getOptionalInformationCellClass() {
        return this.degreeCurricularPlanRenderer.getOptionalInformationCellClass();
    }

    protected String getEctsCreditsCellClass() {
        return this.degreeCurricularPlanRenderer.getEctsCreditsCellClass();
    }

    protected String getViewCurricularCourseUrl() {
        return this.degreeCurricularPlanRenderer.getViewCurricularCourseUrl();
    }

    protected List<Pair<String, String>> getViewCurricularCourseUrlParameters() {
        return this.degreeCurricularPlanRenderer.getViewCurricularCourseUrlParameters();
    }

    protected String getLabel(String key) {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)key, (String[])new String[0]);
    }

    protected String getDegreeModuleIdAttributeName() {
        return this.degreeCurricularPlanRenderer.getDegreeModuleIdAttributeName();
    }

    protected boolean isCurricularCourseLinkable() {
        return this.degreeCurricularPlanRenderer.isCurricularCourseLinkable();
    }

    public HtmlComponent createComponent(Object object, Class type) {
        HtmlBlockContainer container = new HtmlBlockContainer();
        this.draw(this.getDegreeCurricularPlan(), this.createMainTable((HtmlContainer)container));
        return container;
    }

    protected abstract void draw(DegreeCurricularPlan var1, HtmlTable var2);

    protected HtmlTable createMainTable(HtmlContainer container) {
        HtmlTable main = new HtmlTable();
        container.addChild((HtmlComponent)main);
        main.setClasses(this.getDegreeCurricularPlanClass());
        return main;
    }

    protected void addTabsToRow(HtmlTableRow row, int level) {
        for (int i = 0; i < level; ++i) {
            HtmlLink link = new HtmlLink();
            link.setModuleRelative(false);
            link.setUrl(SPACER_IMAGE_PATH);
            HtmlImage spacerImage = new HtmlImage();
            spacerImage.setSource(link.calculateUrl());
            HtmlTableCell tabCell = row.createCell();
            tabCell.setClasses(this.getTabCellClass());
            tabCell.setBody((HtmlComponent)spacerImage);
        }
    }

    protected void drawCurricularCourseName(CurricularCourse course, HtmlTableRow row, boolean linkable, int level) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getCurriclarCourseCellClass());
        cell.setColspan(Integer.valueOf(this.getMaxColSpanForTextOnCurricularCourses() - level));
        if (linkable) {
            HtmlLink result = new HtmlLink();
            result.setText(course.getNameI18N(this.getExecutionInterval()).getContent());
            result.setModuleRelative(true);
            result.setUrl(this.getViewCurricularCourseUrl());
            result.setParameter(this.getDegreeModuleIdAttributeName(), course.getExternalId());
            for (Pair<String, String> param : this.getViewCurricularCourseUrlParameters()) {
                result.setParameter(param.getKey(), param.getValue());
            }
            cell.setBody((HtmlComponent)result);
        } else {
            cell.setText(course.getNameI18N(this.getExecutionInterval()).getContent());
        }
    }

    protected void drawOptionalCellInformation(HtmlTableRow row) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getOptionalInformationCellClass());
        cell.setColspan(Integer.valueOf(this.getMaxColSpanForOptionalCurricularCourse()));
        cell.setText(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.degreeCurricularPlan.renderer.option", (String[])new String[0]));
    }

    protected void drawRegime(CurricularCourse course, HtmlTableRow row) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getRegimeCellClass());
        cell.setText(this.hasRegime(course) ? course.getRegime(this.getExecutionInterval()).getAcronym() : EMPTY_CELL);
        cell.setTitle(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.degreeCurricularPlan.renderer.title.regime", (String[])new String[0]));
    }

    private boolean hasRegime(CurricularCourse curricularCourse) {
        return !curricularCourse.isOptionalCurricularCourse() && curricularCourse.hasRegime(this.getExecutionInterval());
    }

    protected void drawCourseLoad(CurricularCourse course, CurricularPeriod period, HtmlTableRow row) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getCourseLoadCellClass());
        if (course.isOptionalCurricularCourse()) {
            cell.setText(EMPTY_CELL);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.degreeCurricularPlan.renderer.acronym.contact.load", (String[])new String[0])).append(EMPTY_CELL);
            builder.append(this.roundValue(course.getContactLoad(period, this.getExecutionInterval()))).append(" ");
            builder.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.degreeCurricularPlan.renderer.acronym.autonomous.work", (String[])new String[0])).append(EMPTY_CELL);
            builder.append(course.getAutonomousWorkHours(period, this.getExecutionInterval()).toString()).append(" ");
            builder.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.degreeCurricularPlan.renderer.acronym.total.load", (String[])new String[0])).append(EMPTY_CELL);
            builder.append(course.getTotalLoad(period, this.getExecutionInterval()));
            cell.setText(builder.toString());
        }
        cell.setTitle(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.degreeCurricularPlan.renderer.title.course.load", (String[])new String[0]));
    }

    protected void drawEctsCredits(CurricularCourse course, CurricularPeriod period, HtmlTableRow row) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getEctsCreditsCellClass());
        cell.setText(course.isOptionalCurricularCourse() ? EMPTY_CELL : course.getEctsCredits(period, this.getExecutionInterval()).toString());
    }

    protected void drawCurricularRulesRows(DegreeModule module, Context previous, HtmlTable main, int level) {
        if (this.showRules()) {
            for (CurricularRule rule : module.getVisibleCurricularRules(this.getExecutionInterval())) {
                if (!rule.appliesToContext(previous)) continue;
                this.drawCurricularRuleRow(rule, main, level);
            }
        }
    }

    protected void drawCurricularRuleRow(CurricularRule rule, HtmlTable main, int level) {
        HtmlTableRow groupRow = main.createRow();
        groupRow.setClasses(this.getCurricularRuleRowClass());
        this.addTabsToRow(groupRow, level);
        HtmlTableCell cell = groupRow.createCell();
        cell.setClasses(this.getLabelCellClass());
        cell.setColspan(Integer.valueOf(this.getMaxLineSize() - level));
        cell.setText(CurricularRuleLabelFormatter.getLabel(rule));
    }
}

