/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.sop.evaluation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.util.MessageResources;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseScope;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.InfoRoom;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.resourceAllocationManager.DefineExamComment;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.CreateWrittenEvaluation;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.EditWrittenEvaluation;
import org.fenixedu.academic.ui.faces.bean.sop.evaluation.ExecutionCourseWrittenEvaluationAgregationBean;
import org.fenixedu.academic.ui.faces.bean.teacher.evaluation.EvaluationManagementBackingBean;
import org.fenixedu.academic.ui.faces.components.util.CalendarLink;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.academic.util.Season;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;
import pt.ist.fenixframework.FenixFramework;

public class SOPEvaluationManagementBackingBean
extends EvaluationManagementBackingBean {
    private static final MessageResources messages = MessageResources.getMessageResources((String)"resources.ResourceAllocationManagerResources");
    private String academicInterval;
    protected HtmlInputHidden academicIntervalHidden;
    protected boolean disableDropDown;
    protected String executionDegreeID;
    protected HtmlInputHidden executionDegreeIdHidden;
    protected Integer curricularYearID;
    protected HtmlInputHidden curricularYearIdHidden;
    protected String curricularYearIDsParameterString;
    protected Integer calendarPeriod;
    protected HtmlInputHidden calendarPeriodHidden;
    private Integer[] curricularYearIDs;
    private final String chooseMessage = messages.getMessage(I18N.getLocale(), "label.choose.message");
    private HtmlInputHidden dayHidden;
    private HtmlInputHidden monthHidden;
    private HtmlInputHidden yearHidden;
    private HtmlInputHidden beginHourHidden;
    private HtmlInputHidden beginMinuteHidden;
    private HtmlInputHidden endHourHidden;
    private HtmlInputHidden endMinuteHidden;
    private Integer orderCriteria;
    private final String labelVacancies = messages.getMessage(I18N.getLocale(), "label.vacancies");
    private List<String> associatedExecutionCourses;
    private Map<String, String> associatedExecutionCoursesNames = new HashMap<String, String>();
    private Map<String, List<SelectItem>> curricularCourseScopesSelectItems = new HashMap<String, List<SelectItem>>();
    private Map<String, List<SelectItem>> curricularCourseContextSelectItems = new HashMap<String, List<SelectItem>>();
    private final Map<String, List<WrittenEvaluation>> writtenEvaluations = new HashMap<String, List<WrittenEvaluation>>();
    private final Map<String, Integer> writtenEvaluationsMissingPlaces = new HashMap<String, Integer>();
    private final Map<String, String> writtenEvaluationsRooms = new HashMap<String, String>();
    private final Map<String, Integer> executionCoursesEnroledStudents = new HashMap<String, Integer>();
    private String comment;
    private static final Comparator<SelectItem> COMPARATOR_BY_LABEL = new Comparator<SelectItem>(){

        @Override
        public int compare(SelectItem o1, SelectItem o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    };

    public String getAcademicInterval() {
        this.hackBecauseJSFareReallyReallyReallyGreatButWeDontKnowAtWhat();
        if (this.academicInterval == null && this.academicIntervalHidden.getValue() != null && !this.academicIntervalHidden.getValue().equals("")) {
            this.academicInterval = this.academicIntervalHidden.getValue().toString();
        } else if (this.getRequestAttribute("academicInterval") != null && !this.getRequestAttribute("academicInterval").equals("")) {
            this.academicInterval = this.getRequestAttribute("academicInterval").toString();
        } else if (this.getRequestParameter("academicInterval") != null && !this.getRequestParameter("academicInterval").equals("")) {
            this.academicInterval = this.getRequestParameter("academicInterval");
        }
        return this.academicInterval;
    }

    private void hackBecauseJSFareReallyReallyReallyGreatButWeDontKnowAtWhat() {
        String academicIntervalStr;
        AcademicInterval academicInterval = null;
        if (this.getRequestAttribute("academicInterval") != null) {
            String academicIntervalStr2 = (String)this.getRequestAttribute("academicInterval");
            academicInterval = AcademicInterval.getAcademicIntervalFromResumedString(academicIntervalStr2);
        } else if (this.getRequestParameter("academicInterval") != null && (academicIntervalStr = this.getRequestParameter("academicInterval")) != null && !academicIntervalStr.equals("null")) {
            String academicIntervalStrArg = academicIntervalStr.indexOf(45) > 0 ? academicIntervalStr.replaceAll("-", "_") : academicIntervalStr;
            academicInterval = AcademicInterval.getAcademicIntervalFromResumedString(academicIntervalStrArg);
        }
        if (academicInterval == null) {
            academicInterval = AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER);
        }
        this.setRequestAttribute("academicInterval", academicInterval.getResumedRepresentationInStringFormat());
    }

    public String getAcademicIntervalEscapeFriendly() {
        return this.getAcademicInterval().replaceAll("_", "-");
    }

    public void setAcademicInterval(String academicInterval) {
        if (academicInterval != null) {
            this.academicIntervalHidden.setValue((Object)academicInterval);
        }
        this.academicInterval = academicInterval;
    }

    public HtmlInputHidden getAcademicIntervalHidden() {
        if (this.academicIntervalHidden == null) {
            this.academicIntervalHidden = new HtmlInputHidden();
            this.academicIntervalHidden.setValue((Object)this.getAcademicInterval());
        }
        return this.academicIntervalHidden;
    }

    public void setAcademicIntervalHidden(HtmlInputHidden academicIntervalHidden) {
        if (academicIntervalHidden.getValue() != null && !((String)academicIntervalHidden.getValue()).isEmpty()) {
            this.academicInterval = academicIntervalHidden.getValue().toString();
        }
        this.academicIntervalHidden = academicIntervalHidden;
    }

    public String getAcademicIntervalLabel() {
        return this.getAcademicIntervalFromParameter(this.getAcademicInterval()).getPathName();
    }

    public boolean getDisableDropDown() {
        this.disableDropDown = this.getAcademicInterval() == null || this.getAcademicInterval().isEmpty() ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
        return this.disableDropDown;
    }

    public void setDisableDropDown(boolean disableDropDown) {
        this.disableDropDown = disableDropDown;
    }

    public String getExecutionDegreeID() {
        if (this.executionDegreeID == null && this.executionDegreeIdHidden.getValue() != null && !this.executionDegreeIdHidden.getValue().equals("")) {
            this.executionDegreeID = this.executionDegreeIdHidden.getValue().toString();
        } else if (this.getRequestAttribute("executionDegreeID") != null && !this.getRequestAttribute("executionDegreeID").equals("")) {
            this.executionDegreeID = this.getRequestAttribute("executionDegreeID").toString();
        } else if (this.getRequestParameter("executionDegreeID") != null && !this.getRequestParameter("executionDegreeID").equals("")) {
            this.executionDegreeID = this.getRequestParameter("executionDegreeID");
        }
        return this.executionDegreeID;
    }

    public void setExecutionDegreeID(String executionDegreeID) {
        if (executionDegreeID != null) {
            this.executionDegreeIdHidden = new HtmlInputHidden();
            this.executionDegreeIdHidden.setValue((Object)executionDegreeID);
        }
        this.executionDegreeID = executionDegreeID;
    }

    public HtmlInputHidden getExecutionDegreeIdHidden() {
        if (this.executionDegreeIdHidden == null) {
            this.executionDegreeIdHidden = new HtmlInputHidden();
            this.executionDegreeIdHidden.setValue((Object)this.getExecutionDegreeID());
        }
        return this.executionDegreeIdHidden;
    }

    public void setExecutionDegreeIdHidden(HtmlInputHidden executionDegreeIdHidden) {
        if (executionDegreeIdHidden != null && executionDegreeIdHidden.getValue() != null && !executionDegreeIdHidden.getValue().equals("")) {
            this.executionDegreeID = executionDegreeIdHidden.getValue().toString();
        }
        this.executionDegreeIdHidden = executionDegreeIdHidden;
    }

    public ExecutionDegree getExecutionDegree() {
        return (ExecutionDegree)FenixFramework.getDomainObject((String)this.getExecutionDegreeID());
    }

    public String getExecutionDegreeLabel() {
        return this.getExecutionDegree().getDegree().getPresentationName(this.getExecutionDegree().getExecutionYear());
    }

    public Integer getCurricularYearID() {
        if (this.curricularYearID == null && this.curricularYearIdHidden.getValue() != null && !this.curricularYearIdHidden.getValue().equals("")) {
            this.curricularYearID = Integer.valueOf(this.curricularYearIdHidden.getValue().toString());
        } else if (this.getRequestAttribute("curricularYearID") != null && !this.getRequestAttribute("curricularYearID").equals("")) {
            this.curricularYearID = Integer.valueOf(this.getRequestAttribute("curricularYearID").toString());
        } else if (this.getRequestParameter("curricularYearID") != null && !this.getRequestParameter("curricularYearID").equals("")) {
            this.curricularYearID = Integer.valueOf(this.getRequestParameter("curricularYearID"));
        }
        return this.curricularYearID;
    }

    public Integer getCalendarPeriod() {
        if (this.calendarPeriod == null && this.getCalendarPeriodHidden().getValue() != null && !this.calendarPeriodHidden.getValue().equals("")) {
            this.calendarPeriod = Integer.valueOf(this.getCalendarPeriodHidden().getValue().toString());
        } else if (this.getRequestAttribute("calendarPeriod") != null && !this.getRequestAttribute("calendarPeriod").equals("")) {
            this.calendarPeriod = Integer.valueOf(this.getRequestAttribute("calendarPeriod").toString());
        } else if (this.getRequestParameter("calendarPeriod") != null && !this.getRequestParameter("calendarPeriod").equals("")) {
            this.calendarPeriod = Integer.valueOf(this.getRequestParameter("calendarPeriod"));
        }
        return this.calendarPeriod;
    }

    public void setCurricularYearID(Integer curricularYearID) {
        if (curricularYearID != null) {
            this.curricularYearIdHidden = new HtmlInputHidden();
            this.curricularYearIdHidden.setValue((Object)curricularYearID);
        }
        this.curricularYearID = curricularYearID;
    }

    public void setCalendarPeriod(Integer calendarPeriod) {
        if (calendarPeriod != null) {
            this.calendarPeriodHidden = new HtmlInputHidden();
            this.calendarPeriodHidden.setValue((Object)calendarPeriod);
        }
        this.calendarPeriod = calendarPeriod;
    }

    public HtmlInputHidden getCurricularYearIdHidden() {
        if (this.curricularYearIdHidden == null) {
            this.curricularYearIdHidden = new HtmlInputHidden();
            this.curricularYearIdHidden.setValue((Object)this.getCurricularYearID());
        }
        return this.curricularYearIdHidden;
    }

    public HtmlInputHidden getCalendarPeriodHidden() {
        if (this.calendarPeriodHidden == null) {
            this.calendarPeriodHidden = new HtmlInputHidden();
            this.calendarPeriodHidden.setValue((Object)this.getCalendarPeriod());
        }
        return this.calendarPeriodHidden;
    }

    public void setCurricularYearIdHidden(HtmlInputHidden curricularYearIdHidden) {
        if (curricularYearIdHidden != null && curricularYearIdHidden.getValue() != null && !curricularYearIdHidden.getValue().equals("")) {
            this.curricularYearID = Integer.valueOf(curricularYearIdHidden.getValue().toString());
        }
        this.curricularYearIdHidden = curricularYearIdHidden;
    }

    public void setCalendarPeriodHidden(HtmlInputHidden calendarPeriodHidden) {
        if (calendarPeriodHidden != null && calendarPeriodHidden.getValue() != null && !calendarPeriodHidden.getValue().equals("")) {
            this.calendarPeriod = Integer.valueOf(calendarPeriodHidden.getValue().toString());
        }
        this.calendarPeriodHidden = calendarPeriodHidden;
    }

    public String getCurricularYear() {
        return this.getCurricularYearItems().get(this.getCurricularYearID()).getLabel();
    }

    public HtmlInputHidden getDayHidden() throws FenixServiceException {
        if (this.dayHidden == null) {
            this.dayHidden = new HtmlInputHidden();
            this.dayHidden.setValue((Object)this.getDay());
        }
        return this.dayHidden;
    }

    public void setDayHidden(HtmlInputHidden dayHidden) {
        String dayValue;
        if (dayHidden.getValue() != null && (dayValue = dayHidden.getValue().toString()).length() > 0) {
            this.day = Integer.valueOf(dayValue);
        }
        this.dayHidden = dayHidden;
    }

    public HtmlInputHidden getMonthHidden() throws FenixServiceException {
        if (this.monthHidden == null) {
            this.monthHidden = new HtmlInputHidden();
            this.monthHidden.setValue((Object)this.getMonth());
        }
        return this.monthHidden;
    }

    public void setMonthHidden(HtmlInputHidden monthHidden) {
        String monthValue;
        if (monthHidden.getValue() != null && (monthValue = monthHidden.getValue().toString()).length() > 0) {
            this.month = Integer.valueOf(monthValue);
        }
        this.monthHidden = monthHidden;
    }

    public HtmlInputHidden getYearHidden() throws FenixServiceException {
        if (this.yearHidden == null) {
            this.yearHidden = new HtmlInputHidden();
            this.yearHidden.setValue((Object)this.getYear());
        }
        return this.yearHidden;
    }

    public void setYearHidden(HtmlInputHidden yearHidden) {
        String yearValue;
        if (yearHidden.getValue() != null && (yearValue = yearHidden.getValue().toString()).length() > 0) {
            this.year = Integer.valueOf(yearValue);
        }
        this.yearHidden = yearHidden;
    }

    public HtmlInputHidden getBeginHourHidden() throws FenixServiceException {
        if (this.beginHourHidden == null) {
            this.beginHourHidden = new HtmlInputHidden();
            this.beginHourHidden.setValue((Object)this.getBeginHour());
        }
        return this.beginHourHidden;
    }

    public void setBeginHourHidden(HtmlInputHidden beginHourHidden) {
        if (beginHourHidden.getValue() != null) {
            this.beginHour = Integer.valueOf(beginHourHidden.getValue().toString());
        }
        this.beginHourHidden = beginHourHidden;
    }

    public HtmlInputHidden getBeginMinuteHidden() throws FenixServiceException {
        if (this.beginMinuteHidden == null) {
            this.beginMinuteHidden = new HtmlInputHidden();
            this.beginMinuteHidden.setValue((Object)this.getBeginMinute());
        }
        return this.beginMinuteHidden;
    }

    public void setBeginMinuteHidden(HtmlInputHidden beginMinuteHidden) {
        if (beginMinuteHidden.getValue() != null) {
            this.beginMinute = Integer.valueOf(beginMinuteHidden.getValue().toString());
        }
        this.beginMinuteHidden = beginMinuteHidden;
    }

    public HtmlInputHidden getEndHourHidden() throws FenixServiceException {
        if (this.endHourHidden == null) {
            this.endHourHidden = new HtmlInputHidden();
            this.endHourHidden.setValue((Object)this.getEndHour());
        }
        return this.endHourHidden;
    }

    public void setEndHourHidden(HtmlInputHidden endHourHidden) {
        if (endHourHidden.getValue() != null) {
            this.endHour = Integer.valueOf(endHourHidden.getValue().toString());
        }
        this.endHourHidden = endHourHidden;
    }

    public HtmlInputHidden getEndMinuteHidden() throws FenixServiceException {
        if (this.endMinuteHidden == null) {
            this.endMinuteHidden = new HtmlInputHidden();
            this.endMinuteHidden.setValue((Object)this.getEndMinute());
        }
        return this.endMinuteHidden;
    }

    public void setEndMinuteHidden(HtmlInputHidden endMinuteHidden) {
        if (endMinuteHidden.getValue() != null) {
            this.endMinute = Integer.valueOf(endMinuteHidden.getValue().toString());
        }
        this.endMinuteHidden = endMinuteHidden;
    }

    public List<SelectItem> getAcademicIntervals() throws FenixServiceException {
        List<AcademicInterval> academicIntervals = AcademicInterval.readActiveAcademicIntervals(AcademicPeriod.SEMESTER);
        Collections.sort(academicIntervals, AcademicInterval.COMPARATOR_BY_BEGIN_DATE);
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        result.add(new SelectItem((Object)0, this.chooseMessage));
        for (AcademicInterval academicInterval : academicIntervals) {
            String label = academicInterval.getPathName();
            result.add(new SelectItem((Object)academicInterval.getResumedRepresentationInStringFormat(), label));
        }
        return result;
    }

    public void enableDropDowns(ValueChangeEvent valueChangeEvent) {
        this.setAcademicInterval(valueChangeEvent.getNewValue().toString());
        if (StringUtils.isEmpty((String)((String)valueChangeEvent.getNewValue()))) {
            this.setDisableDropDown(true);
        } else {
            this.setDisableDropDown(false);
        }
        this.setExecutionDegreeID(null);
        this.setCurricularYearID(0);
    }

    public List<SelectItem> getExecutionDegrees() throws FenixServiceException {
        if (this.getDisableDropDown()) {
            return new ArrayList<SelectItem>();
        }
        List<ExecutionDegree> degrees = ExecutionDegree.filterByAcademicInterval(this.getAcademicIntervalFromParameter(this.getAcademicInterval()));
        return degrees.stream().sorted(ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME).map(executionDegree -> new SelectItem((Object)executionDegree.getExternalId(), executionDegree.getDegree().getPresentationName(executionDegree.getExecutionYear()))).collect(Collectors.toList());
    }

    private AcademicInterval getAcademicIntervalFromParameter(String academicInterval) {
        if (academicInterval.contains("-")) {
            return AcademicInterval.getAcademicIntervalFromResumedString(academicInterval.replaceAll("-", ":"));
        }
        return AcademicInterval.getAcademicIntervalFromResumedString(academicInterval);
    }

    public List<SelectItem> getCurricularYearItems() {
        if (this.getDisableDropDown()) {
            return new ArrayList<SelectItem>();
        }
        ArrayList<SelectItem> curricularYearItems = new ArrayList<SelectItem>(6);
        curricularYearItems.add(new SelectItem((Object)1, messages.getMessage(I18N.getLocale(), "label.year.first")));
        curricularYearItems.add(new SelectItem((Object)2, messages.getMessage(I18N.getLocale(), "label.year.second")));
        curricularYearItems.add(new SelectItem((Object)3, messages.getMessage(I18N.getLocale(), "label.year.third")));
        curricularYearItems.add(new SelectItem((Object)4, messages.getMessage(I18N.getLocale(), "label.year.fourth")));
        curricularYearItems.add(new SelectItem((Object)5, messages.getMessage(I18N.getLocale(), "label.year.fifth")));
        return curricularYearItems;
    }

    public List<SelectItem> getCalendarPeriodItems() {
        if (this.getDisableDropDown()) {
            return new ArrayList<SelectItem>();
        }
        ArrayList<SelectItem> calendarPeriodItems = new ArrayList<SelectItem>(7);
        calendarPeriodItems.add(new SelectItem((Object)0, messages.getMessage(I18N.getLocale(), "label.calendarPeriodItem.all")));
        calendarPeriodItems.add(new SelectItem((Object)1, messages.getMessage(I18N.getLocale(), "label.calendarPeriodItem.lesson.period")));
        calendarPeriodItems.add(new SelectItem((Object)2, messages.getMessage(I18N.getLocale(), "label.calendarPeriodItem.exam.period")));
        return calendarPeriodItems;
    }

    public void setNewValueExecutionDegreeID(ValueChangeEvent valueChangeEvent) {
        this.setExecutionDegreeID((String)valueChangeEvent.getNewValue());
    }

    public void setNewValueCurricularYearID(ValueChangeEvent valueChangeEvent) {
        this.setCurricularYearID((Integer)valueChangeEvent.getNewValue());
    }

    public void setNewValueCurricularYearIDs(ValueChangeEvent valueChangeEvent) {
        this.setCurricularYearIDs((Integer[])valueChangeEvent.getNewValue());
    }

    public Integer[] getCurricularYearIDParameters() {
        String curricularYearIDsParameterString = this.getRequestParameter("curricularYearIDsParameterString");
        if (curricularYearIDsParameterString != null && curricularYearIDsParameterString.length() > 0 && !curricularYearIDsParameterString.equals("null")) {
            String[] curricularYearIDsParameterStringTokens = curricularYearIDsParameterString.split(",");
            Integer[] curricularYearIDParameters = new Integer[curricularYearIDsParameterStringTokens.length];
            for (int i = 0; i < curricularYearIDParameters.length; ++i) {
                curricularYearIDParameters[i] = Integer.valueOf(curricularYearIDsParameterStringTokens[i]);
            }
            return curricularYearIDParameters;
        }
        return null;
    }

    public String getCurricularYearIDsParameterString() {
        Integer[] curricularYearIDs = this.getCurricularYearIDs();
        if (curricularYearIDs != null && curricularYearIDs.length > 0) {
            this.buildString(curricularYearIDs);
        }
        return this.curricularYearIDsParameterString;
    }

    private void buildString(Integer[] curricularYearIDs) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < curricularYearIDs.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(curricularYearIDs[i].toString());
        }
        this.curricularYearIDsParameterString = stringBuilder.toString();
    }

    public void setCurricularYearIDsParameterString(String curricularYearIDsParameterString) {
        this.curricularYearIDsParameterString = curricularYearIDsParameterString;
    }

    public Integer[] getCurricularYearIDs() {
        if (this.curricularYearIDs == null) {
            this.curricularYearIDs = (Integer[])this.getViewState().getAttribute("curricularYearIDs");
        }
        if (this.curricularYearIDs == null) {
            this.curricularYearIDs = this.getCurricularYearIDParameters();
        }
        return this.curricularYearIDs;
    }

    public void setCurricularYearIDs(Integer[] curricularYearIDs) {
        this.curricularYearIDs = curricularYearIDs;
        this.getViewState().setAttribute("curricularYearIDs", curricularYearIDs);
    }

    public void setNewValueCalendarPeriod(ValueChangeEvent valueChangeEvent) {
        this.setCalendarPeriod((Integer)valueChangeEvent.getNewValue());
    }

    public void setNewValueExecutionCourseID(ValueChangeEvent valueChangeEvent) {
        this.setExecutionCourseID((String)valueChangeEvent.getNewValue());
    }

    public boolean getRenderContextSelection() {
        return this.getAcademicInterval() != null && this.getExecutionDegreeID() != null && this.getCurricularYearIDs() != null && this.getCurricularYearIDs().length > 0;
    }

    public Date[] getWrittenEvaluationsCalendarBegin() {
        Integer calendarPeriod = this.getCalendarPeriod();
        ExecutionDegree executionDegree = this.getExecutionDegree();
        int resultSize = calendarPeriod == null || executionDegree == null ? 1 : 2;
        Date[] result = new Date[resultSize];
        if (calendarPeriod == null || executionDegree == null) {
            result[0] = this.getAcademicIntervalFromParameter(this.getAcademicInterval()).getStart().toDate();
        } else {
            int semester = AcademicInterval.getCardinalityOfAcademicInterval(AcademicInterval.getAcademicIntervalFromResumedString(this.getAcademicInterval()));
            if (calendarPeriod == 0) {
                result[0] = this.getAcademicIntervalFromParameter(this.getAcademicInterval()).getStart().toDate();
                if (semester == 1) {
                    result[1] = executionDegree.getPeriodExamsSpecialSeason().getStart();
                }
            } else if (calendarPeriod == 1) {
                OccupationPeriod occupationPeriod = semester == 1 ? executionDegree.getPeriodLessonsFirstSemester() : executionDegree.getPeriodLessonsSecondSemester();
                result[0] = occupationPeriod.getStart();
            } else if (calendarPeriod == 2) {
                OccupationPeriod occupationPeriod = semester == 1 ? executionDegree.getPeriodExamsFirstSemester() : executionDegree.getPeriodExamsSecondSemester();
                result[0] = occupationPeriod.getStart();
                result[1] = executionDegree.getPeriodExamsSpecialSeason().getStart();
            }
        }
        return result;
    }

    public Date[] getWrittenEvaluationsCalendarEnd() {
        Integer calendarPeriod = this.getCalendarPeriod();
        ExecutionDegree executionDegree = this.getExecutionDegree();
        int resultSize = calendarPeriod == null || executionDegree == null ? 1 : 2;
        Date[] result = new Date[resultSize];
        if (calendarPeriod == null || executionDegree == null) {
            result[0] = this.getAcademicIntervalFromParameter(this.getAcademicInterval()).getEnd().toDate();
        } else {
            int semester = AcademicInterval.getCardinalityOfAcademicInterval(AcademicInterval.getAcademicIntervalFromResumedString(this.getAcademicInterval()));
            if (calendarPeriod == 0) {
                result[0] = this.getAcademicIntervalFromParameter(this.getAcademicInterval()).getEnd().toDate();
                if (semester == 1) {
                    result[1] = executionDegree.getPeriodExamsSpecialSeason().getEnd();
                }
            } else if (calendarPeriod == 1) {
                OccupationPeriod occupationPeriod = semester == 1 ? executionDegree.getPeriodLessonsFirstSemester() : executionDegree.getPeriodLessonsSecondSemester();
                result[0] = occupationPeriod.getLastOccupationPeriodOfNestedPeriods().getEnd();
            } else if (calendarPeriod == 2) {
                OccupationPeriod occupationPeriod = semester == 1 ? executionDegree.getPeriodExamsFirstSemester() : executionDegree.getPeriodExamsSecondSemester();
                result[0] = occupationPeriod.getEnd();
                result[1] = executionDegree.getPeriodExamsSpecialSeason().getEnd();
            }
        }
        return result;
    }

    public List<CalendarLink> getWrittenTestsCalendarLink() throws FenixServiceException {
        ArrayList<CalendarLink> result = new ArrayList<CalendarLink>();
        Integer[] curricularYearIDs = this.getCurricularYearIDs();
        if (curricularYearIDs != null && this.getExecutionDegree() != null) {
            List<Integer> curricularYears = Arrays.asList(this.getCurricularYearIDs());
            DegreeCurricularPlan degreeCurricularPlan = this.getExecutionDegree().getDegreeCurricularPlan();
            for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
                for (Evaluation evaluation : executionCourse.getAssociatedEvaluationsSet()) {
                    WrittenEvaluation writtenEvaluation;
                    if (!(evaluation instanceof WrittenEvaluation) || !(writtenEvaluation = (WrittenEvaluation)((Object)evaluation)).hasScopeOrContextFor(curricularYears, degreeCurricularPlan)) continue;
                    CalendarLink calendarLink = new CalendarLink(executionCourse, writtenEvaluation, I18N.getLocale());
                    calendarLink.setLinkParameters(this.constructLinkParameters(executionCourse, writtenEvaluation));
                    result.add(calendarLink);
                }
            }
        }
        return result;
    }

    private Map<String, String> constructLinkParameters(ExecutionCourse executionCourse, WrittenEvaluation writtenEvaluation) {
        HashMap<String, String> linkParameters = new HashMap<String, String>();
        linkParameters.put("executionCourseID", executionCourse.getExternalId().toString());
        linkParameters.put("evaluationID", writtenEvaluation.getExternalId().toString());
        linkParameters.put("academicInterval", this.academicInterval);
        linkParameters.put("executionDegreeID", this.executionDegreeID.toString());
        linkParameters.put("curricularYearIDsParameterString", this.getCurricularYearIDsParameterString());
        linkParameters.put("evaluationTypeClassname", ((Object)((Object)writtenEvaluation)).getClass().getName());
        return linkParameters;
    }

    private List<ExecutionCourse> getExecutionCourses() throws FenixServiceException {
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        Integer[] curricularYears = this.getCurricularYearIDs();
        if (curricularYears != null) {
            for (Integer curricularYearID : curricularYears) {
                executionCourses.addAll(ExecutionCourse.filterByAcademicIntervalAndDegreeCurricularPlanAndCurricularYearAndName(this.getAcademicIntervalFromParameter(this.getAcademicInterval()), this.getExecutionDegree().getDegreeCurricularPlan(), CurricularYear.readByYear(curricularYearID), "%"));
            }
        }
        Collections.sort(executionCourses, new BeanComparator("sigla"));
        return executionCourses;
    }

    public List<ExecutionCourseWrittenEvaluationAgregationBean> getExecutionCourseWrittenEvaluationAgregationBeans() throws FenixServiceException {
        ArrayList<ExecutionCourseWrittenEvaluationAgregationBean> executionCourseWrittenEvaluationAgregationBean = new ArrayList<ExecutionCourseWrittenEvaluationAgregationBean>();
        Integer[] curricularYears = this.getCurricularYearIDs();
        if (curricularYears != null && this.getExecutionDegree() != null) {
            DegreeCurricularPlan degreeCurricularPlan = this.getExecutionDegree().getDegreeCurricularPlan();
            for (Integer curricularYearID : curricularYears) {
                ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
                executionCourses.addAll(ExecutionCourse.filterByAcademicIntervalAndDegreeCurricularPlanAndCurricularYearAndName(this.getAcademicIntervalFromParameter(this.getAcademicInterval()), this.getExecutionDegree().getDegreeCurricularPlan(), CurricularYear.readByYear(curricularYearID), "%"));
                for (ExecutionCourse executionCourse : executionCourses) {
                    TreeSet<WrittenEvaluation> writtenEvaluations = new TreeSet<WrittenEvaluation>(WrittenEvaluation.COMPARATOR_BY_BEGIN_DATE);
                    for (Evaluation evaluation : executionCourse.getAssociatedEvaluationsSet()) {
                        if (!(evaluation instanceof WrittenEvaluation)) continue;
                        WrittenEvaluation writtenEvaluation = (WrittenEvaluation)((Object)evaluation);
                        for (DegreeModuleScope scope : writtenEvaluation.getDegreeModuleScopes()) {
                            if (scope.getCurricularYear().intValue() != curricularYearID.intValue() || degreeCurricularPlan != scope.getCurricularCourse().getDegreeCurricularPlan()) continue;
                            writtenEvaluations.add(writtenEvaluation);
                        }
                    }
                    if (writtenEvaluations.isEmpty()) continue;
                    executionCourseWrittenEvaluationAgregationBean.add(new ExecutionCourseWrittenEvaluationAgregationBean(curricularYearID, executionCourse, writtenEvaluations));
                }
            }
        }
        Collections.sort(executionCourseWrittenEvaluationAgregationBean, ExecutionCourseWrittenEvaluationAgregationBean.COMPARATOR_BY_EXECUTION_COURSE_CODE_AND_CURRICULAR_YEAR);
        return executionCourseWrittenEvaluationAgregationBean;
    }

    public List<ExecutionCourse> getExecutionCoursesWithWrittenEvaluations() throws FenixServiceException {
        this.writtenEvaluations.clear();
        this.writtenEvaluationsMissingPlaces.clear();
        this.writtenEvaluationsRooms.clear();
        this.executionCoursesEnroledStudents.clear();
        ArrayList<ExecutionCourse> executionCoursesWithWrittenEvaluations = new ArrayList<ExecutionCourse>();
        Integer[] curricularYearIDs = this.getCurricularYearIDs();
        if (curricularYearIDs != null && this.getExecutionDegree() != null) {
            DegreeCurricularPlan degreeCurricularPlan = this.getExecutionDegree().getDegreeCurricularPlan();
            List<Integer> curricularYears = Arrays.asList(curricularYearIDs);
            for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
                ArrayList<WrittenEvaluation> executionCourseWrittenEvaluations = new ArrayList<WrittenEvaluation>();
                for (WrittenEvaluation writtenEvaluation : executionCourse.getAssociatedWrittenEvaluations()) {
                    if (!writtenEvaluation.hasScopeOrContextFor(curricularYears, degreeCurricularPlan)) continue;
                    executionCourseWrittenEvaluations.add(writtenEvaluation);
                }
                if (executionCourseWrittenEvaluations.isEmpty()) continue;
                Collections.sort(executionCourseWrittenEvaluations, WrittenEvaluation.COMPARATOR_BY_BEGIN_DATE);
                this.processWrittenTestAdditionalValues(executionCourse, executionCourseWrittenEvaluations);
                this.writtenEvaluations.put(executionCourse.getExternalId(), executionCourseWrittenEvaluations);
                executionCoursesWithWrittenEvaluations.add(executionCourse);
            }
        }
        return executionCoursesWithWrittenEvaluations;
    }

    private void processWrittenTestAdditionalValues(ExecutionCourse executionCourse, List<WrittenEvaluation> associatedWrittenEvaluations) {
        for (WrittenEvaluation writtenTest : associatedWrittenEvaluations) {
            int totalCapacity = 0;
            StringBuilder buffer = new StringBuilder(20);
            for (Space room : writtenTest.getAssociatedRooms()) {
                buffer.append(room.getName()).append("; ");
                totalCapacity += room.getMetadata("examCapacity").orElse(0).intValue();
            }
            if (buffer.length() > 0) {
                buffer.delete(buffer.length() - 2, buffer.length() - 1);
            }
            this.writtenEvaluationsRooms.put(writtenTest.getExternalId(), buffer.toString());
            int numberOfEnroledStudents = writtenTest.getCountStudentsEnroledAttendingExecutionCourses();
            this.executionCoursesEnroledStudents.put(writtenTest.getExternalId(), numberOfEnroledStudents);
            this.writtenEvaluationsMissingPlaces.put(writtenTest.getExternalId(), numberOfEnroledStudents - totalCapacity);
        }
    }

    public List<ExecutionCourse> getExecutionCoursesWithoutWrittenEvaluations() throws FenixServiceException {
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        Integer[] curricularYearIDs = this.getCurricularYearIDs();
        if (curricularYearIDs != null && this.getExecutionDegree() != null) {
            List<Integer> curricularYears = Arrays.asList(curricularYearIDs);
            DegreeCurricularPlan degreeCurricularPlan = this.getExecutionDegree().getDegreeCurricularPlan();
            for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
                if (!executionCourse.getAssociatedWrittenEvaluationsForScopeAndContext(curricularYears, degreeCurricularPlan).isEmpty()) continue;
                result.add(executionCourse);
            }
        }
        return result;
    }

    public List<SelectItem> getExecutionCoursesLabels() throws FenixServiceException {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
            result.add(new SelectItem((Object)executionCourse.getExternalId(), executionCourse.getNome()));
        }
        Collections.sort(result, COMPARATOR_BY_LABEL);
        result.add(0, new SelectItem((Object)0, this.chooseMessage));
        return result;
    }

    public String continueToCreateWrittenEvaluation() throws FenixServiceException {
        if (this.getEvaluationTypeClassname() == null || this.getExecutionCourseID() == null || this.getEvaluationTypeClassname().equals("noSelection")) {
            this.setErrorMessage("label.choose.request");
            return "";
        }
        return "createWrittenEvaluation";
    }

    public List<SelectItem> getEvaluationTypeClassnameLabels() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        result.add(new SelectItem((Object)"noSelection", this.chooseMessage));
        result.add(new SelectItem((Object)WrittenTest.class.getName(), messages.getMessage(I18N.getLocale(), "label.test")));
        result.add(new SelectItem((Object)Exam.class.getName(), messages.getMessage(I18N.getLocale(), "label.exam")));
        return result;
    }

    public List<SelectItem> getSeasonLabels() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        result.add(new SelectItem((Object)"noSelection", this.chooseMessage));
        result.add(new SelectItem((Object)"1\u00aa \u00c9poca", messages.getMessage(I18N.getLocale(), "property.exam.1stExam")));
        result.add(new SelectItem((Object)"2\u00aa \u00c9poca", messages.getMessage(I18N.getLocale(), "property.exam.2stExam")));
        result.add(new SelectItem((Object)"\u00c9poca Especial", messages.getMessage(I18N.getLocale(), "property.exam.specialSeasonExam")));
        return result;
    }

    public Integer getOrderCriteria() {
        if (this.orderCriteria == null) {
            this.orderCriteria = new Integer(0);
        }
        return this.orderCriteria;
    }

    public void setOrderCriteria(Integer orderCriteria) {
        this.orderCriteria = orderCriteria;
    }

    public List<SelectItem> getOrderByCriteriaItems() {
        MessageResources messageResources = MessageResources.getMessageResources((String)"resources.ResourceAllocationManagerResources");
        ArrayList<SelectItem> orderByCriteriaItems = new ArrayList<SelectItem>(3);
        orderByCriteriaItems.add(new SelectItem((Object)0, messageResources.getMessage("label.capacity")));
        orderByCriteriaItems.add(new SelectItem((Object)1, messageResources.getMessage("property.room.building")));
        orderByCriteriaItems.add(new SelectItem((Object)2, messageResources.getMessage("label.room.type")));
        return orderByCriteriaItems;
    }

    public String[] getChosenRoomsIDs() throws FenixServiceException {
        if (this.getViewState().getAttribute("chosenRoomsIDs") == null && this.getEvaluationID() != null) {
            ArrayList<String> associatedRooms = new ArrayList<String>();
            for (Space room : ((WrittenEvaluation)((Object)this.getEvaluation())).getAssociatedRooms()) {
                associatedRooms.add(room.getExternalId() + "-" + room.getMetadata("examCapacity").orElse(0));
            }
            String[] selectedRooms = new String[]{};
            this.setChosenRoomsIDs(associatedRooms.toArray(selectedRooms));
        }
        return (String[])this.getViewState().getAttribute("chosenRoomsIDs");
    }

    public void setChosenRoomsIDs(String[] chosenRoomsIDs) {
        this.getViewState().setAttribute("chosenRoomsIDs", chosenRoomsIDs);
    }

    public List<SelectItem> getRoomsSelectItems() throws FenixServiceException {
        ComparatorChain comparatorChain;
        Calendar examDate = Calendar.getInstance();
        examDate.set(1, this.getYear());
        examDate.set(2, this.getMonth() - 1);
        examDate.set(5, this.getDay());
        examDate.set(13, 0);
        examDate.set(14, 0);
        DiaSemana dayOfWeek = new DiaSemana(examDate.get(7));
        Calendar examStartTime = Calendar.getInstance();
        examStartTime.set(11, this.getBeginHour());
        examStartTime.set(12, this.getBeginMinute());
        examStartTime.set(13, 0);
        examStartTime.set(14, 0);
        Calendar examEndTime = Calendar.getInstance();
        examEndTime.set(11, this.getEndHour());
        examEndTime.set(12, this.getEndMinute());
        examEndTime.set(13, 0);
        examEndTime.set(14, 0);
        List<InfoRoom> availableInfoRoom = SpaceUtils.allocatableSpace(YearMonthDay.fromCalendarFields((Calendar)examDate), YearMonthDay.fromCalendarFields((Calendar)examDate), HourMinuteSecond.fromCalendarFields(examStartTime), HourMinuteSecond.fromCalendarFields(examEndTime), dayOfWeek, null, null, false);
        if (this.getEvaluationID() != null) {
            for (Space room : ((WrittenEvaluation)((Object)this.getEvaluation())).getAssociatedRooms()) {
                InfoRoom associatedRoom = InfoRoom.newInfoFromDomain(room);
                if (availableInfoRoom.contains(associatedRoom)) continue;
                availableInfoRoom.add(associatedRoom);
            }
        }
        if (this.getOrderCriteria() == 0) {
            comparatorChain = new ComparatorChain();
            comparatorChain.addComparator((Comparator)new ReverseComparator((Comparator)new BeanComparator("capacidadeExame")));
            comparatorChain.addComparator((Comparator)new BeanComparator("nome"));
            Collections.sort(availableInfoRoom, comparatorChain);
        } else if (this.getOrderCriteria() == 1) {
            comparatorChain = new ComparatorChain();
            comparatorChain.addComparator((Comparator)new ReverseComparator((Comparator)new BeanComparator("edificio")));
            comparatorChain.addComparator((Comparator)new BeanComparator("nome"));
            Collections.sort(availableInfoRoom, comparatorChain);
        } else if (this.getOrderCriteria() == 2) {
            comparatorChain = new ComparatorChain();
            comparatorChain.addComparator((Comparator)new ReverseComparator((Comparator)new BeanComparator("tipo")));
            comparatorChain.addComparator((Comparator)new BeanComparator("nome"));
            Collections.sort(availableInfoRoom, comparatorChain);
        }
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(availableInfoRoom.size());
        for (InfoRoom infoRoom : availableInfoRoom) {
            StringBuilder label = new StringBuilder();
            label.append(infoRoom.getNome());
            label.append("  ( ");
            label.append(infoRoom.getCapacidadeExame());
            label.append(" ");
            label.append(this.labelVacancies);
            label.append(", ");
            label.append(infoRoom.getEdificio());
            label.append(", ");
            label.append(infoRoom.getTipo());
            label.append(" )");
            String value = this.getRoomWithExamCapacityString(infoRoom);
            SelectItem selectItem = new SelectItem((Object)value, label.toString());
            items.add(selectItem);
        }
        return items;
    }

    private String getRoomID(String roomString) {
        return roomString.split("-")[0];
    }

    private String getRoomWithExamCapacityString(InfoRoom infoRoom) {
        return infoRoom.getExternalId() + "-" + infoRoom.getCapacidadeExame();
    }

    public String getAssociatedRooms() throws FenixServiceException {
        StringBuilder result = new StringBuilder();
        if (this.getChosenRoomsIDs() != null && this.getChosenRoomsIDs().length != 0) {
            for (String chosenRoomString : this.getChosenRoomsIDs()) {
                String chosenRoomID = this.getRoomID(chosenRoomString);
                Space room = (Space)FenixFramework.getDomainObject((String)chosenRoomID);
                result.append(room.getName());
                result.append("; ");
            }
            if (result.length() > 0) {
                result.delete(result.length() - 2, result.length() - 1);
            }
            return result.toString();
        }
        return messages.getMessage(I18N.getLocale(), "label.no.associated.rooms");
    }

    public String associateRoomToWrittenEvaluation() {
        return this.returnToCreateOrEdit();
    }

    public String createWrittenEvaluation() throws FenixServiceException {
        ArrayList<String> roomsIDs;
        ArrayList<String> degreeModuleScopeIDs;
        if (this.getSeason() != null && this.getSeason().equals("noSelection")) {
            this.setErrorMessage("label.choose.request");
            return "";
        }
        ArrayList<String> executionCourseIDs = new ArrayList<String>(this.getAssociatedExecutionCourses().size());
        if (!this.prepareArguments(executionCourseIDs, degreeModuleScopeIDs = new ArrayList<String>(), roomsIDs = new ArrayList<String>())) {
            return "";
        }
        Season season = this.getSeason() != null ? new Season(this.getSeason()) : null;
        try {
            CreateWrittenEvaluation.runCreateWrittenEvaluation(null, this.getBegin().getTime(), this.getBegin().getTime(), this.getEnd().getTime(), executionCourseIDs, degreeModuleScopeIDs, roomsIDs, null, season, this.getDescription());
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (e instanceof NotAuthorizedException) {
                errorMessage = "message.error.notAuthorized";
            }
            this.setErrorMessage(errorMessage);
            return "";
        }
        return WrittenTest.class.getSimpleName();
    }

    public boolean prepareArguments(List<String> executionCourseIDs, List<String> degreeModuleScopeIDs, List<String> roomsIDs) throws FenixServiceException {
        for (String executionCourseID : this.associatedExecutionCourses) {
            executionCourseIDs.add(executionCourseID.toString());
            if (this.getCurricularCourseScopesToAssociate().get(executionCourseID).length == 0 && this.getCurricularCourseContextToAssociate().get(executionCourseID).length == 0) {
                this.setErrorMessage("error.invalidCurricularCourseScope");
                return false;
            }
            for (String curricularCourseScopeId : this.getCurricularCourseScopesToAssociate().get(executionCourseID)) {
                degreeModuleScopeIDs.add(DegreeModuleScope.getKey(curricularCourseScopeId, CurricularCourseScope.class.getName()));
            }
            for (String curricularCourseContextId : this.getCurricularCourseContextToAssociate().get(executionCourseID)) {
                degreeModuleScopeIDs.add(DegreeModuleScope.getKey(curricularCourseContextId, Context.class.getName()));
            }
        }
        if (this.getChosenRoomsIDs() != null) {
            for (String roomIDString : this.getChosenRoomsIDs()) {
                String roomID = this.getRoomID(roomIDString);
                roomsIDs.add(roomID.toString());
            }
        }
        return true;
    }

    public String editWrittenEvaluation() throws FenixServiceException, IOException {
        ArrayList<String> roomsIDs;
        ArrayList<String> degreeModuleScopeIDs;
        if (this.getSeason() != null && this.getSeason().equals("noSelection")) {
            this.setErrorMessage("label.choose.request");
            return "";
        }
        ArrayList<String> executionCourseIDs = new ArrayList<String>(this.getAssociatedExecutionCourses().size());
        if (!this.prepareArguments(executionCourseIDs, degreeModuleScopeIDs = new ArrayList<String>(), roomsIDs = new ArrayList<String>())) {
            return "";
        }
        Season season = this.getSeason() != null ? new Season(this.getSeason()) : null;
        try {
            EditWrittenEvaluation.runEditWrittenEvaluation(null, this.getBegin().getTime(), this.getBegin().getTime(), this.getEnd().getTime(), executionCourseIDs, degreeModuleScopeIDs, roomsIDs, this.evaluationID, season, this.getDescription(), null);
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (e instanceof NotAuthorizedException) {
                errorMessage = "message.error.notAuthorized";
            }
            if (e instanceof DomainException) {
                DomainException domainException = (DomainException)((Object)e);
                this.setErrorMessageArguments(domainException.getArgs());
            }
            this.setErrorMessage(errorMessage);
            return "";
        }
        String originPage = this.getOriginPage();
        if (originPage != null && originPage.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getApplicationContext());
            stringBuilder.append("/resourceAllocationManager/searchWrittenEvaluationsByDate.do?method=returnToSearchPage&amp;page=0&date=");
            stringBuilder.append(DateFormatUtil.format("yyyy/MM/dd", this.getBegin().getTime()));
            if (this.getSelectedBegin() != null && this.getSelectedBegin().length() > 0 && this.getSelectedBegin().equals("true")) {
                stringBuilder.append("&selectedBegin=");
                stringBuilder.append(DateFormatUtil.format("HH:mm", this.getBegin().getTime()));
            }
            if (this.getSelectedEnd() != null && this.getSelectedEnd().length() > 0 && this.getSelectedEnd().equals("true")) {
                stringBuilder.append("&selectedEnd=");
                stringBuilder.append(DateFormatUtil.format("HH:mm", this.getEnd().getTime()));
            }
            stringBuilder.append("&academicInterval=").append(this.academicInterval);
            String url = stringBuilder.toString();
            String checksum = GenericChecksumRewriter.calculateChecksum((String)url, (HttpSession)this.getRequest().getSession());
            stringBuilder.append("&");
            stringBuilder.append("_request_checksum_");
            stringBuilder.append("=");
            stringBuilder.append(checksum);
            FacesContext.getCurrentInstance().getExternalContext().redirect(stringBuilder.toString());
            return originPage;
        }
        return WrittenTest.class.getSimpleName();
    }

    public void setAssociatedExecutionCourses(List<String> associatedExecutionCourses) {
        this.associatedExecutionCourses = associatedExecutionCourses;
        this.getViewState().setAttribute("associatedExecutionCourses", associatedExecutionCourses);
    }

    public List<String> getAssociatedExecutionCourses() throws FenixServiceException {
        if (this.getViewState().getAttribute("associatedExecutionCourses") != null) {
            this.associatedExecutionCourses = (List)this.getViewState().getAttribute("associatedExecutionCourses");
        } else if (this.getEvaluationID() != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (ExecutionCourse executionCourse : this.getEvaluation().getAssociatedExecutionCoursesSet()) {
                result.add(executionCourse.getExternalId());
                ArrayList<String> selectedScopes = new ArrayList<String>();
                ArrayList<String> selectedContexts = new ArrayList<String>();
                for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
                    for (DegreeModuleScope degreeModuleScope : curricularCourse.getDegreeModuleScopes()) {
                        if (!degreeModuleScope.isActiveForExecutionPeriod(executionCourse.getExecutionPeriod()) || !((WrittenEvaluation)((Object)this.getEvaluation())).getDegreeModuleScopes().contains(degreeModuleScope)) continue;
                        if (degreeModuleScope instanceof CurricularCourseScope.DegreeModuleScopeCurricularCourseScope) {
                            selectedScopes.add(degreeModuleScope.getExternalId());
                            continue;
                        }
                        if (!(degreeModuleScope instanceof Context.DegreeModuleScopeContext)) continue;
                        selectedContexts.add(degreeModuleScope.getExternalId());
                    }
                }
                String[] selected = new String[]{};
                this.getCurricularCourseScopesToAssociate().put(executionCourse.getExternalId(), selectedScopes.toArray(selected));
                this.getCurricularCourseContextToAssociate().put(executionCourse.getExternalId(), selectedContexts.toArray(selected));
            }
            this.setAssociatedExecutionCourses(result);
        } else {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.getExecutionCourse().getExternalId());
            this.setAssociatedExecutionCourses(result);
        }
        this.fillInAuxiliarMaps();
        return this.associatedExecutionCourses;
    }

    private void fillInAuxiliarMaps() throws FenixServiceException {
        for (String executionCourseID : this.associatedExecutionCourses) {
            ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
            this.associatedExecutionCoursesNames.put(executionCourseID, executionCourse.getNome());
            ArrayList<SelectItem> items = new ArrayList<SelectItem>();
            ArrayList<SelectItem> items2 = new ArrayList<SelectItem>();
            String[] curricularCourseScopesToAssociate = this.getCurricularCourseScopesToAssociate().get(executionCourse.getExternalId());
            String[] curricularCourseContextsToAssociate = this.getCurricularCourseContextToAssociate().get(executionCourse.getExternalId());
            ArrayList<Object> auxiliarArray = new ArrayList<Object>();
            ArrayList<Object> auxiliarArray2 = new ArrayList<Object>();
            if (curricularCourseScopesToAssociate != null) {
                for (String curricularCourseScopeToAssociate : curricularCourseScopesToAssociate) {
                    auxiliarArray.add(curricularCourseScopeToAssociate);
                }
            }
            if (curricularCourseContextsToAssociate != null) {
                for (String curricularCourseContextToAssociate : curricularCourseContextsToAssociate) {
                    auxiliarArray2.add(curricularCourseContextToAssociate);
                }
            }
            for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
                for (DegreeModuleScope degreeModuleScope : curricularCourse.getDegreeModuleScopes()) {
                    if (!degreeModuleScope.isActiveForExecutionPeriod(executionCourse.getExecutionPeriod())) continue;
                    StringBuilder label = new StringBuilder();
                    label.append(curricularCourse.getDegreeCurricularPlan().getName());
                    label.append(" ").append(degreeModuleScope.getCurricularYear()).append(" \ufffd Ano");
                    if (!degreeModuleScope.getBranch().equals("")) {
                        label.append(" ").append(degreeModuleScope.getBranch());
                    }
                    if (degreeModuleScope instanceof CurricularCourseScope.DegreeModuleScopeCurricularCourseScope) {
                        items.add(new SelectItem((Object)degreeModuleScope.getExternalId(), label.toString()));
                        continue;
                    }
                    if (!(degreeModuleScope instanceof Context.DegreeModuleScopeContext)) continue;
                    items2.add(new SelectItem((Object)degreeModuleScope.getExternalId(), label.toString()));
                }
            }
            this.curricularCourseScopesSelectItems.put(executionCourse.getExternalId(), items);
            this.curricularCourseContextSelectItems.put(executionCourse.getExternalId(), items2);
            String[] selected = new String[]{};
            this.getCurricularCourseScopesToAssociate().put(executionCourse.getExternalId(), auxiliarArray.toArray(selected));
            this.getCurricularCourseContextToAssociate().put(executionCourse.getExternalId(), auxiliarArray2.toArray(selected));
        }
    }

    public Map<String, List<SelectItem>> getCurricularCourseContextSelectItems() {
        return this.curricularCourseContextSelectItems;
    }

    public void setCurricularCourseContextSelectItems(Map<String, List<SelectItem>> curricularCourseContextSelectItems) {
        this.curricularCourseContextSelectItems = curricularCourseContextSelectItems;
    }

    public Map<String, List<SelectItem>> getCurricularCourseScopesSelectItems() {
        return this.curricularCourseScopesSelectItems;
    }

    public void setCurricularCourseScopesSelectItems(Map<String, List<SelectItem>> curricularCourseScopesSelectItems) {
        this.curricularCourseScopesSelectItems = curricularCourseScopesSelectItems;
    }

    public Map<String, String[]> getCurricularCourseScopesToAssociate() {
        if (this.getViewState().getAttribute("curricularCourseScopesToAssociate") == null) {
            this.getViewState().setAttribute("curricularCourseScopesToAssociate", new HashMap());
        }
        return (Map)this.getViewState().getAttribute("curricularCourseScopesToAssociate");
    }

    public void setCurricularCourseScopesToAssociate(Map<String, String[]> curricularCourseScopesToAssociate) {
        this.getViewState().setAttribute("curricularCourseScopesToAssociate", curricularCourseScopesToAssociate);
    }

    public Map<String, String[]> getCurricularCourseContextToAssociate() {
        if (this.getViewState().getAttribute("curricularCourseContextToAssociate") == null) {
            this.getViewState().setAttribute("curricularCourseContextToAssociate", new HashMap());
        }
        return (Map)this.getViewState().getAttribute("curricularCourseContextToAssociate");
    }

    public void setCurricularCourseContextToAssociate(Map<String, String[]> curricularCourseContextToAssociate) {
        this.getViewState().setAttribute("curricularCourseContextToAssociate", curricularCourseContextToAssociate);
    }

    public String associateExecutionCourse() throws FenixServiceException {
        String integer;
        if (this.getSelectedExecutionDegreeID() == null || this.getSelectedCurricularYearID() == null || this.getSelectedExecutionCourseID() == null || this.getSelectedCurricularYearID() == 0) {
            this.setErrorMessage("label.choose.request");
            return "";
        }
        List<String> list = this.getAssociatedExecutionCourses();
        if (!list.contains(integer = this.getSelectedExecutionCourseID())) {
            list.add(integer);
        }
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)integer);
        ArrayList<String> auxiliarArray = new ArrayList<String>();
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            for (DegreeModuleScope degreeModuleScope : curricularCourse.getDegreeModuleScopes()) {
                auxiliarArray.add(degreeModuleScope.getExternalId());
            }
        }
        String[] selected = new String[]{};
        this.getCurricularCourseScopesToAssociate().put(executionCourse.getExternalId(), auxiliarArray.toArray(selected));
        return this.returnToCreateOrEdit();
    }

    public void disassociateExecutionCourse() throws FenixServiceException {
        List<String> associatedExecutionCourses = this.getAssociatedExecutionCourses();
        String executionCourseToDisassociate = this.getRequestParameter("executionCourseToDisassociate");
        associatedExecutionCourses.remove(executionCourseToDisassociate);
        this.setAssociatedExecutionCourses(associatedExecutionCourses);
        this.getCurricularCourseScopesToAssociate().remove(executionCourseToDisassociate);
    }

    public String returnToCreateOrEdit() {
        if (this.getEvaluationID() == null) {
            return "createWrittenTest";
        }
        return "editWrittenTest";
    }

    public Map<String, String> getAssociatedExecutionCoursesNames() {
        return this.associatedExecutionCoursesNames;
    }

    public void setAssociatedExecutionCoursesNames(Map<String, String> associatedExecutionCoursesNames) {
        this.associatedExecutionCoursesNames = associatedExecutionCoursesNames;
    }

    public Map<String, List<WrittenEvaluation>> getWrittenEvaluations() {
        return this.writtenEvaluations;
    }

    public Map<String, Integer> getWrittenEvaluationsFreeSpace() {
        return this.writtenEvaluationsMissingPlaces;
    }

    public Map<String, String> getWrittenEvaluationsRooms() {
        return this.writtenEvaluationsRooms;
    }

    public String getComment() throws FenixServiceException {
        if (this.comment == null && this.getExecutionCourse() != null) {
            this.comment = this.getExecutionCourse().getComment();
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String commentExecutionCourse() throws FenixServiceException {
        try {
            DefineExamComment.run(this.getExecutionCourse().getSigla(), this.getExecutionCourse().getExecutionPeriod().getExternalId(), this.getComment());
        }
        catch (FenixServiceException e) {
            this.setErrorMessage(e.getMessage());
            return "";
        }
        return "writtenEvaluationCalendar";
    }

    public String getSelectedExecutionDegreeID() {
        String selectedExecutionDegreeID = (String)this.getViewState().getAttribute("selectedExecutionDegreeID");
        if (selectedExecutionDegreeID == null) {
            selectedExecutionDegreeID = this.getExecutionDegreeIdHidden().getValue().toString();
            this.setSelectedExecutionDegreeID(selectedExecutionDegreeID);
        }
        return selectedExecutionDegreeID;
    }

    public void setSelectedExecutionDegreeID(String selectedExecutionDegreeID) {
        this.getViewState().setAttribute("selectedExecutionDegreeID", selectedExecutionDegreeID);
    }

    public Integer getSelectedCurricularYearID() {
        Integer[] curricularYears;
        Integer selectedCurricularYearID = (Integer)this.getViewState().getAttribute("selectedCurricularYearID");
        if (selectedCurricularYearID == null && (curricularYears = this.getCurricularYearIDs()) != null && curricularYears.length != 0) {
            selectedCurricularYearID = curricularYears[0];
            this.setSelectedCurricularYearID(selectedCurricularYearID);
        }
        return selectedCurricularYearID;
    }

    public void setSelectedCurricularYearID(Integer selectedCurricularYearID) {
        this.getViewState().setAttribute("selectedCurricularYearID", selectedCurricularYearID);
        this.curricularYearID = selectedCurricularYearID;
    }

    public String getSelectedExecutionCourseID() {
        String selectedExecutionCourseID = (String)this.getViewState().getAttribute("selectedExecutionCourseID");
        if (selectedExecutionCourseID == null) {
            selectedExecutionCourseID = (String)this.getExecutionCourseIdHidden().getValue();
            this.setSelectedExecutionCourseID(selectedExecutionCourseID);
        }
        return selectedExecutionCourseID;
    }

    public void setSelectedExecutionCourseID(String selectedExecutionCourseID) {
        this.getViewState().setAttribute("selectedExecutionCourseID", selectedExecutionCourseID);
    }

    public void onExecutionDegreeChanged(ValueChangeEvent valueChangeEvent) {
        this.setSelectedExecutionDegreeID((String)valueChangeEvent.getNewValue());
    }

    public void onCurricularYearChanged(ValueChangeEvent valueChangeEvent) {
        this.setSelectedCurricularYearID((Integer)valueChangeEvent.getNewValue());
    }

    public void onExecutionCourseChanged(ValueChangeEvent valueChangeEvent) {
        this.setSelectedExecutionCourseID((String)valueChangeEvent.getNewValue());
    }

    private List<ExecutionCourse> readExecutionCourses() throws FenixServiceException {
        ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)this.getSelectedExecutionDegreeID());
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        executionCourses.addAll(ExecutionCourse.filterByAcademicIntervalAndDegreeCurricularPlanAndCurricularYearAndName(this.getAcademicIntervalFromParameter(this.getAcademicInterval()), executionDegree.getDegreeCurricularPlan(), CurricularYear.readByYear(this.curricularYearID), "%"));
        Collections.sort(executionCourses, new BeanComparator("sigla"));
        return executionCourses;
    }

    public List<SelectItem> getExecutionCoursesItems() throws FenixServiceException {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (ExecutionCourse executionCourse : this.readExecutionCourses()) {
            result.add(new SelectItem((Object)executionCourse.getExternalId(), executionCourse.getNome()));
        }
        Collections.sort(result, new BeanComparator("label"));
        result.add(0, new SelectItem((Object)0, this.chooseMessage));
        return result;
    }

    public Map<String, Integer> getExecutionCoursesEnroledStudents() {
        return this.executionCoursesEnroledStudents;
    }

    public String getSelectedDateString() throws FenixServiceException {
        return new LocalDate(this.getYear().intValue(), this.getMonth().intValue(), this.getDay().intValue()).toString("dd/MM/yyyy");
    }

    public String getSelectedBeginHourString() throws FenixServiceException {
        return new HourMinuteSecond(this.getBeginHour(), this.getBeginMinute(), 0).toString("HH:mm");
    }

    public String getSelectedEndHourString() throws FenixServiceException {
        return new HourMinuteSecond(this.getEndHour(), this.getEndMinute(), 0).toString("HH:mm");
    }
}

