/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.manager.degree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.faces.component.UISelectItems;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degree.degreeCurricularPlan.DegreeCurricularPlanState;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.manager.CreateExecutionDegreesForExecutionYear;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.util.Data;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import pt.ist.fenixframework.FenixFramework;

public class CreateExecutionDegreesForExecutionYearBean
extends FenixBackingBean {
    private String chosenDegreeType;
    private String[] choosenDegreeCurricularPlansIDs;
    private String[] choosenBolonhaDegreeCurricularPlansIDs;
    private UISelectItems degreeCurricularPlansSelectItems;
    public UISelectItems bolonhaDegreeCurricularPlansSelectItems;
    private String campus;
    private Boolean temporaryExamMap;
    private List<DegreeCurricularPlan> createdDegreeCurricularPlans;

    public List<SelectItem> getDegreeTypes() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        result.add(new SelectItem((Object)"dropDown.Default", BundleUtil.getString((String)"resources.EnumerationResources", (String)"dropDown.Default", (String[])new String[0])));
        DegreeType.all().forEach(type -> result.add(new SelectItem((Object)type.getExternalId(), type.getName().getContent())));
        return result;
    }

    public String getChosenDegreeType() {
        return this.chosenDegreeType;
    }

    public void setChosenDegreeType(String chosenDegreeType) {
        this.chosenDegreeType = chosenDegreeType;
    }

    public UISelectItems getDegreeCurricularPlansSelectItems() {
        if (this.degreeCurricularPlansSelectItems == null) {
            ArrayList<SelectItem> result;
            DegreeType degreeType = this.getDegreeType(this.getChosenDegreeType());
            if (degreeType == null) {
                result = Collections.EMPTY_LIST;
            } else {
                result = new ArrayList<SelectItem>();
                List<DegreeCurricularPlan> toShow = DegreeCurricularPlan.readByDegreeTypeAndState(Predicate.isEqual(degreeType), DegreeCurricularPlanState.ACTIVE);
                Collections.sort(toShow, DegreeCurricularPlan.DEGREE_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_EXECUTION_DEGREE_AND_DEGREE_CODE);
                for (DegreeCurricularPlan degreeCurricularPlan : toShow) {
                    result.add(new SelectItem((Object)degreeCurricularPlan.getExternalId(), degreeType.getName().getContent() + " " + degreeCurricularPlan.getDegree().getName() + " - " + degreeCurricularPlan.getName()));
                }
            }
            this.degreeCurricularPlansSelectItems = new UISelectItems();
            this.degreeCurricularPlansSelectItems.setValue(result);
        }
        return this.degreeCurricularPlansSelectItems;
    }

    public void setDegreeCurricularPlansSelectItems(UISelectItems degreeCurricularPlansSelectItems) {
        this.degreeCurricularPlansSelectItems = degreeCurricularPlansSelectItems;
    }

    public UISelectItems getBolonhaDegreeCurricularPlansSelectItems() {
        if (this.bolonhaDegreeCurricularPlansSelectItems == null) {
            DegreeType bolonhaDegreeType = (DegreeType)FenixFramework.getDomainObject((String)this.getChosenDegreeType());
            ArrayList<DegreeCurricularPlan> toShow = new ArrayList<DegreeCurricularPlan>();
            for (Degree degree : Degree.readBolonhaDegrees()) {
                if (degree.getDegreeType() != bolonhaDegreeType) continue;
                for (DegreeCurricularPlan degreeCurricularPlan : degree.getActiveDegreeCurricularPlans()) {
                    if (degreeCurricularPlan.isDraft()) continue;
                    toShow.add(degreeCurricularPlan);
                }
            }
            Collections.sort(toShow, DegreeCurricularPlan.DEGREE_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_EXECUTION_DEGREE_AND_DEGREE_CODE);
            ArrayList<SelectItem> result = new ArrayList<SelectItem>();
            for (DegreeCurricularPlan degreeCurricularPlan : toShow) {
                result.add(new SelectItem((Object)degreeCurricularPlan.getExternalId(), bolonhaDegreeType.getName().getContent() + " " + degreeCurricularPlan.getDegree().getName() + " - " + degreeCurricularPlan.getName()));
            }
            this.bolonhaDegreeCurricularPlansSelectItems = new UISelectItems();
            this.bolonhaDegreeCurricularPlansSelectItems.setValue(result);
        }
        return this.bolonhaDegreeCurricularPlansSelectItems;
    }

    public void setBolonhaDegreeCurricularPlansSelectItems(UISelectItems bolonhaDegreeCurricularPlansSelectItems) {
        this.bolonhaDegreeCurricularPlansSelectItems = bolonhaDegreeCurricularPlansSelectItems;
    }

    private DegreeType getDegreeType(String chosenDegreeType) {
        return (DegreeType)FenixFramework.getDomainObject((String)chosenDegreeType);
    }

    public List getExecutionYears() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (ExecutionYear executionYear : ExecutionYear.readNotClosedExecutionYears()) {
            result.add(new SelectItem((Object)executionYear.getExternalId(), executionYear.getYear()));
        }
        if (this.getChoosenExecutionYearID() == null && result.size() > 0) {
            this.setChoosenExecutionYearID(ExecutionYear.readCurrentExecutionYear().getExternalId());
        }
        return result;
    }

    public void onChoosenExecutionYearChanged(ValueChangeEvent valueChangeEvent) {
        this.setChoosenExecutionYearID((String)valueChangeEvent.getNewValue());
    }

    public List getAllCampus() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (Space campus : Space.getAllCampus()) {
            result.add(new SelectItem((Object)campus.getName(), campus.getName()));
        }
        return result;
    }

    public String createExecutionDegrees() throws FenixActionException {
        try {
            this.createdDegreeCurricularPlans = CreateExecutionDegreesForExecutionYear.run(this.getChoosenDegreeCurricularPlansIDs(), this.getChoosenBolonhaDegreeCurricularPlansIDs(), this.getChoosenExecutionYearID(), this.getCampus(), this.getTemporaryExamMap() == false);
        }
        catch (IllegalDataAccessException e) {
            throw new FenixActionException(e);
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getKey(), (String[])e.getArgs()));
            this.setChoosenDegreeCurricularPlansIDs(null);
            return "";
        }
        return "success";
    }

    public List<DegreeCurricularPlan> getCreatedDegreeCurricularPlans() {
        return this.createdDegreeCurricularPlans;
    }

    public List getDays() {
        return Data.getMonthDaysSelectItems();
    }

    public List getMonths() {
        return Data.getMonthsSelectItems();
    }

    public List getYears() {
        return Data.getExpirationYearsSelectItems();
    }

    public String[] getChoosenDegreeCurricularPlansIDs() {
        return this.choosenDegreeCurricularPlansIDs;
    }

    public void setChoosenDegreeCurricularPlansIDs(String[] choosenDegreeCurricularPlansIDs) {
        this.choosenDegreeCurricularPlansIDs = choosenDegreeCurricularPlansIDs;
    }

    public String[] getChoosenBolonhaDegreeCurricularPlansIDs() {
        return this.choosenBolonhaDegreeCurricularPlansIDs;
    }

    public void setChoosenBolonhaDegreeCurricularPlansIDs(String[] choosenBolonhaDegreeCurricularPlansIDs) {
        this.choosenBolonhaDegreeCurricularPlansIDs = choosenBolonhaDegreeCurricularPlansIDs;
    }

    public ExecutionYear getChoosenExecutionYear() {
        return (ExecutionYear)FenixFramework.getDomainObject((String)this.getChoosenExecutionYearID());
    }

    public String getChoosenExecutionYearID() {
        return (String)this.getViewState().getAttribute("choosenExecutionYearID");
    }

    public void setChoosenExecutionYearID(String choosenExecutionYearID) {
        this.getViewState().setAttribute("choosenExecutionYearID", choosenExecutionYearID);
    }

    public String getCampus() {
        return this.campus;
    }

    public void setCampus(String campus) {
        this.campus = campus;
    }

    public Boolean getTemporaryExamMap() {
        return this.temporaryExamMap;
    }

    public void setTemporaryExamMap(Boolean temporaryExamMap) {
        this.temporaryExamMap = temporaryExamMap;
    }
}

