/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularRules;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UISelectItems;
import javax.faces.model.SelectItem;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.util.LogicOperator;
import org.fenixedu.academic.service.services.bolonhaManager.CreateCompositeRule;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularRules.CurricularRulesManagementBackingBean;
import org.fenixedu.academic.util.CurricularRuleLabelFormatter;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class CompositeRulesManagementBackingBean
extends CurricularRulesManagementBackingBean {
    private UISelectItems curricularRuleItems;
    private UISelectItems beginExecutionPeriodItemsForCompositeRule;
    private UISelectItems endExecutionPeriodItemsForCompositeRule;

    public String[] getSelectedCurricularRuleIDs() {
        return (String[])this.getViewState().getAttribute("selectedCurricularRuleIDs");
    }

    public void setSelectedCurricularRuleIDs(String[] selectedCurricularRuleIDs) {
        this.getViewState().setAttribute("selectedCurricularRuleIDs", selectedCurricularRuleIDs);
    }

    private void removeSelectedCurricularRuleIDs() {
        this.getViewState().removeAttribute("selectedCurricularRuleIDs");
    }

    public String getSelectedLogicOperator() {
        if (this.getViewState().getAttribute("selectedLogicOperator") == null) {
            this.setSelectedLogicOperator("AND");
        }
        return (String)this.getViewState().getAttribute("selectedLogicOperator");
    }

    public void setSelectedLogicOperator(String selectedLogicOperator) {
        this.getViewState().setAttribute("selectedLogicOperator", selectedLogicOperator);
    }

    public UISelectItems getCurricularRuleItems() throws FenixServiceException {
        if (this.curricularRuleItems == null) {
            this.curricularRuleItems = new UISelectItems();
            this.curricularRuleItems.setValue(this.readCurricularRulesLabels());
        }
        return this.curricularRuleItems;
    }

    public void setCurricularRuleItems(UISelectItems curricularRuleItems) {
        this.curricularRuleItems = curricularRuleItems;
    }

    private List<SelectItem> readCurricularRulesLabels() throws FenixServiceException {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (CurricularRule curricularRule : this.getDegreeModule().getCurricularRulesSet()) {
            result.add(new SelectItem((Object)curricularRule.getExternalId(), CurricularRuleLabelFormatter.getLabel(curricularRule)));
        }
        return result;
    }

    public UISelectItems getBeginExecutionPeriodItemsForCompositeRule() throws FenixServiceException {
        if (this.beginExecutionPeriodItemsForCompositeRule == null) {
            this.beginExecutionPeriodItemsForCompositeRule = new UISelectItems();
            this.beginExecutionPeriodItemsForCompositeRule.setValue(this.readExecutionPeriodItems());
        }
        return this.beginExecutionPeriodItemsForCompositeRule;
    }

    public void setBeginExecutionPeriodItemsForCompositeRule(UISelectItems beginExecutionPeriodItemsForCompositeRule) {
        this.beginExecutionPeriodItemsForCompositeRule = beginExecutionPeriodItemsForCompositeRule;
    }

    public UISelectItems getEndExecutionPeriodItemsForCompositeRule() throws FenixServiceException {
        if (this.endExecutionPeriodItemsForCompositeRule == null) {
            this.endExecutionPeriodItemsForCompositeRule = new UISelectItems();
            ArrayList<SelectItem> values = new ArrayList<SelectItem>(this.readExecutionPeriodItems());
            values.add(0, new SelectItem((Object)"-1", BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"opened", (String[])new String[0])));
            this.endExecutionPeriodItemsForCompositeRule.setValue(values);
        }
        return this.endExecutionPeriodItemsForCompositeRule;
    }

    public void setEndExecutionPeriodItemsForCompositeRule(UISelectItems endExecutionPeriodItemsForCompositeRule) {
        this.endExecutionPeriodItemsForCompositeRule = endExecutionPeriodItemsForCompositeRule;
    }

    public String createCompositeRule() {
        try {
            CreateCompositeRule.run(LogicOperator.valueOf(this.getSelectedLogicOperator()), this.getSelectedCurricularRuleIDs());
            this.setSelectedCurricularRuleIDs(new String[0]);
            this.getCurricularRuleItems().setValue(this.readCurricularRulesLabels());
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.notAuthorized", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }
}

