/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.enrollment.shift;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.dto.ShiftToEnrol;
import org.fenixedu.academic.service.filter.enrollment.ClassEnrollmentAuthorizationFilter;
import org.fenixedu.academic.service.services.enrollment.shift.ReadShiftsToEnroll$callable$runReadShiftsToEnroll;
import org.fenixedu.academic.service.services.enrollment.shift.ReadShiftsToEnroll$callable$runReadShiftsToEnroll$1;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReadShiftsToEnroll {
    private static final ReadShiftsToEnroll serviceInstance;
    public static final Advice advice$runReadShiftsToEnroll;
    public static final Advice advice$runReadShiftsToEnroll$1;

    protected List run(Registration registration, ExecutionSemester executionSemester) throws FenixServiceException {
        this.checkStudentRestrictionsForShiftsEnrolments(registration);
        ArrayList<ShiftToEnrol> result = new ArrayList<ShiftToEnrol>();
        for (Attends attends : registration.readAttendsByExecutionPeriod(executionSemester)) {
            result.add(this.buildShiftToEnrol(attends));
        }
        return result;
    }

    private void checkStudentRestrictionsForShiftsEnrolments(Registration registration) throws FenixServiceException {
        if (registration == null) {
            throw new FenixServiceException("errors.impossible.operation");
        }
        if (TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(registration.getPerson(), new LocalDate()) && !registration.getInterruptedStudies()) {
            throw new FenixServiceException("error.exception.notAuthorized.student.warningTuition");
        }
        if (registration.getFlunked()) {
            throw new FenixServiceException("error.exception.notAuthorized.student.warningTuition");
        }
    }

    private ShiftToEnrol buildShiftToEnrol(Attends attends) {
        ShiftToEnrol result = new ShiftToEnrol();
        this.findShiftTypesFromExecutionCourse(attends, result);
        this.findShiftsForExecutionCourseShiftTypesFromStudentEnroledShifts(attends, result);
        result.setExecutionCourse(attends.getExecutionCourse());
        result.setEnrolled(attends.getEnrolment() != null);
        return result;
    }

    private void findShiftsForExecutionCourseShiftTypesFromStudentEnroledShifts(Attends attend, ShiftToEnrol result) {
        for (Shift shift : attend.getRegistration().getShiftsSet()) {
            this.setShiftInformation(attend, result, shift);
        }
    }

    private void findShiftTypesFromExecutionCourse(Attends attend, ShiftToEnrol result) {
        for (Shift shift : attend.getExecutionCourse().getAssociatedShifts()) {
            this.setShiftTypeInformation(result, shift);
        }
    }

    private void setShiftTypeInformation(ShiftToEnrol result, Shift shift) {
        if (shift.containsType(ShiftType.TEORICA)) {
            result.setTheoricType(ShiftType.TEORICA);
        } else if (shift.containsType(ShiftType.PRATICA)) {
            result.setPraticType(ShiftType.PRATICA);
        } else if (shift.containsType(ShiftType.LABORATORIAL)) {
            result.setLaboratoryType(ShiftType.LABORATORIAL);
        } else if (shift.containsType(ShiftType.TEORICO_PRATICA)) {
            result.setTheoricoPraticType(ShiftType.TEORICO_PRATICA);
        } else if (shift.containsType(ShiftType.FIELD_WORK)) {
            result.setFieldWorkType(ShiftType.FIELD_WORK);
        } else if (shift.containsType(ShiftType.PROBLEMS)) {
            result.setProblemsType(ShiftType.PROBLEMS);
        } else if (shift.containsType(ShiftType.SEMINARY)) {
            result.setSeminaryType(ShiftType.SEMINARY);
        } else if (shift.containsType(ShiftType.TRAINING_PERIOD)) {
            result.setTrainingType(ShiftType.TRAINING_PERIOD);
        } else if (shift.containsType(ShiftType.TUTORIAL_ORIENTATION)) {
            result.setTutorialOrientationType(ShiftType.TUTORIAL_ORIENTATION);
        }
    }

    private void setShiftInformation(Attends attend, ShiftToEnrol result, Shift shift) {
        if (shift.getExecutionCourse() == attend.getExecutionCourse() && shift.containsType(ShiftType.TEORICA)) {
            result.setTheoricShift(shift);
        } else if (shift.getExecutionCourse() == attend.getExecutionCourse() && shift.containsType(ShiftType.PRATICA)) {
            result.setPraticShift(shift);
        } else if (shift.getExecutionCourse() == attend.getExecutionCourse() && shift.containsType(ShiftType.LABORATORIAL)) {
            result.setLaboratoryShift(shift);
        } else if (shift.getExecutionCourse() == attend.getExecutionCourse() && shift.containsType(ShiftType.TEORICO_PRATICA)) {
            result.setTheoricoPraticShift(shift);
        } else if (shift.getExecutionCourse() == attend.getExecutionCourse() && shift.containsType(ShiftType.FIELD_WORK)) {
            result.setFieldWorkShift(shift);
        } else if (shift.getExecutionCourse() == attend.getExecutionCourse() && shift.containsType(ShiftType.PROBLEMS)) {
            result.setProblemsShift(shift);
        } else if (shift.getExecutionCourse() == attend.getExecutionCourse() && shift.containsType(ShiftType.SEMINARY)) {
            result.setSeminaryShift(shift);
        } else if (shift.getExecutionCourse() == attend.getExecutionCourse() && shift.containsType(ShiftType.TRAINING_PERIOD)) {
            result.setTrainingShift(shift);
        } else if (shift.getExecutionCourse() == attend.getExecutionCourse() && shift.containsType(ShiftType.TUTORIAL_ORIENTATION)) {
            result.setTutorialOrientationShift(shift);
        }
    }

    public static List runReadShiftsToEnroll(Registration registration) throws FenixServiceException, NotAuthorizedException {
        return (List)advice$runReadShiftsToEnroll.perform((Callable)new ReadShiftsToEnroll$callable$runReadShiftsToEnroll(registration));
    }

    static /* synthetic */ List advised$runReadShiftsToEnroll(Registration registration) throws FenixServiceException, NotAuthorizedException {
        ClassEnrollmentAuthorizationFilter.instance.execute(registration);
        return serviceInstance.run(registration, ExecutionSemester.readActualExecutionSemester());
    }

    public static List runReadShiftsToEnroll(Registration registration, ExecutionSemester executionSemester) throws FenixServiceException, NotAuthorizedException {
        return (List)advice$runReadShiftsToEnroll$1.perform((Callable)new ReadShiftsToEnroll$callable$runReadShiftsToEnroll$1(registration, executionSemester));
    }

    static /* synthetic */ List advised$runReadShiftsToEnroll(Registration registration, ExecutionSemester executionSemester) throws FenixServiceException, NotAuthorizedException {
        ClassEnrollmentAuthorizationFilter.instance.execute(registration, executionSemester);
        return serviceInstance.run(registration, executionSemester);
    }

    static {
        advice$runReadShiftsToEnroll = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runReadShiftsToEnroll$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new ReadShiftsToEnroll();
    }
}

