/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CourseLoadRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class CourseLoadRequestDocument
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 10L;
    protected static final String DD = "dd";
    protected static final String MMMM_YYYY = "MMMM yyyy";

    protected CourseLoadRequestDocument(CourseLoadRequest documentRequest) {
        super((IDocumentRequest)((Object)documentRequest));
    }

    protected CourseLoadRequest getDocumentRequest() {
        return (CourseLoadRequest)((Object)super.getDocumentRequest());
    }

    @Override
    protected void fillReport() {
        this.addParameter("certification", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.certification", (String[])new String[0]).toUpperCase());
        this.addParameter("certificationMessage", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.program.certificate.certification", (String[])new String[0]));
        this.setPersonFields();
        this.fillInstitutionAndStaffFields();
        this.setFooter((DocumentRequest)((Object)this.getDocumentRequest()));
        this.addParametersInformation();
    }

    private void addParametersInformation() {
        AdministrativeOffice administrativeOffice = this.getAdministrativeOffice();
        Person coordinator = administrativeOffice.getCoordinator().getPerson();
        Person student = this.getDocumentRequest().getPerson();
        UniversityUnit university = UniversityUnit.getInstitutionsUniversityUnit();
        String coordinatorGender = this.getCoordinatorGender(coordinator);
        String labelStudent = student.isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.of.student.male", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.of.student.female", (String[])new String[0]);
        String coordinatorName = coordinator.getName();
        String adminOfficeUnitName = this.getI18NText(administrativeOffice.getName()).toUpperCase();
        String universityName = this.getMLSTextContent(university.getPartyName()).toUpperCase();
        String institutionName = this.getInstitutionName().toUpperCase();
        String template = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.courseLoad.personalData.first", (String[])new String[0]);
        String firstPart = MessageFormat.format(template, coordinatorName, coordinatorGender, adminOfficeUnitName, institutionName, universityName, labelStudent);
        this.addParameter("firstPart", firstPart);
        this.addParameter("secondPart", student.getName());
        this.addParameter("thirdPart", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.with.number", (String[])new String[0]));
        this.addParameter("fourthPart", this.getStudentNumber());
        this.addParameter("fifthPart", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.of.male", (String[])new String[0]));
        this.addParameter("sixthPart", this.getDegreeDescription());
        this.addParameter("seventhPart", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.courseLoad.endMessage", (String[])new String[0]));
        this.addLabelsToMultiLanguage();
        this.createCourseLoadsList();
    }

    private void addLabelsToMultiLanguage() {
        this.addParameter("enrolment", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.serviceRequests.enrolment", (String[])new String[0]));
        this.addParameter("year", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.year", (String[])new String[0]));
        this.addParameter("autonomousWork", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.autonomousWork", (String[])new String[0]));
        this.addParameter("courseLoad", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.courseLoad", (String[])new String[0]));
        this.addParameter("total", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.total.amount", (String[])new String[0]));
        this.addParameter("tTotal", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.total", (String[])new String[0]));
        this.addParameter("lectures", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.lectures", (String[])new String[0]));
        this.addParameter("practices", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.patrice", (String[])new String[0]));
        this.addParameter("lecturesPractice", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.lecturesPractice", (String[])new String[0]));
        this.addParameter("laboratory", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.laboratory", (String[])new String[0]));
        this.addParameter("dissertations", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.courseLoad.dissertations", (String[])new String[0]));
    }

    @Override
    protected String getDegreeDescription() {
        CycleType requestedCycle = this.getDocumentRequest().getRequestedCycle();
        if (requestedCycle == null) {
            Registration registration = this.getDocumentRequest().getRegistration();
            DegreeType degreeType = registration.getDegreeType();
            CycleType cycleType = degreeType.hasExactlyOneCycleType() ? degreeType.getCycleType() : registration.getCycleType(this.getExecutionYear());
            return registration.getDegreeDescription(this.getExecutionYear(), cycleType, this.getLocale());
        }
        return this.getDocumentRequest().getRegistration().getDegreeDescription(this.getExecutionYear(), requestedCycle, this.getLocale());
    }

    private String getStudentNumber() {
        String agreementInformation;
        Registration registration = this.getDocumentRequest().getRegistration();
        if (registration.getRegistrationProtocol().isMilitaryAgreement() && !StringUtils.isEmpty((String)(agreementInformation = registration.getAgreementInformation()))) {
            return registration.getRegistrationProtocol().getCode() + " " + agreementInformation;
        }
        return registration.getStudent().getNumber().toString();
    }

    private void createCourseLoadsList() {
        ArrayList<BolonhaCourseLoadEntry> bolonha = new ArrayList<BolonhaCourseLoadEntry>();
        ArrayList<PreBolonhaCourseLoadEntry> preBolonha = new ArrayList<PreBolonhaCourseLoadEntry>();
        ArrayList<BolonhaCourseLoadEntry> dissertations = new ArrayList<BolonhaCourseLoadEntry>();
        this.addParameter("bolonhaList", bolonha);
        this.addParameter("preBolonhaList", preBolonha);
        this.addParameter("dissertationsList", dissertations);
        for (Enrolment enrolment : this.getDocumentRequest().getEnrolmentsSet()) {
            if (enrolment.isBolonhaDegree()) {
                if (enrolment.isDissertation()) {
                    dissertations.add(new BolonhaCourseLoadEntry(enrolment));
                    continue;
                }
                bolonha.add(new BolonhaCourseLoadEntry(enrolment));
                continue;
            }
            preBolonha.add(new PreBolonhaCourseLoadEntry(enrolment));
        }
        Collections.sort(bolonha);
        Collections.sort(preBolonha);
        Collections.sort(dissertations);
    }

    @Override
    protected boolean showPriceFields() {
        return false;
    }

    @Override
    protected void setPersonFields() {
        this.addParameter("name", this.getDocumentRequest().getPerson().getName());
    }

    public class PreBolonhaCourseLoadEntry
    extends CourseLoadEntry {
        private Double theoreticalHours;
        private Double praticalHours;
        private Double labHours;
        private Double theoPratHours;

        public PreBolonhaCourseLoadEntry(Enrolment enrolment) {
            super(enrolment.getCurricularCourse().getName(), enrolment.getExecutionYear().getYear());
            this.initInformation(enrolment.getCurricularCourse(), enrolment.getExecutionYear());
        }

        private void initInformation(CurricularCourse curricularCourse, ExecutionYear executionYear) {
            this.setCurricularCourseName(curricularCourse.getNameI18N(executionYear).getContent(CourseLoadRequestDocument.this.getLanguage()));
            this.setTheoreticalHours(curricularCourse.getTheoreticalHours());
            this.setPraticalHours(curricularCourse.getPraticalHours());
            this.setLabHours(curricularCourse.getLabHours());
            this.setTheoPratHours(curricularCourse.getTheoPratHours());
            this.setTotal(this.calculateTotal(curricularCourse));
        }

        public Double getLabHours() {
            return this.labHours;
        }

        public void setLabHours(Double labHours) {
            this.labHours = labHours;
        }

        public Double getPraticalHours() {
            return this.praticalHours;
        }

        public void setPraticalHours(Double praticalHours) {
            this.praticalHours = praticalHours;
        }

        public Double getTheoPratHours() {
            return this.theoPratHours;
        }

        public void setTheoPratHours(Double theoPratHours) {
            this.theoPratHours = theoPratHours;
        }

        public Double getTheoreticalHours() {
            return this.theoreticalHours;
        }

        public void setTheoreticalHours(Double theoreticalHours) {
            this.theoreticalHours = theoreticalHours;
        }

        private Double calculateTotal(CurricularCourse curricularCourse) {
            double result = 0.0;
            result += curricularCourse.getTheoreticalHours().doubleValue();
            result += curricularCourse.getPraticalHours().doubleValue();
            result += curricularCourse.getLabHours().doubleValue();
            return result += curricularCourse.getTheoPratHours().doubleValue();
        }
    }

    public class BolonhaCourseLoadEntry
    extends CourseLoadEntry {
        private Double contactLoad;
        private Double autonomousWork;

        public BolonhaCourseLoadEntry(Enrolment enrolment) {
            super(enrolment.getCurricularCourse().getName(), enrolment.getExecutionYear().getYear());
            CurricularCourse curricularCourse = enrolment.getCurricularCourse();
            this.setCurricularCourseName(curricularCourse.getNameI18N(enrolment.getExecutionYear()).getContent(CourseLoadRequestDocument.this.getLanguage()));
            this.setContactLoad(curricularCourse.getContactLoad(enrolment.getExecutionPeriod()));
            this.setAutonomousWork(curricularCourse.getAutonomousWorkHours(enrolment.getExecutionPeriod()));
            this.setTotal(curricularCourse.getTotalLoad(enrolment.getExecutionPeriod()));
        }

        public Double getAutonomousWork() {
            return this.autonomousWork;
        }

        public void setAutonomousWork(Double autonomousWork) {
            this.autonomousWork = autonomousWork;
        }

        public Double getContactLoad() {
            return this.contactLoad;
        }

        public void setContactLoad(Double contactLoad) {
            this.contactLoad = contactLoad;
        }
    }

    public abstract class CourseLoadEntry
    implements Comparable<CourseLoadEntry> {
        private String curricularCourseName;
        private String year;
        private Double total;

        protected CourseLoadEntry(String name, String year) {
            this.curricularCourseName = name;
            this.year = year;
        }

        public String getCurricularCourseName() {
            return this.curricularCourseName;
        }

        public void setCurricularCourseName(String curricularCourseName) {
            this.curricularCourseName = curricularCourseName;
        }

        public String getYear() {
            return this.year;
        }

        public void setYear(String year) {
            this.year = year;
        }

        @Override
        public int compareTo(CourseLoadEntry other) {
            return this.getCurricularCourseName().compareTo(other.getCurricularCourseName());
        }

        public Double getTotal() {
            return this.total;
        }

        public void setTotal(Double total) {
            this.total = total;
        }

        public Boolean getCourseLoadCorrect() {
            return this.total != 0.0;
        }

        CourseLoadEntry create(Enrolment enrolment) {
            if (enrolment.isBolonhaDegree()) {
                return new BolonhaCourseLoadEntry(enrolment);
            }
            return new PreBolonhaCourseLoadEntry(enrolment);
        }
    }
}

